/*     */ package org.jboss.ejb3.metamodel;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metamodel.descriptor.DDObjectFactory;
/*     */ import org.jboss.metamodel.descriptor.EjbRef;
/*     */ import org.jboss.metamodel.descriptor.EnvEntry;
/*     */ import org.jboss.metamodel.descriptor.MessageDestinationRef;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class ApplicationClientDDObjectFactory extends DDObjectFactory
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ApplicationClientDDObjectFactory.class);
/*     */ 
/*     */   public static ApplicationClientDD parse(URL ddResource)
/*     */     throws JBossXBException, IOException
/*     */   {
/*  60 */     if (ddResource == null) {
/*  61 */       return null;
/*     */     }
/*  63 */     log.debug("found application-client.xml " + ddResource);
/*     */ 
/*  65 */     ApplicationClientDDObjectFactory factory = new ApplicationClientDDObjectFactory();
/*  66 */     UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
/*  67 */     Unmarshaller unmarshaller = unmarshallerFactory.newUnmarshaller();
/*  68 */     unmarshaller.setEntityResolver(new JBossEntityResolver());
/*  69 */     unmarshaller.setNamespaceAware(true);
/*  70 */     unmarshaller.setSchemaValidation(true);
/*  71 */     unmarshaller.setValidation(true);
/*     */ 
/*  73 */     ApplicationClientDD dd = (ApplicationClientDD)unmarshaller.unmarshal(ddResource.openStream(), factory, null);
/*     */ 
/*  75 */     return dd;
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  80 */     parent.addEjbRef(ref);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, EnvEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  88 */     parent.addEnvEntry(entry);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, LifecycleCallback lifecycleCallback, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  93 */     if (localName.equals("post-construct"))
/*  94 */       parent.getPostConstructs().add(lifecycleCallback);
/*  95 */     else if (localName.equals("pre-destroy"))
/*  96 */       parent.getPreDestroys().add(lifecycleCallback);
/*  97 */     else throw new IllegalArgumentException(localName);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, MessageDestination dest, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 102 */     parent.addMessageDestination(dest);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 107 */     parent.addMessageDestinationRef(ref);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, ServiceRefMetaData serviceref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 113 */     parent.addServiceRef(serviceref);
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/* 118 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public Object newChild(ApplicationClientDD parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 123 */     Object child = super.newEnvRefGroupChild(localName);
/* 124 */     if (child != null) {
/* 125 */       return child;
/*     */     }
/* 127 */     if ((localName.equals("post-construct")) || (localName.equals("pre-destroy")))
/*     */     {
/* 129 */       child = new LifecycleCallback();
/*     */     }
/* 131 */     else if (localName.equals("message-destination"))
/*     */     {
/* 133 */       child = new MessageDestination();
/*     */     }
/*     */ 
/* 138 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*     */     ApplicationClientDD dd;
/* 144 */     if (root == null)
/*     */     {
/*     */       ApplicationClientDD dd;
/* 145 */       root = dd = new ApplicationClientDD(); } else {
/* 146 */       dd = (ApplicationClientDD)root;
/*     */     }
/* 148 */     if (attrs.getLength() > 0)
/*     */     {
/* 150 */       for (int i = 0; i < attrs.getLength(); i++)
/*     */       {
/* 152 */         if (attrs.getLocalName(i).equals("version"))
/*     */         {
/* 154 */           dd.setVersion(attrs.getValue(i));
/*     */         }
/* 156 */         else if (attrs.getLocalName(i).equals("metadata-complete"))
/*     */         {
/* 158 */           dd.setMetadataComplete(Boolean.parseBoolean(attrs.getValue(i)));
/*     */         } else {
/* 160 */           if (attrs.getLocalName(i).equals("schemaLocation"))
/*     */           {
/*     */             continue;
/*     */           }
/* 164 */           if (attrs.getLocalName(i).equals("id"))
/*     */           {
/*     */             continue;
/*     */           }
/* 168 */           throw new IllegalArgumentException(attrs.getLocalName(i));
/*     */         }
/*     */       }
/*     */     }
/* 172 */     return root;
/*     */   }
/*     */ 
/*     */   public void setValue(ApplicationClientDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 180 */     if (localName.equals("display-name"))
/*     */     {
/* 182 */       dd.setDisplayName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(LifecycleCallback lifecycleCallback, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 194 */     if (localName.equals("lifecycle-callback-class"))
/* 195 */       lifecycleCallback.setLifecycleCallbackClass(value);
/* 196 */     else if (localName.equals("lifecycle-callback-method"))
/* 197 */       lifecycleCallback.setLifecycleCallbackMethod(value);
/* 198 */     else throw new IllegalArgumentException(localName);
/*     */   }
/*     */ 
/*     */   public void setValue(MessageDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 203 */     if (localName.equals("message-destination-name"))
/*     */     {
/* 205 */       destination.setMessageDestinationName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.ApplicationClientDDObjectFactory
 * JD-Core Version:    0.6.0
 */