/*     */ package org.jboss.ejb3.mdb.inflow;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.ejb.TransactionAttribute;
/*     */ import javax.ejb.TransactionAttributeType;
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import javax.resource.spi.UnavailableException;
/*     */ import javax.resource.spi.endpoint.MessageEndpoint;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.KernelAbstraction;
/*     */ import org.jboss.ejb3.KernelAbstractionFactory;
/*     */ import org.jboss.ejb3.mdb.MessagingContainer;
/*     */ import org.jboss.ejb3.tx.TxUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ 
/*     */ public class JBossMessageEndpointFactory
/*     */   implements MessageEndpointFactory
/*     */ {
/*  62 */   private static final Logger log = Logger.getLogger(JBossMessageEndpointFactory.class);
/*     */ 
/*  65 */   protected boolean trace = log.isTraceEnabled();
/*     */   protected MessagingContainer container;
/*  71 */   protected Map<String, org.jboss.metadata.ActivationConfigPropertyMetaData> properties = new HashMap();
/*     */   protected Class<?> messagingTypeClass;
/*     */   protected String resourceAdapterName;
/*     */   protected ObjectName resourceAdapterObjectName;
/*     */   protected ActivationSpec activationSpec;
/*     */   protected Class[] interfaces;
/*  89 */   protected SynchronizedInt nextProxyId = new SynchronizedInt(0);
/*     */ 
/*  94 */   protected String[] createActivationSpecSig = { Class.class.getName(), Collection.class.getName() };
/*     */ 
/* 101 */   protected String[] activationSig = { MessageEndpointFactory.class.getName(), ActivationSpec.class.getName() };
/*     */ 
/*     */   public MessagingContainer getContainer()
/*     */   {
/* 122 */     return this.container;
/*     */   }
/*     */ 
/*     */   public MessageEndpoint createEndpoint(XAResource resource)
/*     */     throws UnavailableException
/*     */   {
/* 129 */     this.trace = log.isTraceEnabled();
/*     */ 
/* 131 */     if (this.trace) {
/* 132 */       log.trace("createEndpoint " + this + " xaResource=" + resource);
/*     */     }
/* 134 */     MessageEndpoint endpoint = createProxy(resource);
/*     */ 
/* 136 */     if (this.trace) {
/* 137 */       log.trace("Created endpoint " + endpoint + " from " + this);
/*     */     }
/* 139 */     return endpoint;
/*     */   }
/*     */ 
/*     */   protected MessageEndpoint createProxy(XAResource resource)
/*     */   {
/*     */     try
/*     */     {
/* 146 */       Class proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), this.interfaces);
/*     */ 
/* 148 */       Class[] constructorParams = { InvocationHandler.class };
/* 149 */       Constructor proxyConstructor = proxyClass.getConstructor(constructorParams);
/*     */ 
/* 151 */       MessageInflowLocalProxy proxy = new MessageInflowLocalProxy(this.container);
/* 152 */       proxy.setXaResource(resource);
/* 153 */       proxy.setMessageEndpointFactory(this);
/*     */ 
/* 155 */       Object[] args = { proxy };
/* 156 */       MessageEndpoint endpoint = (MessageEndpoint)proxyConstructor.newInstance(args);
/* 157 */       return endpoint;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 161 */       e.printStackTrace();
/* 162 */     }return null;
/*     */   }
/*     */ 
/*     */   public boolean isDeliveryTransacted(Method method)
/*     */     throws NoSuchMethodException
/*     */   {
/* 168 */     TransactionManagementType mtype = TxUtil.getTransactionManagementType(this.container);
/* 169 */     if (mtype == TransactionManagementType.BEAN) return false;
/*     */ 
/* 172 */     TransactionAttribute attr = (TransactionAttribute)this.container.resolveAnnotation(method, TransactionAttribute.class);
/* 173 */     if (attr == null)
/*     */     {
/* 175 */       attr = (TransactionAttribute)this.container.resolveAnnotation(TransactionAttribute.class);
/*     */     }
/* 177 */     TransactionAttributeType type = TransactionAttributeType.REQUIRED;
/* 178 */     if (attr != null) type = attr.value();
/* 179 */     return type == TransactionAttributeType.REQUIRED;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 187 */     resolveMessageListener();
/* 188 */     resolveResourceAdapterName();
/*     */ 
/* 190 */     resolveResourceAdapter();
/*     */ 
/* 192 */     createActivationSpec();
/*     */ 
/* 195 */     this.interfaces = new Class[] { MessageEndpoint.class, this.messagingTypeClass };
/*     */ 
/* 197 */     activate();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 203 */     deactivate();
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 214 */     this.container = ((MessagingContainer)container);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 224 */     StringBuffer buffer = new StringBuffer(100);
/* 225 */     buffer.append(super.toString());
/* 226 */     buffer.append("{ resourceAdapter=").append(this.resourceAdapterName);
/* 227 */     buffer.append(", messagingType=").append(this.container.getMessagingType());
/* 228 */     buffer.append(", ejbName=").append(this.container.getEjbName());
/* 229 */     buffer.append(", activationConfig=").append(this.properties.values());
/* 230 */     buffer.append(", activationSpec=").append(this.activationSpec);
/* 231 */     buffer.append("}");
/* 232 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected void resolveMessageListener()
/*     */     throws DeploymentException
/*     */   {
/* 244 */     this.messagingTypeClass = this.container.getMessagingType();
/*     */   }
/*     */ 
/*     */   protected void resolveResourceAdapterName()
/*     */     throws DeploymentException
/*     */   {
/* 255 */     this.resourceAdapterName = this.container.getResourceAdaptorName();
/*     */   }
/*     */ 
/*     */   protected void resolveResourceAdapter()
/*     */   {
/*     */     try
/*     */     {
/* 262 */       this.resourceAdapterObjectName = new ObjectName("jboss.jca:service=RARDeployment,name='" + this.resourceAdapterName + "'");
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 267 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createActivationSpec()
/*     */     throws DeploymentException
/*     */   {
/* 279 */     this.properties = new HashMap();
/*     */ 
/* 281 */     for (org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData property : this.container.getActivationConfigProperties().values())
/*     */     {
/* 283 */       this.properties.put(property.getName(), new org.jboss.metadata.ActivationConfigPropertyMetaData(property));
/*     */     }
/*     */ 
/* 286 */     Object[] params = { this.messagingTypeClass, this.properties.values() };
/*     */     try
/*     */     {
/* 294 */       this.activationSpec = ((ActivationSpec)KernelAbstractionFactory.getInstance().invoke(this.resourceAdapterObjectName, "createActivationSpec", params, this.createActivationSpecSig));
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 298 */       t = JMXExceptionDecoder.decode(t);
/* 299 */       DeploymentException.rethrowAsDeploymentException("Unable to create activation spec ra=" + this.resourceAdapterObjectName + " messaging-type=" + this.messagingTypeClass.getName() + " properties=" + this.container.getActivationConfigProperties(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void activate()
/*     */     throws DeploymentException
/*     */   {
/* 311 */     Object[] params = { this, this.activationSpec };
/*     */     try
/*     */     {
/* 314 */       KernelAbstractionFactory.getInstance().invoke(this.resourceAdapterObjectName, "endpointActivation", params, this.activationSig);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 318 */       t = JMXExceptionDecoder.decode(t);
/* 319 */       DeploymentException.rethrowAsDeploymentException("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deactivate()
/*     */   {
/* 329 */     Object[] params = { this, this.activationSpec };
/*     */     try
/*     */     {
/* 332 */       KernelAbstractionFactory.getInstance().invoke(this.resourceAdapterObjectName, "endpointDeactivation", params, this.activationSig);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 336 */       t = JMXExceptionDecoder.decode(t);
/* 337 */       log.warn("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.inflow.JBossMessageEndpointFactory
 * JD-Core Version:    0.6.0
 */