/*     */ package org.jboss.ejb3.mdb;
/*     */ 
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Hashtable;
/*     */ import javax.jms.ConnectionFactory;
/*     */ import javax.jms.Destination;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aspects.remoting.Remoting;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.annotation.MessageProperties;
/*     */ import org.jboss.ejb3.annotation.impl.ProducerImpl;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public class RemoteProducerFactory extends ProducerFactory
/*     */ {
/*     */   protected ConnectionFactory factory;
/*     */ 
/*     */   public RemoteProducerFactory(ConsumerContainer container, Class producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable initialContextProperties)
/*     */   {
/*  51 */     super(container, producer, props, dest, ctx, initialContextProperties);
/*     */     try
/*     */     {
/*  54 */       String factoryName = this.pImpl.connectionFactory();
/*  55 */       if (factoryName.equals("")) factoryName = "ConnectionFactory";
/*  56 */       this.factory = ((ConnectionFactory)ctx.lookup(factoryName));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  60 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/*  70 */     Class[] interfaces = { this.producer, ProducerObject.class };
/*     */ 
/*  72 */     ProducerManagerImpl mImpl = null;
/*     */ 
/*  74 */     mImpl = new ProducerManagerImpl(this.pImpl, this.dest, this.factory, this.props.delivery(), this.props.timeToLive(), this.props.priority(), this.methodMap, this.initialContextProperties);
/*     */ 
/*  76 */     Interceptor[] interceptors = { mImpl };
/*  77 */     ProducerProxy ih = new ProducerProxy(mImpl, interceptors);
/*  78 */     return Proxy.newProxyInstance(this.producer.getClassLoader(), interfaces, ih);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  83 */     super.start();
/*  84 */     Class[] interfaces = { ProxyFactory.class };
/*  85 */     Object factoryProxy = Remoting.createPojiProxy(this.jndiName + "PRODUCER_FACTORY", interfaces, "socket://0.0.0.0:3873");
/*     */     try
/*     */     {
/*  88 */       Util.rebind(this.ctx, this.jndiName + "PRODUCER_FACTORY", factoryProxy);
/*     */     }
/*     */     catch (NamingException e) {
/*  91 */       NamingException namingException = new NamingException("Could not bind remote producer factory into JNDI under jndiName: " + this.ctx.getNameInNamespace() + "/" + this.jndiName + "PRODUCER_FACTORY");
/*  92 */       namingException.setRootCause(e);
/*  93 */       throw namingException;
/*     */     }
/*  95 */     Dispatcher.singleton.registerTarget(this.jndiName + "PRODUCER_FACTORY", this);
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 100 */     super.stop();
/* 101 */     Util.unbind(this.ctx, this.jndiName + "PRODUCER_FACTORY");
/* 102 */     Dispatcher.singleton.unregisterTarget(this.jndiName + "PRODUCER_FACTORY");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.RemoteProducerFactory
 * JD-Core Version:    0.6.0
 */