/*     */ package org.jboss.ejb3.mdb;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.ConnectionFactory;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MessageProducer;
/*     */ import javax.jms.ObjectMessage;
/*     */ import javax.jms.Session;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.annotation.DeliveryMode;
/*     */ import org.jboss.ejb3.annotation.MessageProperties;
/*     */ import org.jboss.ejb3.annotation.Producer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ProducerManagerImpl
/*     */   implements ProducerManager, Externalizable, Interceptor
/*     */ {
/*     */   private static final long serialVersionUID = -3096930718616437880L;
/*  60 */   private static final Logger log = Logger.getLogger(ProducerManagerImpl.class);
/*     */   private static final int PERSISTENT = 2;
/*     */   private static final int NON_PERSISTENT = 1;
/*     */   protected Producer producer;
/*     */   protected Destination destination;
/*     */   protected String factoryLookup;
/*  69 */   protected int deliveryMode = 2;
/*  70 */   protected int timeToLive = 0;
/*  71 */   protected int priority = 4;
/*     */   protected HashMap methodMap;
/*     */   protected transient ConnectionFactory factory;
/*     */   protected transient Connection connection;
/*     */   protected transient Session session;
/*     */   protected transient MessageProducer msgProducer;
/*     */   protected transient String username;
/*     */   protected transient String password;
/*     */   protected transient InitialContext initialContext;
/*     */   protected Hashtable initialContextProperties;
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/*  85 */     out.writeObject(this.producer);
/*  86 */     out.writeObject(this.destination);
/*  87 */     out.writeObject(this.factoryLookup);
/*  88 */     out.writeInt(this.deliveryMode);
/*  89 */     out.writeInt(this.timeToLive);
/*  90 */     out.writeInt(this.priority);
/*  91 */     out.writeObject(this.methodMap);
/*  92 */     out.writeObject(this.initialContextProperties);
/*  93 */     if (this.factoryLookup == null)
/*     */     {
/*  95 */       out.writeObject(this.factory);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 101 */     this.producer = ((Producer)in.readObject());
/* 102 */     this.destination = ((Destination)in.readObject());
/* 103 */     this.factoryLookup = ((String)in.readObject());
/* 104 */     this.deliveryMode = in.readInt();
/* 105 */     this.timeToLive = in.readInt();
/* 106 */     this.priority = in.readInt();
/* 107 */     this.methodMap = ((HashMap)in.readObject());
/* 108 */     this.initialContextProperties = ((Hashtable)in.readObject());
/*     */     try
/*     */     {
/* 111 */       this.initialContext = InitialContextFactory.getInitialContext(this.initialContextProperties);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 115 */       throw new RuntimeException(e);
/*     */     }
/* 117 */     if (this.factoryLookup != null)
/*     */     {
/*     */       try
/*     */       {
/* 121 */         this.factory = ((ConnectionFactory)this.initialContext.lookup(this.factoryLookup));
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 125 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 130 */       this.factory = ((ConnectionFactory)in.readObject());
/*     */     }
/*     */   }
/*     */ 
/*     */   public ProducerManagerImpl(Producer producer, Destination destination, ConnectionFactory factory, DeliveryMode deliveryMode, int timeToLive, int priority, HashMap methodMap, Hashtable initialContextProperties)
/*     */   {
/* 136 */     this.initialContextProperties = initialContextProperties;
/*     */     try
/*     */     {
/* 139 */       this.initialContext = InitialContextFactory.getInitialContext(initialContextProperties);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 143 */       throw new RuntimeException(e);
/*     */     }
/* 145 */     this.producer = producer;
/* 146 */     this.destination = destination;
/* 147 */     this.factory = factory;
/*     */ 
/* 149 */     int mode = deliveryMode.ordinal();
/* 150 */     switch (mode)
/*     */     {
/*     */     case 2:
/* 153 */       this.deliveryMode = 2;
/* 154 */       break;
/*     */     case 1:
/* 156 */       this.deliveryMode = 1;
/*     */     }
/*     */ 
/* 159 */     this.timeToLive = timeToLive;
/* 160 */     this.priority = priority;
/* 161 */     this.methodMap = methodMap;
/*     */   }
/*     */ 
/*     */   public ProducerManagerImpl(Producer producer, Destination destination, String factory, DeliveryMode deliveryMode, int timeToLive, int priority, HashMap methodMap, Hashtable initialContextProperties)
/*     */   {
/* 166 */     this.initialContextProperties = initialContextProperties;
/*     */     try
/*     */     {
/* 169 */       this.initialContext = InitialContextFactory.getInitialContext(initialContextProperties);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 173 */       throw new RuntimeException(e);
/*     */     }
/* 175 */     this.producer = producer;
/* 176 */     this.destination = destination;
/* 177 */     this.factoryLookup = factory;
/*     */ 
/* 179 */     int mode = deliveryMode.ordinal();
/* 180 */     switch (mode)
/*     */     {
/*     */     case 2:
/* 183 */       this.deliveryMode = 2;
/* 184 */       break;
/*     */     case 1:
/* 186 */       this.deliveryMode = 1;
/*     */     }
/*     */ 
/* 189 */     this.timeToLive = timeToLive;
/* 190 */     this.priority = priority;
/* 191 */     this.methodMap = methodMap;
/*     */   }
/*     */ 
/*     */   public ProducerManagerImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setUsername(String user)
/*     */   {
/* 201 */     this.username = user;
/*     */   }
/*     */ 
/*     */   public void setPassword(String passwd)
/*     */   {
/* 206 */     this.password = passwd;
/*     */   }
/*     */ 
/*     */   public void connect() throws JMSException
/*     */   {
/* 211 */     if (this.factory == null)
/*     */     {
/*     */       try
/*     */       {
/* 215 */         this.factory = ((ConnectionFactory)this.initialContext.lookup(this.factoryLookup));
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 219 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 222 */     if (this.connection != null) return;
/* 223 */     if (this.username != null)
/*     */     {
/* 225 */       this.connection = this.factory.createConnection(this.username, this.password);
/*     */     }
/*     */     else
/*     */     {
/* 229 */       this.connection = this.factory.createConnection();
/*     */     }
/* 231 */     this.session = this.connection.createSession(this.producer.transacted(), this.producer.acknowledgeMode());
/* 232 */     this.msgProducer = this.session.createProducer(this.destination);
/* 233 */     this.msgProducer.setDeliveryMode(this.deliveryMode);
/* 234 */     this.msgProducer.setTimeToLive(this.timeToLive);
/* 235 */     this.msgProducer.setPriority(this.priority);
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/* 240 */     this.msgProducer.close();
/* 241 */     this.msgProducer = null;
/* 242 */     this.session.close();
/* 243 */     this.session = null;
/* 244 */     this.connection.close();
/* 245 */     this.connection = null;
/*     */   }
/*     */ 
/*     */   public void commit() throws JMSException
/*     */   {
/* 250 */     this.session.commit();
/*     */   }
/*     */ 
/*     */   public void rollback() throws JMSException
/*     */   {
/* 255 */     this.session.rollback();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 260 */     return Interceptor.class.getName();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 265 */     if (this.session == null)
/*     */     {
/* 267 */       throw new RuntimeException("You must call connect() on the producer.  The JMS session has not been set");
/*     */     }
/* 269 */     ObjectMessage msg = this.session.createObjectMessage((Serializable)invocation);
/* 270 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 271 */     MessageProperties props = (MessageProperties)this.methodMap.get(new Long(mi.getMethodHash()));
/* 272 */     if (props != null)
/*     */     {
/* 274 */       int del = props.delivery() == DeliveryMode.PERSISTENT ? 2 : 1;
/* 275 */       this.msgProducer.send(msg, del, props.priority(), props.timeToLive());
/*     */     }
/*     */     else
/*     */     {
/* 279 */       this.msgProducer.send(msg);
/*     */     }
/* 281 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.ProducerManagerImpl
 * JD-Core Version:    0.6.0
 */