/*     */ package org.jboss.ejb3.mdb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import javax.jms.Destination;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JndiProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.annotation.MessageProperties;
/*     */ import org.jboss.ejb3.annotation.Producer;
/*     */ import org.jboss.ejb3.annotation.Producers;
/*     */ import org.jboss.ejb3.annotation.impl.MessagePropertiesImpl;
/*     */ import org.jboss.ejb3.annotation.impl.ProducerImpl;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public abstract class ProducerFactory
/*     */   implements ProxyFactory
/*     */ {
/*  56 */   private static final Logger log = Logger.getLogger(ProducerFactory.class);
/*     */   protected Class producer;
/*     */   protected MessageProperties props;
/*     */   protected Destination dest;
/*     */   protected HashMap methodMap;
/*     */   protected ProducerImpl pImpl;
/*     */   protected String jndiName;
/*     */   protected InitialContext ctx;
/*     */   protected Hashtable initialContextProperties;
/*     */   public static final String PROXY_FACTORY_NAME = "PRODUCER_FACTORY";
/*     */ 
/*     */   protected ProducerFactory(ConsumerContainer container, Class producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable ctxProperties)
/*     */   {
/*  72 */     this.producer = producer;
/*  73 */     this.props = props;
/*  74 */     this.dest = dest;
/*  75 */     this.ctx = ctx;
/*  76 */     this.initialContextProperties = ctxProperties;
/*     */ 
/*  79 */     this.methodMap = new HashMap();
/*  80 */     Method[] methods = producer.getMethods();
/*  81 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  83 */       MessageProperties mProps = (MessageProperties)methods[i].getAnnotation(MessageProperties.class);
/*  84 */       if (mProps == null)
/*     */         continue;
/*     */       try
/*     */       {
/*  88 */         this.methodMap.put(new Long(MethodHashing.methodHash(methods[i])), new MessagePropertiesImpl(mProps));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  92 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  97 */     Producer p = (Producer)producer.getAnnotation(Producer.class);
/*  98 */     if (p == null)
/*  99 */       p = (Producer)container.resolveAnnotation(Producer.class);
/* 100 */     if (p == null)
/*     */     {
/* 102 */       Producers annotation = (Producers)container.resolveAnnotation(Producers.class);
/* 103 */       Producer[] producers = annotation.value();
/* 104 */       for (int i = 0; i < producers.length; i++)
/*     */       {
/* 106 */         if ((producers[i].producer() != null) && (producers[i].producer().equals(producer))) {
/* 107 */           p = producers[i];
/*     */         }
/*     */       }
/*     */     }
/* 111 */     this.pImpl = new ProducerImpl(p);
/* 112 */     this.jndiName = producer.getName();
/*     */   }
/*     */ 
/*     */   public Object createHomeProxy()
/*     */   {
/* 117 */     throw new UnsupportedOperationException("producer can't have a home interface");
/*     */   }
/*     */ 
/*     */   public Object createProxy(Object id)
/*     */   {
/* 122 */     if (id != null)
/* 123 */       throw new IllegalArgumentException("producer proxy must not have an id");
/* 124 */     return createProxy();
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 133 */     Context baseCtx = this.ctx;
/* 134 */     Name name = baseCtx.getNameParser("").parse(this.jndiName);
/* 135 */     baseCtx = Util.createSubcontext(baseCtx, name.getPrefix(name.size() - 1));
/* 136 */     String atom = name.get(name.size() - 1);
/* 137 */     RefAddr refAddr = new StringRefAddr("FACTORY", atom + "PRODUCER_FACTORY");
/* 138 */     Reference ref = new Reference("java.lang.Object", refAddr, JndiProxyFactory.class.getName(), null);
/*     */     try
/*     */     {
/* 142 */       Util.rebind(baseCtx, atom, ref);
/*     */     }
/*     */     catch (NamingException e) {
/* 145 */       NamingException namingException = new NamingException("Could not bind producer factory into JNDI under jndiName: " + baseCtx.getNameInNamespace() + "/" + atom);
/* 146 */       namingException.setRootCause(e);
/* 147 */       throw namingException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 153 */     Util.unbind(this.ctx, this.jndiName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.ProducerFactory
 * JD-Core Version:    0.6.0
 */