/*     */ package org.jboss.ejb3.mdb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import javax.ejb.ActivationConfigProperty;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.Topic;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.ResourceAdapter;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
/*     */ import org.jboss.ejb3.jms.JMSDestinationFactory;
/*     */ import org.jboss.ejb3.mdb.inflow.JBossMessageEndpointFactory;
/*     */ import org.jboss.ejb3.pool.Pool;
/*     */ import org.jboss.ejb3.timerservice.TimedObjectInvoker;
/*     */ import org.jboss.ejb3.timerservice.TimerServiceFactory;
/*     */ import org.jboss.jms.jndi.JMSProviderAdapter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
/*     */ import org.jboss.mx.util.ObjectNameConverter;
/*     */ 
/*     */ public abstract class MessagingContainer extends EJBContainer
/*     */   implements TimedObjectInvoker
/*     */ {
/*     */   private static final Logger log;
/*     */   protected TimerService timerService;
/*  68 */   protected ActivationSpec activationSpec = new ActivationSpec();
/*     */   protected JBossMessageEndpointFactory messageEndpointFactory;
/*  70 */   private MessagingDelegateWrapper mbean = new MessagingDelegateWrapper(this);
/*     */   protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
/*     */   protected static final String JMS_ADAPTOR = "jms-ra.rar";
/*     */   protected static final String DESTINATION = "destination";
/*     */   protected static final String DESTINATION_TYPE = "destinationType";
/*     */   protected static final String PROVIDER_ADAPTER_JNDI = "providerAdapterJNDI";
/*     */   protected static final String MAX_SESSION = "maxSession";
/*     */ 
/*     */   public MessagingContainer(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*     */   {
/*  82 */     super("jboss.j2ee:service=EJB3,name=" + ejbName, manager, cl, beanClassName, ejbName, ctxProperties, interceptorRepository, deployment);
/*     */ 
/*  84 */     this.messageEndpointFactory = new JBossMessageEndpointFactory();
/*  85 */     this.messageEndpointFactory.setContainer(this);
/*     */   }
/*     */ 
/*     */   public BeanContext<?> createBeanContext()
/*     */   {
/*  91 */     return new MDBContext(this, construct());
/*     */   }
/*     */ 
/*     */   public Object getMBean()
/*     */   {
/*  96 */     return this.mbean; } 
/*     */   public abstract Class getMessagingType();
/*     */ 
/*     */   public abstract Map<String, ActivationConfigPropertyMetaData> getActivationConfigProperties();
/*     */ 
/*     */   protected abstract void populateActivationSpec();
/*     */ 
/*     */   public abstract MethodInfo getMethodInfo(Method paramMethod);
/*     */ 
/* 109 */   public void setMessageEndpointFactory(JBossMessageEndpointFactory messageEndpointFactory) { this.messageEndpointFactory = messageEndpointFactory;
/*     */   }
/*     */ 
/*     */   public String getResourceAdaptorName()
/*     */   {
/* 114 */     ResourceAdapter annotation = (ResourceAdapter)resolveAnnotation(ResourceAdapter.class);
/* 115 */     if (annotation == null) {
/* 116 */       return "jms-ra.rar";
/*     */     }
/* 118 */     return annotation.value();
/*     */   }
/*     */ 
/*     */   protected void addActivationSpecProperty(Map<String, ActivationConfigPropertyMetaData> result, ActivationConfigProperty property)
/*     */   {
/* 123 */     if (!property.propertyName().equals("messagingType"))
/*     */     {
/* 125 */       ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData();
/* 126 */       metaData.setName(property.propertyName());
/* 127 */       metaData.setValue(property.propertyValue());
/* 128 */       result.put(property.propertyName(), metaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 143 */     super.start();
/*     */ 
/* 145 */     populateActivationSpec();
/*     */ 
/* 147 */     innerStart();
/*     */ 
/* 149 */     this.timerService = TimerServiceFactory.getInstance().createTimerService(this, this);
/*     */ 
/* 151 */     startProxies();
/*     */ 
/* 153 */     TimerServiceFactory.getInstance().restoreTimerService(this.timerService);
/*     */   }
/*     */ 
/*     */   protected void innerStart() throws Exception
/*     */   {
/* 158 */     log.debug("Initializing");
/*     */   }
/*     */ 
/*     */   public ObjectName getJmxName()
/*     */   {
/* 168 */     ObjectName jmxName = null;
/* 169 */     String jndiName = ProxyFactoryHelper.getLocalJndiName(this);
/*     */ 
/* 171 */     String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
/*     */     try
/*     */     {
/* 174 */       jmxName = ObjectNameConverter.convert(name);
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 178 */       e.printStackTrace();
/* 179 */       throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
/*     */     }
/*     */ 
/* 182 */     return jmxName;
/*     */   }
/*     */ 
/*     */   protected void startProxies() throws Exception
/*     */   {
/* 187 */     this.messageEndpointFactory.start();
/*     */   }
/*     */ 
/*     */   protected String parseJndiSuffix(String jndiname, String defautSuffix)
/*     */   {
/* 203 */     String jndiSuffix = "";
/*     */ 
/* 205 */     if (jndiname != null)
/*     */     {
/* 207 */       int indexOfSlash = jndiname.indexOf("/");
/* 208 */       if (indexOfSlash != -1)
/*     */       {
/* 210 */         jndiSuffix = jndiname.substring(indexOfSlash + 1);
/*     */       }
/*     */       else
/*     */       {
/* 214 */         jndiSuffix = jndiname;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 220 */       jndiSuffix = defautSuffix;
/*     */     }
/*     */ 
/* 223 */     return jndiSuffix;
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Method method, Object[] args) throws Throwable
/*     */   {
/* 228 */     MethodInfo info = getMethodInfo(method);
/* 229 */     if (info == null)
/*     */     {
/* 231 */       throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
/*     */     }
/* 233 */     return localInvoke(info, args);
/*     */   }
/*     */ 
/*     */   public Object localInvoke(MethodInfo info, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 239 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 240 */     pushEnc();
/*     */     try
/*     */     {
/* 243 */       EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info);
/* 244 */       nextInvocation.setAdvisor(this);
/* 245 */       nextInvocation.setArguments(args);
/* 246 */       Object localObject1 = nextInvocation.invokeNext();
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/* 250 */       Thread.currentThread().setContextClassLoader(oldLoader);
/* 251 */       popEnc(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService()
/*     */   {
/* 257 */     return this.timerService;
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService(Object pKey)
/*     */   {
/* 262 */     assert (this.timerService != null) : "Timer Service not yet initialized";
/* 263 */     return this.timerService;
/*     */   }
/*     */ 
/*     */   public void callTimeout(Timer timer) throws Exception
/*     */   {
/* 268 */     Method timeout = this.callbackHandler.getTimeoutCallback();
/* 269 */     if (timeout == null) throw new EJBException("No method has been annotated with @Timeout");
/* 270 */     Object[] args = { timer };
/*     */     try
/*     */     {
/* 273 */       localInvoke(timeout, args);
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 277 */       if ((throwable instanceof Exception)) throw ((Exception)throwable);
/* 278 */       throw new RuntimeException(throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 285 */     if (this.timerService != null)
/*     */     {
/* 287 */       TimerServiceFactory.getInstance().removeTimerService(this.timerService);
/* 288 */       this.timerService = null;
/*     */     }
/*     */ 
/* 291 */     stopProxies();
/*     */ 
/* 293 */     super.stop();
/*     */   }
/*     */ 
/*     */   protected void stopProxies() throws Exception
/*     */   {
/* 298 */     this.messageEndpointFactory.stop();
/*     */   }
/*     */ 
/*     */   protected void initializePool()
/*     */     throws Exception
/*     */   {
/* 310 */     super.initializePool();
/*     */   }
/*     */ 
/*     */   protected String getProviderAdapterJNDI()
/*     */   {
/* 315 */     ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)getActivationConfigProperties().get("providerAdapterJNDI");
/* 316 */     if (property != null)
/* 317 */       return property.getValue();
/* 318 */     return "java:/DefaultJMSProvider";
/*     */   }
/*     */ 
/*     */   protected String getMaxSession()
/*     */   {
/* 323 */     ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)getActivationConfigProperties().get("maxSession");
/* 324 */     if (property != null)
/* 325 */       return property.getValue();
/* 326 */     return null;
/*     */   }
/*     */ 
/*     */   protected String getDestination()
/*     */   {
/* 331 */     ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)getActivationConfigProperties().get("destination");
/* 332 */     if (property != null)
/* 333 */       return property.getValue();
/* 334 */     return null;
/*     */   }
/*     */ 
/*     */   protected String getDestinationType()
/*     */   {
/* 339 */     ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)getActivationConfigProperties().get("destinationType");
/* 340 */     if (property != null)
/* 341 */       return property.getValue();
/* 342 */     return null;
/*     */   }
/*     */ 
/*     */   protected void jmsCreate()
/*     */     throws Exception
/*     */   {
/* 349 */     JMSProviderAdapter adapter = getJMSProviderAdapter();
/* 350 */     log.debug("Provider adapter: " + adapter);
/*     */ 
/* 353 */     Context context = adapter.getInitialContext();
/* 354 */     log.debug("context: " + context);
/*     */ 
/* 357 */     if (context == null)
/*     */     {
/* 359 */       throw new RuntimeException("Failed to get the root context");
/*     */     }
/*     */ 
/* 365 */     String destinationType = getDestinationType();
/* 366 */     if (destinationType == null)
/*     */     {
/* 368 */       log.warn("No message-driven-destination given; using; guessing type");
/* 369 */       destinationType = getDestinationType(context, getDestination());
/*     */     }
/*     */ 
/* 372 */     if ("javax.jms.Topic".equals(destinationType))
/*     */     {
/* 374 */       innerCreateTopic(context);
/*     */     }
/* 377 */     else if ("javax.jms.Queue".equals(destinationType))
/*     */     {
/* 379 */       innerCreateQueue(context);
/*     */     }
/*     */     else
/*     */     {
/* 383 */       throw new DeploymentException("Unknown destination-type " + destinationType);
/*     */     }
/* 385 */     log.debug("Initialized with config " + toString());
/*     */ 
/* 387 */     context.close();
/*     */   }
/*     */ 
/*     */   protected void innerCreateQueue(Context context)
/*     */     throws Exception
/*     */   {
/* 393 */     log.debug("Got destination type Queue for " + this.ejbName);
/*     */ 
/* 396 */     String jndiSuffix = parseJndiSuffix(getDestination(), this.ejbName);
/* 397 */     log.debug("jndiSuffix: " + jndiSuffix);
/*     */ 
/* 400 */     Queue queue = null;
/*     */     try
/*     */     {
/* 404 */       if (getDestination() != null)
/* 405 */         queue = (Queue)context.lookup(getDestination());
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 409 */       log.warn("Could not find the queue destination-jndi-name=" + getDestination());
/*     */     }
/*     */     catch (ClassCastException e)
/*     */     {
/* 413 */       throw new DeploymentException("Expected a Queue destination-jndi-name=" + getDestination());
/*     */     }
/*     */ 
/* 416 */     if (queue == null)
/* 417 */       queue = (Queue)createDestination(Queue.class, context, "queue/" + jndiSuffix, jndiSuffix);
/*     */   }
/*     */ 
/*     */   protected void innerCreateTopic(Context context)
/*     */     throws Exception
/*     */   {
/* 426 */     log.debug("Got destination type Topic for " + this.ejbName);
/*     */ 
/* 429 */     String jndiSuffix = parseJndiSuffix(getDestination(), this.ejbName);
/* 430 */     log.debug("jndiSuffix: " + jndiSuffix);
/*     */ 
/* 433 */     Topic topic = null;
/*     */     try
/*     */     {
/* 437 */       if (getDestination() != null)
/* 438 */         topic = (Topic)context.lookup(getDestination());
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 442 */       log.warn("Could not find the topic destination-jndi-name=" + getDestination());
/*     */     }
/*     */     catch (ClassCastException e)
/*     */     {
/* 446 */       throw new DeploymentException("Expected a Topic destination-jndi-name=" + getDestination());
/*     */     }
/*     */ 
/* 449 */     if (topic == null)
/* 450 */       topic = (Topic)createDestination(Topic.class, context, "topic/" + jndiSuffix, jndiSuffix);
/*     */   }
/*     */ 
/*     */   private Destination createDestination(Class<? extends Destination> type, Context ctx, String jndiName, String jndiSuffix)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 476 */       return (Destination)ctx.lookup(jndiName);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 481 */       if (getDestination() == null)
/*     */       {
/* 483 */         return null;
/*     */       }
/*     */ 
/* 488 */       log.warn("destination not found: " + jndiName + " reason: " + e);
/* 489 */       log.warn("creating a new temporary destination: " + jndiName);
/*     */ 
/* 491 */       createTemporaryDestination(type, jndiSuffix);
/*     */     }
/*     */ 
/* 494 */     return (Destination)ctx.lookup(jndiName);
/*     */   }
/*     */ 
/*     */   private void createTemporaryDestination(Class<? extends Destination> type, String jndiSuffix)
/*     */     throws Exception
/*     */   {
/* 552 */     JMSDestinationFactory.getInstance().createDestination(type, jndiSuffix);
/*     */   }
/*     */ 
/*     */   protected JMSProviderAdapter getJMSProviderAdapter()
/*     */     throws NamingException
/*     */   {
/* 564 */     String providerAdapterJNDI = getProviderAdapterJNDI();
/*     */ 
/* 566 */     log.debug("Looking up provider adapter: " + providerAdapterJNDI);
/*     */ 
/* 568 */     return (JMSProviderAdapter)getInitialContext().lookup(providerAdapterJNDI);
/*     */   }
/*     */ 
/*     */   protected String getDestinationType(Context ctx, String destinationJNDI)
/*     */   {
/* 583 */     String destType = null;
/*     */ 
/* 585 */     if (destinationJNDI != null)
/*     */     {
/*     */       try
/*     */       {
/* 589 */         Destination dest = (Destination)ctx.lookup(destinationJNDI);
/* 590 */         if ((dest instanceof Topic))
/*     */         {
/* 592 */           destType = "javax.jms.Topic";
/*     */         }
/* 594 */         else if ((dest instanceof Queue))
/*     */         {
/* 596 */           destType = "javax.jms.Queue";
/*     */         }
/*     */       }
/*     */       catch (NamingException ex)
/*     */       {
/* 601 */         log.debug("Could not do heristic lookup of destination ", ex);
/*     */       }
/*     */     }
/*     */ 
/* 605 */     if (destType == null)
/*     */     {
/* 607 */       log.warn("Could not determine destination type, defaults to: javax.jms.Topic");
/*     */ 
/* 610 */       destType = "javax.jms.Topic";
/*     */     }
/*     */ 
/* 613 */     return destType;
/*     */   }
/*     */ 
/*     */   public boolean hasJNDIBinding(String jndiName)
/*     */   {
/* 623 */     return false;
/*     */   }
/*     */ 
/*     */   public int getMinPoolSize()
/*     */   {
/* 628 */     return 1;
/*     */   }
/*     */ 
/*     */   public int getMaxPoolSize()
/*     */   {
/* 633 */     return this.pool.getMaxSize();
/*     */   }
/*     */ 
/*     */   public int getMaxMessages()
/*     */   {
/* 638 */     String maxMessages = (String)this.activationSpec.get("maxMessages");
/* 639 */     if (maxMessages != null) {
/* 640 */       return Integer.parseInt(maxMessages);
/*     */     }
/* 642 */     return 1;
/*     */   }
/*     */ 
/*     */   public int getKeepAliveMillis()
/*     */   {
/* 647 */     String keepAlive = (String)this.activationSpec.get("keepAlive");
/* 648 */     if (keepAlive != null) {
/* 649 */       return Integer.parseInt(keepAlive);
/*     */     }
/* 651 */     return 60000;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  65 */     log = Logger.getLogger(MessagingContainer.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.MessagingContainer
 * JD-Core Version:    0.6.0
 */