/*     */ package org.jboss.ejb3.mdb;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.ActivationConfigProperty;
/*     */ import javax.ejb.MessageDriven;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.DefaultActivationSpecs;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.mx.util.ObjectNameConverter;
/*     */ 
/*     */ public class MDB extends MessagingContainer
/*     */ {
/*     */   protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
/*  60 */   protected Class<?> messagingType = null;
/*     */ 
/*     */   public MDB(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*     */   {
/*  65 */     super(ejbName, manager, cl, beanClassName, ctxProperties, interceptorRepository, deployment);
/*     */   }
/*     */ 
/*     */   public Class<?> getMessagingType()
/*     */   {
/*  70 */     if (this.messagingType == null)
/*     */     {
/*  72 */       MessageDriven annotation = (MessageDriven)resolveAnnotation(MessageDriven.class);
/*  73 */       this.messagingType = annotation.messageListenerInterface();
/*  74 */       if (this.messagingType.getName().equals(Object.class.getName()))
/*     */       {
/*  76 */         Set businessInterfaces = ProxyFactoryHelper.getBusinessInterfaces(this.clazz, false);
/*  77 */         if ((businessInterfaces.size() > 1) || (businessInterfaces.size() == 0))
/*  78 */           throw new RuntimeException("Unable to choose messagingType interface for MDB " + getEjbName() + " from " + businessInterfaces);
/*  79 */         this.messagingType = ((Class)businessInterfaces.iterator().next());
/*     */       }
/*     */     }
/*     */ 
/*  83 */     return this.messagingType;
/*     */   }
/*     */ 
/*     */   public MethodInfo getMethodInfo(Method method)
/*     */   {
/*  88 */     long hash = MethodHashing.calculateHash(method);
/*  89 */     MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
/*  90 */     return info;
/*     */   }
/*     */ 
/*     */   public Map getActivationConfigProperties()
/*     */   {
/*  95 */     HashMap result = new HashMap();
/*  96 */     MessageDriven mdAnnotation = (MessageDriven)resolveAnnotation(MessageDriven.class);
/*  97 */     for (ActivationConfigProperty property : mdAnnotation.activationConfig())
/*     */     {
/*  99 */       addActivationSpecProperty(result, property);
/*     */     }
/*     */ 
/* 102 */     DefaultActivationSpecs defaultSpecsAnnotation = (DefaultActivationSpecs)resolveAnnotation(DefaultActivationSpecs.class);
/* 103 */     if (defaultSpecsAnnotation != null)
/*     */     {
/* 105 */       for (ActivationConfigProperty property : defaultSpecsAnnotation.value())
/*     */       {
/* 107 */         addActivationSpecProperty(result, property);
/*     */       }
/*     */     }
/*     */ 
/* 111 */     return result;
/*     */   }
/*     */ 
/*     */   protected List<Class<?>> resolveBusinessInterfaces()
/*     */   {
/* 116 */     List list = new ArrayList();
/* 117 */     list.add(getMessagingType());
/* 118 */     return list;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 123 */     super.start();
/*     */   }
/*     */ 
/*     */   public ObjectName getJmxName()
/*     */   {
/* 128 */     ObjectName jmxName = null;
/* 129 */     String jndiName = ProxyFactoryHelper.getLocalJndiName(this);
/*     */ 
/* 131 */     String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
/*     */     try
/*     */     {
/* 134 */       jmxName = ObjectNameConverter.convert(name);
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 138 */       e.printStackTrace();
/* 139 */       throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
/*     */     }
/*     */ 
/* 142 */     return jmxName;
/*     */   }
/*     */ 
/*     */   protected void populateActivationSpec()
/*     */   {
/* 147 */     DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)resolveAnnotation(DefaultActivationSpecs.class);
/* 148 */     if (defaultSpecs != null)
/*     */     {
/* 150 */       this.activationSpec.merge(defaultSpecs.value());
/*     */     }
/*     */ 
/* 153 */     MessageDriven md = (MessageDriven)resolveAnnotation(MessageDriven.class);
/*     */ 
/* 155 */     this.activationSpec.merge(md.activationConfig());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.MDB
 * JD-Core Version:    0.6.0
 */