/*    */ package org.jboss.ejb3.mdb;
/*    */ 
/*    */ import java.lang.reflect.Proxy;
/*    */ import java.util.Hashtable;
/*    */ import javax.jms.Destination;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.ejb3.NonSerializableFactory;
/*    */ import org.jboss.ejb3.annotation.MessageProperties;
/*    */ import org.jboss.ejb3.annotation.impl.ProducerImpl;
/*    */ 
/*    */ public class LocalProducerFactory extends ProducerFactory
/*    */ {
/*    */   protected String factoryName;
/*    */ 
/*    */   public LocalProducerFactory(ConsumerContainer container, Class producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable icProperties)
/*    */   {
/* 45 */     super(container, producer, props, dest, ctx, icProperties);
/*    */     try
/*    */     {
/* 49 */       this.factoryName = this.pImpl.connectionFactory();
/* 50 */       if (this.factoryName.equals("")) this.factoryName = "java:/ConnectionFactory";
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 54 */       throw new RuntimeException(e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object createProxy()
/*    */   {
/* 60 */     Class[] interfaces = { this.producer, ProducerObject.class };
/*    */ 
/* 62 */     ProducerManagerImpl mImpl = null;
/*    */ 
/* 64 */     mImpl = new ProducerManagerImpl(this.pImpl, this.dest, this.factoryName, this.props.delivery(), this.props.timeToLive(), this.props.priority(), this.methodMap, this.initialContextProperties);
/*    */ 
/* 66 */     Interceptor[] interceptors = { mImpl };
/* 67 */     ProducerProxy ih = new ProducerProxy(mImpl, interceptors);
/* 68 */     return Proxy.newProxyInstance(this.producer.getClassLoader(), interfaces, ih);
/*    */   }
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/* 73 */     super.start();
/*    */     try {
/* 75 */       NonSerializableFactory.rebind(this.ctx, this.jndiName + "PRODUCER_FACTORY", this);
/*    */     }
/*    */     catch (NamingException e) {
/* 78 */       NamingException namingException = new NamingException("Could not bind local producer factory with name " + this.factoryName + " into JNDI under jndiName: " + this.ctx.getNameInNamespace() + "/" + this.jndiName + "PRODUCER_FACTORY");
/* 79 */       namingException.setRootCause(e);
/* 80 */       throw namingException;
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stop() throws Exception
/*    */   {
/* 86 */     super.stop();
/* 87 */     NonSerializableFactory.unbind(this.ctx, this.jndiName + "PRODUCER_FACTORY");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.LocalProducerFactory
 * JD-Core Version:    0.6.0
 */