/*     */ package org.jboss.ejb3.mdb;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.ejb.ActivationConfigProperty;
/*     */ import javax.ejb.Local;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.ObjectMessage;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationResponse;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.annotation.Consumer;
/*     */ import org.jboss.ejb3.annotation.DefaultActivationSpecs;
/*     */ import org.jboss.ejb3.annotation.MessageProperties;
/*     */ import org.jboss.ejb3.annotation.Producer;
/*     */ import org.jboss.ejb3.annotation.Producers;
/*     */ import org.jboss.ejb3.annotation.impl.MessagePropertiesImpl;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
/*     */ 
/*     */ public class ConsumerContainer extends MessagingContainer
/*     */ {
/*  63 */   private static final Logger log = Logger.getLogger(ConsumerContainer.class);
/*     */ 
/*  65 */   protected Class messagingType = null;
/*     */   protected Method ON_MESSAGE;
/*  68 */   protected ArrayList<ProducerFactory> producers = new ArrayList();
/*     */   protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
/*     */   public static final String CONSUMER_MESSAGE = "CONSUMER_MESSAGE";
/*     */ 
/*     */   public ConsumerContainer(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*     */   {
/*  89 */     super(ejbName, manager, cl, beanClassName, ctxProperties, interceptorRepository, deployment);
/*     */   }
/*     */ 
/*     */   public InvocationResponse dynamicInvoke(Invocation invocation) throws Throwable
/*     */   {
/*  94 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/*  95 */     EJBContainerInvocation newSi = null;
/*  96 */     pushEnc();
/*     */     try
/*     */     {
/*  99 */       Thread.currentThread().setContextClassLoader(this.classloader);
/* 100 */       MethodInvocation si = (MethodInvocation)invocation;
/* 101 */       MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
/* 102 */       if (info == null)
/*     */       {
/* 104 */         throw new RuntimeException("Could not resolve beanClass method from proxy call");
/*     */       }
/*     */ 
/* 107 */       newSi = new EJBContainerInvocation(info);
/* 108 */       newSi.setArguments(si.getArguments());
/* 109 */       newSi.setMetaData(si.getMetaData());
/* 110 */       newSi.setAdvisor(this);
/*     */ 
/* 112 */       InvocationResponse response = new InvocationResponse(newSi.invokeNext());
/* 113 */       response.setContextInfo(newSi.getResponseContextInfo());
/* 114 */       InvocationResponse localInvocationResponse1 = response;
/*     */       return localInvocationResponse1;
/*     */     }
/*     */     finally
/*     */     {
/* 118 */       Thread.currentThread().setContextClassLoader(oldLoader);
/* 119 */       popEnc(); } throw localObject;
/*     */   }
/*     */ 
/*     */   protected Method getOnMessage()
/*     */   {
/* 125 */     if (this.ON_MESSAGE != null) {
/* 126 */       return this.ON_MESSAGE;
/*     */     }
/*     */     try
/*     */     {
/* 130 */       Class arg = Message.class;
/* 131 */       this.ON_MESSAGE = MessageListener.class.getMethod("onMessage", new Class[] { arg });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 135 */       e.printStackTrace();
/* 136 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */ 
/* 139 */     return this.ON_MESSAGE;
/*     */   }
/*     */ 
/*     */   public Object localInvoke(MethodInfo info, Object[] args) throws Throwable
/*     */   {
/* 144 */     if (info.getMethod().equals(getOnMessage()))
/*     */     {
/* 146 */       ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 147 */       pushEnc();
/*     */       try
/*     */       {
/* 151 */         Message message = (Message)args[0];
/* 152 */         MethodInvocation invocation = (MethodInvocation)((ObjectMessage)message).getObject();
/* 153 */         invocation.getMetaData().addMetaData("CONSUMER_MESSAGE", "CONSUMER_MESSAGE", message, PayloadKey.TRANSIENT);
/* 154 */         InvocationResponse localInvocationResponse = dynamicInvoke(invocation);
/*     */         return localInvocationResponse;
/*     */       }
/*     */       finally
/*     */       {
/* 158 */         Thread.currentThread().setContextClassLoader(oldLoader);
/* 159 */         popEnc();
/*     */       }
/*     */     }
/*     */ 
/* 163 */     return super.localInvoke(info, args);
/*     */   }
/*     */ 
/*     */   public Class getMessagingType()
/*     */   {
/* 168 */     return MessageListener.class;
/*     */   }
/*     */ 
/*     */   public MethodInfo getMethodInfo(Method method)
/*     */   {
/* 173 */     MethodInfo info = new MethodInfo();
/* 174 */     info.setAdvisor(this);
/* 175 */     info.setAdvisedMethod(method);
/* 176 */     info.setUnadvisedMethod(method);
/*     */ 
/* 178 */     return info;
/*     */   }
/*     */ 
/*     */   public Map<String, ActivationConfigPropertyMetaData> getActivationConfigProperties()
/*     */   {
/* 183 */     Map result = new HashMap();
/* 184 */     Consumer annotation = (Consumer)resolveAnnotation(Consumer.class);
/* 185 */     for (ActivationConfigProperty property : annotation.activationConfig())
/*     */     {
/* 187 */       addActivationSpecProperty(result, property);
/*     */     }
/*     */ 
/* 190 */     DefaultActivationSpecs defaultSpecsAnnotation = (DefaultActivationSpecs)resolveAnnotation(DefaultActivationSpecs.class);
/* 191 */     if (defaultSpecsAnnotation != null)
/*     */     {
/* 193 */       for (ActivationConfigProperty property : defaultSpecsAnnotation.value())
/*     */       {
/* 195 */         addActivationSpecProperty(result, property);
/*     */       }
/*     */     }
/*     */ 
/* 199 */     return result;
/*     */   }
/*     */ 
/*     */   protected List<Class<?>> resolveBusinessInterfaces()
/*     */   {
/* 204 */     Class[] classInterfaces = getBeanClass().getInterfaces();
/* 205 */     if (classInterfaces.length == 0) throw new RuntimeException("Bean class must implement at least one interface: " + getBeanClass().getName());
/* 206 */     if (classInterfaces.length == 1)
/*     */     {
/* 208 */       List list = new ArrayList();
/* 209 */       list.add(classInterfaces[0]);
/* 210 */       return list;
/*     */     }
/* 212 */     List interfaces = new ArrayList();
/* 213 */     Producers producers = (Producers)resolveAnnotation(Producers.class);
/* 214 */     if (producers != null)
/*     */     {
/* 216 */       for (Producer producer : producers.value())
/*     */       {
/* 218 */         interfaces.add(producer.producer());
/*     */       }
/*     */     }
/*     */ 
/* 222 */     Producer producer = (Producer)resolveAnnotation(Producer.class);
/* 223 */     if (producer != null)
/*     */     {
/* 225 */       interfaces.add(producer.producer());
/*     */     }
/*     */ 
/* 228 */     for (Class implIf : getBeanClass().getInterfaces())
/*     */     {
/* 230 */       if (implIf.getAnnotation(Producer.class) == null)
/*     */         continue;
/* 232 */       interfaces.add(implIf);
/*     */     }
/*     */ 
/* 235 */     return interfaces;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 249 */     super.start();
/*     */ 
/* 251 */     registerProducers();
/*     */   }
/*     */ 
/*     */   protected void registerProducers() throws Exception
/*     */   {
/* 256 */     Destination dest = (Destination)getInitialContext().lookup(getDestination());
/* 257 */     MessageProperties props = (MessageProperties)resolveAnnotation(MessageProperties.class);
/* 258 */     if (props == null) props = new MessagePropertiesImpl();
/* 259 */     for (Class producer : getBusinessInterfaces())
/*     */     {
/* 261 */       log.debug("Producer: " + producer.getName());
/* 262 */       ProducerFactory producerFactory = null;
/* 263 */       if (producer.isAnnotationPresent(Local.class))
/*     */       {
/* 265 */         producerFactory = new LocalProducerFactory(this, producer, props, dest, getInitialContext(), this.initialContextProperties);
/*     */       }
/*     */       else
/*     */       {
/* 269 */         producerFactory = new RemoteProducerFactory(this, producer, props, dest, getInitialContext(), this.initialContextProperties);
/*     */       }
/* 271 */       this.producers.add(producerFactory);
/* 272 */       producerFactory.start();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void unregisterProducers() throws Exception
/*     */   {
/* 278 */     for (ProducerFactory factory : this.producers)
/*     */     {
/* 280 */       factory.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void populateActivationSpec()
/*     */   {
/* 286 */     DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)resolveAnnotation(DefaultActivationSpecs.class);
/* 287 */     if (defaultSpecs != null)
/*     */     {
/* 289 */       this.activationSpec.merge(defaultSpecs.value());
/*     */     }
/*     */ 
/* 292 */     Consumer md = (Consumer)resolveAnnotation(Consumer.class);
/* 293 */     this.activationSpec.merge(md.activationConfig());
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 298 */     unregisterProducers();
/* 299 */     super.stop();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.ConsumerContainer
 * JD-Core Version:    0.6.0
 */