/*    */ package org.jboss.ejb3.jms;
/*    */ 
/*    */ import javax.jms.Destination;
/*    */ import javax.jms.Queue;
/*    */ import javax.jms.Topic;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.ejb3.KernelAbstraction;
/*    */ import org.jboss.ejb3.KernelAbstractionFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ServerPeerJMSDestinationFactory extends JMSDestinationFactory
/*    */ {
/* 43 */   private static final Logger log = Logger.getLogger(ServerPeerJMSDestinationFactory.class);
/*    */ 
/*    */   public void createDestination(Class<? extends Destination> type, String jndiSuffix)
/*    */     throws Exception
/*    */   {
/*    */     String methodName;
/* 55 */     if (type == Topic.class)
/*    */     {
/* 57 */       String destinationContext = "topic";
/* 58 */       methodName = "createTopic";
/*    */     }
/*    */     else
/*    */     {
/*    */       String methodName;
/* 60 */       if (type == Queue.class)
/*    */       {
/* 62 */         String destinationContext = "queue";
/* 63 */         methodName = "createQueue";
/*    */       }
/*    */       else
/*    */       {
/* 68 */         throw new IllegalArgumentException("Expected javax.jms.Queue or javax.jms.Topic: " + type);
/*    */       }
/*    */     }
/*    */     String destinationContext;
/*    */     String methodName;
/* 72 */     String name = jndiSuffix;
/* 73 */     String jndiName = destinationContext + "/" + jndiSuffix;
/*    */ 
/* 75 */     ObjectName serverPeerName = new ObjectName("jboss.messaging:service=ServerPeer");
/*    */ 
/* 77 */     KernelAbstraction kernel = KernelAbstractionFactory.getInstance();
/*    */ 
/* 79 */     Object result = kernel.invoke(serverPeerName, methodName, new Object[] { name, jndiName }, new String[] { "java.lang.String", "java.lang.String" });
/*    */ 
/* 84 */     log.debug("result = " + result);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.jms.ServerPeerJMSDestinationFactory
 * JD-Core Version:    0.6.0
 */