/*     */ package org.jboss.ejb3.interceptor;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.annotation.PostConstruct;
/*     */ import javax.annotation.PreDestroy;
/*     */ import javax.ejb.PostActivate;
/*     */ import javax.ejb.PrePassivate;
/*     */ import javax.interceptor.InvocationContext;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class LifecycleInvocationContextImpl
/*     */   implements InvocationContext
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(LifecycleInvocationContextImpl.class);
/*     */   private int currentInterceptor;
/*     */   private int currentMethod;
/*     */   BeanContext beanContext;
/*     */   InterceptorInfo[] interceptorInfos;
/*     */   Object[] instances;
/*     */   private Method[] beanMethods;
/*     */   private HashMap metadata;
/*     */   private Object[] parameters;
/*     */ 
/*     */   public static InvocationContext getLifecycleInvocationContext(Class type, BeanContext beanContext, InterceptorInfo[] interceptorInfos, Method[] beanMethods)
/*     */   {
/*  61 */     LifecycleInvocationContextImpl ic = null;
/*  62 */     if (type == PostConstruct.class) ic = new PostConstructICtxImpl();
/*  63 */     else if (type == PostActivate.class) ic = new PostActivateICtxImpl();
/*  64 */     else if (type == PrePassivate.class) ic = new PrePassivateICtxImpl();
/*  65 */     else if (type == PreDestroy.class) ic = new PreDestroyICtxImpl(); else {
/*  66 */       throw new RuntimeException("Unsupported lifecycle event: " + type);
/*     */     }
/*  68 */     ic.instances = beanContext.getInterceptorInstances(interceptorInfos);
/*  69 */     if (interceptorInfos.length != ic.instances.length)
/*     */     {
/*  71 */       throw new RuntimeException("interceptorInfos and instances have different length");
/*     */     }
/*     */ 
/*  74 */     ic.beanContext = beanContext;
/*  75 */     ic.beanMethods = beanMethods;
/*  76 */     ic.interceptorInfos = interceptorInfos;
/*     */ 
/*  78 */     return ic;
/*     */   }
/*     */ 
/*     */   public Object getTarget()
/*     */   {
/*  83 */     return this.beanContext.getInstance();
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  88 */     return null;
/*     */   }
/*     */ 
/*     */   public Object[] getParameters()
/*     */   {
/*  93 */     if (this.parameters == null) {
/*  94 */       this.parameters = new Object[0];
/*     */     }
/*  96 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public void setParameters(Object[] params)
/*     */   {
/* 101 */     this.parameters = params;
/*     */   }
/*     */ 
/*     */   public Map getContextData()
/*     */   {
/* 107 */     if (this.metadata == null) {
/* 108 */       this.metadata = new HashMap();
/*     */     }
/* 110 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public Object proceed() throws Exception
/*     */   {
/* 115 */     if (this.currentInterceptor < this.interceptorInfos.length)
/*     */     {
/* 117 */       int oldInterceptor = this.currentInterceptor;
/* 118 */       int oldMethod = this.currentMethod;
/*     */       try
/*     */       {
/* 121 */         int curr = this.currentInterceptor;
/* 122 */         int currMethod = this.currentMethod++;
/* 123 */         InterceptorInfo info = this.interceptorInfos[curr];
/* 124 */         if (currMethod == getLifecycleMethods(info).length)
/*     */         {
/* 126 */           curr = ++this.currentInterceptor;
/* 127 */           this.currentMethod = 0;
/* 128 */           currMethod = this.currentMethod++;
/* 129 */           info = curr < this.interceptorInfos.length ? this.interceptorInfos[curr] : null;
/*     */         }
/*     */ 
/* 132 */         if (info != null)
/*     */         {
/*     */           try
/*     */           {
/* 136 */             Method[] methods = getLifecycleMethods(info);
/* 137 */             Object localObject1 = methods[currMethod].invoke(this.instances[curr], new Object[] { this });
/*     */ 
/* 155 */             this.currentInterceptor = oldInterceptor;
/* 156 */             this.currentMethod = oldMethod; return localObject1;
/*     */           }
/*     */           catch (InvocationTargetException e)
/*     */           {
/* 141 */             if ((e.getTargetException() instanceof Exception))
/*     */             {
/* 143 */               throw ((Exception)e.getCause());
/*     */             }
/*     */ 
/* 147 */             throw new RuntimeException(e.getCause());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/* 155 */         this.currentInterceptor = oldInterceptor;
/* 156 */         this.currentMethod = oldMethod;
/*     */       }
/*     */     }
/* 159 */     if (this.beanMethods != null)
/*     */     {
/*     */       try
/*     */       {
/* 163 */         for (Method beanMethod : this.beanMethods)
/*     */         {
/* 165 */           if (beanMethod.getParameterAnnotations().length == getParameters().length)
/* 166 */             beanMethod.invoke(getTarget(), getParameters());
/*     */           else
/* 168 */             log.error("Skip attempt of invalid lifecycle method invocation: " + beanMethod);
/*     */         }
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 173 */         if ((e.getTargetException() instanceof Exception))
/*     */           throw ((Exception)e.getCause());
/*     */         throw new RuntimeException(e.getCause());
/*     */       }
/*     */       finally
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 187 */     return null;
/*     */   }
/*     */ 
/*     */   abstract Method[] getLifecycleMethods(InterceptorInfo paramInterceptorInfo);
/*     */ 
/*     */   public static class PreDestroyICtxImpl extends LifecycleInvocationContextImpl
/*     */   {
/*     */     Method[] getLifecycleMethods(InterceptorInfo info)
/*     */     {
/* 220 */       return info.getPreDestroys();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class PrePassivateICtxImpl extends LifecycleInvocationContextImpl
/*     */   {
/*     */     Method[] getLifecycleMethods(InterceptorInfo info)
/*     */     {
/* 212 */       return info.getPrePassivates();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class PostActivateICtxImpl extends LifecycleInvocationContextImpl
/*     */   {
/*     */     Method[] getLifecycleMethods(InterceptorInfo info)
/*     */     {
/* 204 */       return info.getPostActivates();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class PostConstructICtxImpl extends LifecycleInvocationContextImpl
/*     */   {
/*     */     Method[] getLifecycleMethods(InterceptorInfo info)
/*     */     {
/* 196 */       return info.getPostConstructs();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.interceptor.LifecycleInvocationContextImpl
 * JD-Core Version:    0.6.0
 */