/*     */ package org.jboss.ejb3.interceptor;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import javax.annotation.PostConstruct;
/*     */ import javax.annotation.PreDestroy;
/*     */ import javax.ejb.PostActivate;
/*     */ import javax.ejb.PrePassivate;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timeout;
/*     */ import javax.ejb.Timer;
/*     */ import javax.interceptor.InvocationContext;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.MethodHashing;
/*     */ 
/*     */ public class LifecycleInterceptorHandler
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(LifecycleInterceptorHandler.class);
/*     */   private EJBContainer container;
/*     */   private InterceptorInfo[] postConstructs;
/*     */   private InterceptorInfo[] postActivates;
/*     */   private InterceptorInfo[] prePassivates;
/*     */   private InterceptorInfo[] preDestroys;
/*     */   private Method[] beanPostConstructs;
/*     */   private Method[] beanPostActivates;
/*     */   private Method[] beanPrePassivates;
/*     */   private Method[] beanPreDestroys;
/*     */   private Method timeoutCallbackMethod;
/*     */   private long timeoutCalllbackHash;
/*     */ 
/*     */   public LifecycleInterceptorHandler(EJBContainer container, Class[] handledCallbacks)
/*     */   {
/*  64 */     this.container = container;
/*  65 */     InterceptorInfoRepository repostitory = container.getInterceptorRepository();
/*  66 */     for (Class clazz : handledCallbacks)
/*     */     {
/*  68 */       if (clazz == PostConstruct.class)
/*     */       {
/*  70 */         this.postConstructs = repostitory.getPostConstructInterceptors(container);
/*  71 */         this.beanPostConstructs = repostitory.getBeanClassPostConstructs(container);
/*     */       }
/*  73 */       else if (clazz == PostActivate.class)
/*     */       {
/*  75 */         this.postActivates = repostitory.getPostActivateInterceptors(container);
/*  76 */         this.beanPostActivates = repostitory.getBeanClassPostActivates(container);
/*     */       }
/*  78 */       else if (clazz == PrePassivate.class)
/*     */       {
/*  80 */         this.prePassivates = repostitory.getPrePassivateInterceptors(container);
/*  81 */         this.beanPrePassivates = repostitory.getBeanClassPrePassivates(container);
/*     */       }
/*  83 */       else if (clazz == PreDestroy.class)
/*     */       {
/*  85 */         this.preDestroys = repostitory.getPreDestroyInterceptors(container);
/*  86 */         this.beanPreDestroys = repostitory.getBeanClassPreDestroys(container);
/*     */       } else {
/*  88 */         if (clazz != Timeout.class)
/*     */           continue;
/*  90 */         resolveTimeoutCallback();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public long getTimeoutCalllbackHash()
/*     */   {
/*  97 */     return this.timeoutCalllbackHash;
/*     */   }
/*     */ 
/*     */   public void postConstruct(BeanContext ctx, Object[] params)
/*     */   {
/*     */     try
/*     */     {
/* 104 */       InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PostConstruct.class, ctx, this.postConstructs, this.beanPostConstructs);
/* 105 */       ic.setParameters(params);
/* 106 */       ic.proceed();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 110 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void preDestroy(BeanContext ctx)
/*     */   {
/* 116 */     Object id = null;
/* 117 */     if ((ctx instanceof StatefulBeanContext))
/*     */     {
/* 119 */       id = ((StatefulBeanContext)ctx).getId();
/*     */     }
/*     */     try
/*     */     {
/* 123 */       InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PreDestroy.class, ctx, this.preDestroys, this.beanPreDestroys);
/*     */ 
/* 128 */       ic.proceed();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 132 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void postActivate(BeanContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 140 */       InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PostActivate.class, ctx, this.postActivates, this.beanPostActivates);
/*     */ 
/* 145 */       ic.proceed();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 149 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void prePassivate(BeanContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 157 */       InvocationContext ic = LifecycleInvocationContextImpl.getLifecycleInvocationContext(PrePassivate.class, ctx, this.prePassivates, this.beanPrePassivates);
/*     */ 
/* 162 */       ic.proceed();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 166 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Method getTimeoutCallback()
/*     */   {
/* 172 */     return this.timeoutCallbackMethod;
/*     */   }
/*     */ 
/*     */   private void resolveTimeoutCallback()
/*     */   {
/* 178 */     for (Method method : this.container.getBeanClass().getMethods())
/*     */     {
/* 180 */       if (this.container.resolveAnnotation(method, Timeout.class) == null)
/*     */         continue;
/* 182 */       if ((Modifier.isPublic(method.getModifiers())) && (method.getReturnType().equals(Void.TYPE)) && (method.getParameterTypes().length == 1) && (method.getParameterTypes()[0].equals(Timer.class)))
/*     */       {
/* 187 */         this.timeoutCallbackMethod = method;
/*     */       }
/*     */       else
/*     */       {
/* 191 */         throw new RuntimeException("@Timeout methods must have the signature: public void <METHOD>(javax.ejb.Timer timer) - " + method);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 198 */       if ((this.timeoutCallbackMethod == null) && (TimedObject.class.isAssignableFrom(this.container.getBeanClass())))
/*     */       {
/* 200 */         Class[] params = { Timer.class };
/* 201 */         this.timeoutCallbackMethod = this.container.getBeanClass().getMethod("ejbTimeout", params);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 206 */       log.error("Exception encoutered in " + LifecycleInterceptorHandler.class.getName() + ".resolveTimeoutCallback()", e);
/*     */     }
/*     */ 
/* 210 */     if (this.timeoutCallbackMethod != null)
/*     */     {
/* 212 */       this.timeoutCalllbackHash = MethodHashing.calculateHash(this.timeoutCallbackMethod);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.interceptor.LifecycleInterceptorHandler
 * JD-Core Version:    0.6.0
 */