/*     */ package org.jboss.ejb3.interceptor;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.metadata.ejb.spec.InterceptorMetaData;
/*     */ 
/*     */ public class InterceptorInfo
/*     */ {
/*     */   Class<?> clazz;
/*     */   InterceptorMetaData xml;
/*     */   protected Method aroundInvoke;
/*     */   protected Method postConstruct;
/*     */   protected Method postActivate;
/*     */   protected Method preDestroy;
/*     */   protected Method prePassivate;
/*     */   protected Method[] aroundInvokeHierarchy;
/*     */   protected Method[] postConstructHierarchy;
/*     */   protected Method[] postActivateHierarchy;
/*     */   protected Method[] preDestroyHierarchy;
/*     */   protected Method[] prePassivateHierarchy;
/*     */   boolean haveCalculatedHierarchy;
/*     */ 
/*     */   protected InterceptorInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   public InterceptorInfo(Class<?> clazz)
/*     */   {
/*  66 */     this.clazz = clazz;
/*     */   }
/*     */ 
/*     */   public InterceptorInfo(InterceptorInfo interceptorInfo)
/*     */   {
/*  71 */     this.clazz = interceptorInfo.clazz;
/*  72 */     this.aroundInvoke = interceptorInfo.aroundInvoke;
/*  73 */     this.postConstruct = interceptorInfo.postConstruct;
/*  74 */     this.postActivate = interceptorInfo.postActivate;
/*  75 */     this.preDestroy = interceptorInfo.preDestroy;
/*  76 */     this.prePassivate = interceptorInfo.prePassivate;
/*  77 */     this.aroundInvokeHierarchy = interceptorInfo.aroundInvokeHierarchy;
/*  78 */     this.postConstructHierarchy = interceptorInfo.postConstructHierarchy;
/*  79 */     this.postActivateHierarchy = interceptorInfo.postActivateHierarchy;
/*  80 */     this.preDestroyHierarchy = interceptorInfo.preDestroyHierarchy;
/*  81 */     this.prePassivateHierarchy = interceptorInfo.prePassivateHierarchy;
/*     */   }
/*     */ 
/*     */   protected void setXml(InterceptorMetaData xml)
/*     */   {
/*  86 */     this.xml = xml;
/*     */   }
/*     */ 
/*     */   public InterceptorMetaData getXml()
/*     */   {
/*  91 */     return this.xml;
/*     */   }
/*     */ 
/*     */   public Method getAroundInvoke()
/*     */   {
/*  96 */     return this.aroundInvoke;
/*     */   }
/*     */ 
/*     */   protected void setAroundInvoke(Method aroundInvoke)
/*     */   {
/* 101 */     if (aroundInvoke == null) return;
/*     */ 
/* 103 */     if ((this.aroundInvoke != null) && (!this.aroundInvoke.equals(aroundInvoke)))
/*     */     {
/* 105 */       throw new RuntimeException("Interceptors can only have one around-invoke/@AroundInvoke method - " + this.clazz.getName());
/*     */     }
/* 107 */     this.aroundInvoke = makeAccessible(aroundInvoke);
/*     */   }
/*     */ 
/*     */   public Class getClazz()
/*     */   {
/* 112 */     return this.clazz;
/*     */   }
/*     */ 
/*     */   public boolean haveCalculatedHierarchy()
/*     */   {
/* 117 */     return this.haveCalculatedHierarchy;
/*     */   }
/*     */ 
/*     */   public Method getPostActivate()
/*     */   {
/* 122 */     return this.postActivate;
/*     */   }
/*     */ 
/*     */   protected void setPostActivate(Method postActivate)
/*     */   {
/* 127 */     if (postActivate == null) return;
/*     */ 
/* 129 */     if ((this.postActivate != null) && (!this.postActivate.equals(postActivate)))
/*     */     {
/* 131 */       throw new RuntimeException("Interceptors can only have one post-activate/@PostActivate method - " + this.clazz.getName());
/*     */     }
/* 133 */     this.postActivate = makeAccessible(postActivate);
/*     */   }
/*     */ 
/*     */   public Method getPostConstruct()
/*     */   {
/* 138 */     return this.postConstruct;
/*     */   }
/*     */ 
/*     */   protected void setPostConstruct(Method postConstruct)
/*     */   {
/* 143 */     if (postConstruct == null) return;
/*     */ 
/* 145 */     if ((this.postConstruct != null) && (!this.postConstruct.equals(postConstruct)))
/*     */     {
/* 147 */       throw new RuntimeException("Interceptors can only have one post-construct/@PostConstruct method - " + this.clazz.getName());
/*     */     }
/* 149 */     this.postConstruct = makeAccessible(postConstruct);
/*     */   }
/*     */ 
/*     */   public Method getPreDestroy()
/*     */   {
/* 154 */     return this.preDestroy;
/*     */   }
/*     */ 
/*     */   protected void setPreDestroy(Method preDestroy)
/*     */   {
/* 159 */     if (preDestroy == null) return;
/*     */ 
/* 161 */     if ((this.preDestroy != null) && (!this.preDestroy.equals(preDestroy)))
/*     */     {
/* 163 */       throw new RuntimeException("Interceptors can only have one pre-destroy/@PreDestroy method - " + this.clazz.getName());
/*     */     }
/* 165 */     this.preDestroy = makeAccessible(preDestroy);
/*     */   }
/*     */ 
/*     */   public Method getPrePassivate()
/*     */   {
/* 170 */     return this.prePassivate;
/*     */   }
/*     */ 
/*     */   protected void setPrePassivate(Method prePassivate)
/*     */   {
/* 175 */     if (prePassivate == null) return;
/*     */ 
/* 177 */     if ((this.prePassivate != null) && (!this.prePassivate.equals(prePassivate)))
/*     */     {
/* 179 */       throw new RuntimeException("Interceptors can only have one pre-passivate/@PrePassivate method - " + this.clazz.getName());
/*     */     }
/* 181 */     this.prePassivate = makeAccessible(prePassivate);
/*     */   }
/*     */ 
/*     */   public Method[] getAroundInvokes()
/*     */   {
/* 186 */     return this.aroundInvokeHierarchy;
/*     */   }
/*     */ 
/*     */   public Method[] getPostActivates()
/*     */   {
/* 191 */     return this.postActivateHierarchy;
/*     */   }
/*     */ 
/*     */   public Method[] getPostConstructs()
/*     */   {
/* 196 */     return this.postConstructHierarchy;
/*     */   }
/*     */ 
/*     */   public Method[] getPreDestroys()
/*     */   {
/* 201 */     return this.preDestroyHierarchy;
/*     */   }
/*     */ 
/*     */   public Method[] getPrePassivates()
/*     */   {
/* 206 */     return this.prePassivateHierarchy;
/*     */   }
/*     */ 
/*     */   private Method makeAccessible(Method method)
/*     */   {
/*     */     try
/*     */     {
/* 213 */       AccessController.doPrivileged(new PrivilegedExceptionAction(method)
/*     */       {
/*     */         public Object run() {
/* 216 */           this.val$method.setAccessible(true);
/* 217 */           return null;
/*     */         }
/*     */       });
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/* 223 */       throw new RuntimeException(e.getException());
/*     */     }
/*     */ 
/* 226 */     return method;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 231 */     StringBuffer sb = new StringBuffer("InterceptorInfo{class=" + this.clazz);
/* 232 */     appendMethods(sb);
/* 233 */     sb.append("}");
/* 234 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   protected void appendMethods(StringBuffer sb)
/*     */   {
/* 239 */     appendMethodString(sb, "aroundInvoke", this.aroundInvoke);
/* 240 */     appendMethodString(sb, "postConstruct", this.postConstruct);
/* 241 */     appendMethodString(sb, "postActivate", this.postActivate);
/* 242 */     appendMethodString(sb, "prePassivate", this.prePassivate);
/* 243 */     appendMethodString(sb, "preDestroy", this.preDestroy);
/*     */   }
/*     */ 
/*     */   protected void appendMethodString(StringBuffer buf, String methodType, Method m)
/*     */   {
/* 248 */     if (m != null)
/*     */     {
/* 250 */       buf.append(", " + methodType + "=" + m.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void calculateHierarchy(InterceptorInfo superInfo)
/*     */   {
/* 256 */     if (this.haveCalculatedHierarchy)
/*     */     {
/* 258 */       return;
/*     */     }
/*     */ 
/* 261 */     this.postConstructHierarchy = initaliseMethods(superInfo != null ? superInfo.postConstructHierarchy : null, this.postConstruct);
/* 262 */     this.postActivateHierarchy = initaliseMethods(superInfo != null ? superInfo.postActivateHierarchy : null, this.postActivate);
/* 263 */     this.aroundInvokeHierarchy = initaliseMethods(superInfo != null ? superInfo.aroundInvokeHierarchy : null, this.aroundInvoke);
/* 264 */     this.prePassivateHierarchy = initaliseMethods(superInfo != null ? superInfo.prePassivateHierarchy : null, this.prePassivate);
/* 265 */     this.preDestroyHierarchy = initaliseMethods(superInfo != null ? superInfo.preDestroyHierarchy : null, this.preDestroy);
/*     */ 
/* 267 */     this.haveCalculatedHierarchy = true;
/*     */   }
/*     */ 
/*     */   private Method[] initaliseMethods(Method[] superMethods, Method myMethod)
/*     */   {
/* 272 */     if ((superMethods == null) && (myMethod == null))
/*     */     {
/* 274 */       return null;
/*     */     }
/* 276 */     ArrayList hierarchy = new ArrayList();
/* 277 */     if (superMethods != null)
/*     */     {
/* 280 */       for (int i = 0; i < superMethods.length; i++)
/*     */       {
/* 282 */         if (haveMethod(superMethods[i]))
/*     */           continue;
/* 284 */         hierarchy.add(superMethods[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 289 */     if (myMethod != null)
/*     */     {
/* 291 */       hierarchy.add(myMethod);
/*     */     }
/*     */ 
/* 294 */     return (Method[])(Method[])hierarchy.toArray(new Method[hierarchy.size()]);
/*     */   }
/*     */ 
/*     */   private boolean haveMethod(Method method)
/*     */   {
/*     */     try
/*     */     {
/* 301 */       this.clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
/* 302 */       return true;
/*     */     }
/*     */     catch (NoSuchMethodException e) {
/*     */     }
/* 306 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 313 */     if ((obj instanceof InterceptorInfo))
/*     */     {
/* 315 */       return this.clazz.equals(((InterceptorInfo)obj).getClazz());
/*     */     }
/* 317 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 323 */     return this.clazz.getName().hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.interceptor.InterceptorInfo
 * JD-Core Version:    0.6.0
 */