/*    */ package org.jboss.ejb3.interceptor;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.ejb3.BeanContext;
/*    */ import org.jboss.ejb3.EJBContainerInvocation;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class EJB3InterceptorsInterceptor
/*    */   implements Interceptor
/*    */ {
/* 38 */   protected static Logger log = Logger.getLogger(EJB3InterceptorsInterceptor.class);
/*    */   private InterceptorInfo[] interceptorInfos;
/*    */   private Method[] beanAroundInvokes;
/*    */ 
/*    */   public EJB3InterceptorsInterceptor(InterceptorInfo[] interceptorInfos, Method[] beanAroundInvokes)
/*    */   {
/* 44 */     this.interceptorInfos = interceptorInfos;
/* 45 */     this.beanAroundInvokes = beanAroundInvokes;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 50 */     return getClass().getName();
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 55 */     EJBContainerInvocation inv = (EJBContainerInvocation)invocation;
/*    */ 
/* 60 */     Object[] interceptors = inv.getBeanContext().getInterceptorInstances(this.interceptorInfos);
/* 61 */     if ((interceptors != null) && (interceptors.length == 0) && (this.beanAroundInvokes != null) && (this.beanAroundInvokes.length == 0)) return invocation.invokeNext();
/* 62 */     InvocationContextImpl ctx = new InvocationContextImpl(inv, this.interceptorInfos, interceptors, this.beanAroundInvokes);
/* 63 */     return ctx.proceed();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.interceptor.EJB3InterceptorsInterceptor
 * JD-Core Version:    0.6.0
 */