/*     */ package org.jboss.ejb3.entity.hibernate;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.persistence.EntityManager;
/*     */ import org.hibernate.Session;
/*     */ import org.hibernate.ejb.HibernateEntityManager;
/*     */ import org.jboss.ejb3.PersistenceUnitRegistry;
/*     */ import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
/*     */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*     */ 
/*     */ public class TransactionScopedSessionInvocationHandler
/*     */   implements InvocationHandler, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -5788395417446868080L;
/*     */   private transient ManagedEntityManagerFactory factory;
/*     */ 
/*     */   public TransactionScopedSessionInvocationHandler(ManagedEntityManagerFactory factory)
/*     */   {
/*  53 */     if (factory == null) throw new NullPointerException("factory must not be null");
/*  54 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public TransactionScopedSessionInvocationHandler()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected Session getHibernateSession()
/*     */   {
/*  64 */     if ((getSession() instanceof HibernateEntityManager))
/*     */     {
/*  66 */       return ((HibernateEntityManager)getSession()).getSession();
/*     */     }
/*  68 */     throw new RuntimeException("ILLEGAL ACTION: Not a Hibernate persistence provider");
/*     */   }
/*     */ 
/*     */   protected EntityManager getSession()
/*     */   {
/*  73 */     return this.factory.getTransactionScopedEntityManager();
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/*  79 */     out.writeUTF(this.factory.getKernelName());
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/*  84 */     String kernelName = in.readUTF();
/*  85 */     PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
/*  86 */     if (deployment == null) throw new IOException("Unable to find persistence unit in registry: " + kernelName);
/*  87 */     this.factory = deployment.getManagedFactory();
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*     */   {
/*  92 */     if ("close".equals(method.getName())) {
/*  93 */       throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  98 */       return method.invoke(getHibernateSession(), args);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/* 101 */       if ((e.getTargetException() instanceof RuntimeException)) {
/* 102 */         throw ((RuntimeException)e.getTargetException());
/*     */       }
/*     */     }
/* 105 */     throw e;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.hibernate.TransactionScopedSessionInvocationHandler
 * JD-Core Version:    0.6.0
 */