/*    */ package org.jboss.ejb3.entity.hibernate;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.persistence.EntityManager;
/*    */ import org.hibernate.Session;
/*    */ import org.hibernate.ejb.HibernateEntityManager;
/*    */ import org.jboss.ejb3.ThreadLocalStack;
/*    */ import org.jboss.ejb3.session.SessionContainer;
/*    */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*    */ 
/*    */ public class ExtendedSessionInvocationHandler
/*    */   implements InvocationHandler, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -2091491765429086936L;
/*    */   private String identity;
/*    */ 
/*    */   public ExtendedSessionInvocationHandler(String identity)
/*    */   {
/* 48 */     this.identity = identity;
/*    */   }
/*    */ 
/*    */   public ExtendedSessionInvocationHandler()
/*    */   {
/*    */   }
/*    */ 
/*    */   public EntityManager getPersistenceContext()
/*    */   {
/* 58 */     StatefulBeanContext beanContext = (StatefulBeanContext)StatefulBeanContext.currentBean.get();
/* 59 */     EntityManager persistenceContext = beanContext.getExtendedPersistenceContext(this.identity);
/* 60 */     if (persistenceContext == null) {
/* 61 */       throw new RuntimeException("Unable to determine persistenceContext: " + this.identity + " in injected SFSB: " + beanContext.getContainer().getObjectName());
/*    */     }
/* 63 */     return persistenceContext;
/*    */   }
/*    */ 
/*    */   public Session getHibernateSession()
/*    */   {
/* 68 */     EntityManager persistenceContext = getPersistenceContext();
/* 69 */     if ((persistenceContext instanceof HibernateEntityManager))
/*    */     {
/* 71 */       return ((HibernateEntityManager)persistenceContext).getSession();
/*    */     }
/* 73 */     throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
/*    */   }
/*    */ 
/*    */   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*    */   {
/* 78 */     String methodName = method.getName();
/* 79 */     if ("getPersistenceContext".equals(methodName)) {
/* 80 */       return getPersistenceContext();
/*    */     }
/* 82 */     if ("close".equals(methodName)) {
/* 83 */       throw new IllegalStateException("It is illegal to close an injected Hibernate Session");
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 88 */       return method.invoke(getHibernateSession(), args);
/*    */     }
/*    */     catch (InvocationTargetException e) {
/* 91 */       if ((e.getTargetException() instanceof RuntimeException)) {
/* 92 */         throw ((RuntimeException)e.getTargetException());
/*    */       }
/*    */     }
/* 95 */     throw e;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.hibernate.ExtendedSessionInvocationHandler
 * JD-Core Version:    0.6.0
 */