/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import org.hibernate.cache.StandardQueryCache;
/*     */ import org.hibernate.cache.UpdateTimestampsCache;
/*     */ 
/*     */ public class SecondLevelCacheUtil
/*     */ {
/*     */   public static final String HIBERNATE_CACHE_REGION_PREFIX = "hibernate.cache.region_prefix";
/*     */ 
/*     */   public static String createCacheRegionPrefix(String earName, String jarName, String unitName)
/*     */   {
/*  40 */     StringBuilder sb = new StringBuilder();
/*  41 */     if (earName != null)
/*     */     {
/*  43 */       sb.append(earName);
/*  44 */       if (!earName.endsWith(".ear"))
/*  45 */         sb.append("_ear");
/*  46 */       sb.append(",");
/*     */     }
/*  48 */     if (jarName != null)
/*     */     {
/*  50 */       sb.append(jarName);
/*  51 */       if (!jarName.endsWith(".jar"))
/*  52 */         sb.append("_jar");
/*  53 */       sb.append(",");
/*     */     }
/*  55 */     sb.append(unitName);
/*  56 */     String raw = sb.toString();
/*     */ 
/*  59 */     String escaped = raw.replace('.', '_');
/*  60 */     return escaped;
/*     */   }
/*     */ 
/*     */   public static String createRegionFqn(String regionName, String regionPrefix)
/*     */   {
/*  65 */     String escaped = null;
/*  66 */     int idx = -1;
/*  67 */     if (regionPrefix != null)
/*     */     {
/*  69 */       idx = regionName.indexOf(regionPrefix);
/*     */     }
/*     */ 
/*  72 */     if (idx > -1)
/*     */     {
/*  74 */       int regionEnd = idx + regionPrefix.length();
/*  75 */       String prefix = regionName.substring(0, regionEnd);
/*  76 */       String suffix = regionName.substring(regionEnd);
/*  77 */       suffix = suffix.replace('.', '/');
/*  78 */       escaped = prefix + suffix;
/*     */     }
/*     */     else
/*     */     {
/*  82 */       escaped = regionName.replace('.', '/');
/*     */     }
/*  84 */     return escaped;
/*     */   }
/*     */ 
/*     */   public static boolean isSharedClassLoaderRegion(String regionName)
/*     */   {
/*  89 */     return (StandardQueryCache.class.getName().equals(regionName)) || (UpdateTimestampsCache.class.getName().equals(regionName));
/*     */   }
/*     */ 
/*     */   public static org.hibernate.cache.CacheException convertToHibernateException(Exception e)
/*     */   {
/* 101 */     org.hibernate.cache.CacheException he = null;
/*     */ 
/* 103 */     if ((e instanceof org.jboss.cache.CacheException))
/*     */     {
/* 105 */       he = new org.hibernate.cache.CacheException(e.getClass().getName() + " " + e.getMessage());
/* 106 */       he.setStackTrace(e.getStackTrace());
/*     */     }
/* 108 */     else if ((e instanceof org.hibernate.cache.CacheException))
/*     */     {
/* 110 */       he = (org.hibernate.cache.CacheException)e;
/*     */     }
/*     */     else
/*     */     {
/* 114 */       he = new org.hibernate.cache.CacheException(e);
/*     */     }
/*     */ 
/* 117 */     return he;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.SecondLevelCacheUtil
 * JD-Core Version:    0.6.0
 */