/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.persistence.EntityManager;
/*     */ import javax.persistence.EntityManagerFactory;
/*     */ import javax.persistence.spi.PersistenceProvider;
/*     */ import javax.persistence.spi.PersistenceUnitTransactionType;
/*     */ import javax.sql.DataSource;
/*     */ import org.hibernate.ejb.HibernatePersistence;
/*     */ import org.hibernate.ejb.packaging.PersistenceMetadata;
/*     */ import org.jboss.ejb3.DependencyPolicy;
/*     */ import org.jboss.ejb3.DeploymentScope;
/*     */ import org.jboss.ejb3.DeploymentUnit;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.NonSerializableFactory;
/*     */ import org.jboss.ejb3.javaee.AbstractJavaEEComponent;
/*     */ import org.jboss.ejb3.javaee.SimpleJavaEEModule;
/*     */ import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class PersistenceUnitDeployment extends AbstractJavaEEComponent
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(PersistenceUnitDeployment.class);
/*     */   protected InitialContext initialContext;
/*     */   protected DeploymentUnit di;
/*  58 */   protected List<String> explicitEntityClasses = new ArrayList();
/*     */   protected ManagedEntityManagerFactory managedFactory;
/*     */   protected EntityManagerFactory actualFactory;
/*     */   protected PersistenceUnitMetaData metaData;
/*     */   protected String kernelName;
/*     */   protected Ejb3Deployment deployment;
/*     */   protected boolean scoped;
/*     */ 
/*     */   public PersistenceUnitDeployment(InitialContext initialContext, Ejb3Deployment deployment, List<String> explicitEntityClasses, PersistenceUnitMetaData metadata, String ear, String jar, boolean isScoped)
/*     */   {
/*  68 */     super(new SimpleJavaEEModule(deployment.getEar() != null ? deployment.getEar().getShortName() : null, deployment.getDeploymentUnit().getShortName()));
/*     */ 
/*  70 */     this.scoped = isScoped;
/*  71 */     this.deployment = deployment;
/*  72 */     this.initialContext = initialContext;
/*  73 */     this.di = deployment.getDeploymentUnit();
/*  74 */     this.explicitEntityClasses = explicitEntityClasses;
/*  75 */     this.metaData = metadata;
/*  76 */     this.kernelName = "persistence.units:";
/*  77 */     String name = getEntityManagerName();
/*  78 */     if ((name == null) || (name.length() == 0)) {
/*  79 */       throw new RuntimeException("Null string is not allowed for a persistence unit name.  Fix your persistence.xml file");
/*     */     }
/*  81 */     if (ear != null)
/*     */     {
/*  83 */       this.kernelName = (this.kernelName + "ear=" + ear);
/*  84 */       if (!ear.endsWith(".ear")) this.kernelName += ".ear";
/*  85 */       this.kernelName += ",";
/*     */     }
/*  87 */     if (isScoped)
/*     */     {
/*  89 */       this.kernelName = (this.kernelName + "jar=" + jar);
/*  90 */       if (!jar.endsWith(".jar")) this.kernelName += ".jar";
/*  91 */       this.kernelName += ",";
/*     */     }
/*  93 */     this.kernelName = (this.kernelName + "unitName=" + name);
/*     */   }
/*     */ 
/*     */   public static String getDefaultKernelName(String unitName)
/*     */   {
/*  98 */     int hashIndex = unitName.indexOf('#');
/*  99 */     if (hashIndex != -1)
/*     */     {
/* 101 */       String relativePath = unitName.substring(3, hashIndex);
/* 102 */       String name = unitName.substring(hashIndex + 1);
/* 103 */       return "persistence.units:jar=" + relativePath + "," + "unitName=" + name;
/*     */     }
/* 105 */     return "persistence.units:unitName=" + unitName;
/*     */   }
/*     */ 
/*     */   public boolean isScoped()
/*     */   {
/* 110 */     return this.scoped;
/*     */   }
/*     */ 
/*     */   public Ejb3Deployment getDeployment()
/*     */   {
/* 115 */     return this.deployment;
/*     */   }
/*     */ 
/*     */   protected String getJaccContextId()
/*     */   {
/* 120 */     return this.di.getShortName();
/*     */   }
/*     */ 
/*     */   public EntityManagerFactory getActualFactory()
/*     */   {
/* 125 */     return this.actualFactory;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitMetaData getXml()
/*     */   {
/* 130 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public String getKernelName()
/*     */   {
/* 135 */     return this.kernelName;
/*     */   }
/*     */ 
/*     */   public String getEntityManagerName()
/*     */   {
/* 140 */     return this.metaData.getName();
/*     */   }
/*     */ 
/*     */   public ManagedEntityManagerFactory getManagedFactory()
/*     */   {
/* 145 */     if (this.managedFactory == null)
/* 146 */       log.warn("managed factory is null, persistence unit " + this.kernelName + " has not yet been started");
/* 147 */     return this.managedFactory;
/*     */   }
/*     */ 
/*     */   public void addDependencies(DependencyPolicy policy)
/*     */   {
/* 152 */     PersistenceMetadata legacy = this.metaData.getLegacyMetadata();
/* 153 */     Properties props = legacy.getProps();
/* 154 */     if (!props.containsKey("jboss.no.implicit.datasource.dependency"))
/*     */     {
/* 156 */       if (legacy.getJtaDatasource() != null)
/*     */       {
/* 158 */         String ds = legacy.getJtaDatasource();
/* 159 */         policy.addDatasource(ds);
/*     */       }
/* 161 */       if (legacy.getNonJtaDatasource() != null)
/*     */       {
/* 163 */         String ds = legacy.getNonJtaDatasource();
/* 164 */         policy.addDatasource(ds);
/*     */       }
/*     */     }
/* 167 */     for (Iterator i$ = props.keySet().iterator(); i$.hasNext(); ) { Object prop = i$.next();
/*     */ 
/* 169 */       String property = (String)prop;
/* 170 */       if (property.startsWith("jboss.depends"))
/*     */       {
/* 172 */         policy.addDependency(props.getProperty(property));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 182 */     log.info("Starting persistence unit " + this.kernelName);
/*     */ 
/* 184 */     Properties props = new Properties();
/* 185 */     props.putAll(this.di.getDefaultPersistenceProperties());
/* 186 */     props.put("hibernate.jacc.ctx.id", getJaccContextId());
/*     */ 
/* 188 */     PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl();
/* 189 */     log.debug("Using class loader " + this.di.getClassLoader());
/* 190 */     pi.setClassLoader(this.di.getClassLoader());
/*     */ 
/* 192 */     ArrayList jarFiles = new ArrayList();
/* 193 */     pi.setJarFiles(jarFiles);
/* 194 */     pi.setPersistenceProviderClassName(HibernatePersistence.class.getName());
/* 195 */     log.debug("Found persistence.xml file in EJB3 jar");
/* 196 */     PersistenceMetadata xml = this.metaData.getLegacyMetadata();
/* 197 */     props.putAll(xml.getProps());
/* 198 */     pi.setManagedClassnames(xml.getClasses());
/* 199 */     pi.setPersistenceUnitName(this.metaData.getName());
/* 200 */     pi.setMappingFileNames(xml.getMappingFiles());
/* 201 */     pi.setExcludeUnlistedClasses(xml.getExcludeUnlistedClasses());
/* 202 */     log.debug("Persistence root url " + this.metaData.getPersistenceUnitRootUrl());
/* 203 */     pi.setPersistenceUnitRootUrl(this.metaData.getPersistenceUnitRootUrl());
/*     */ 
/* 207 */     PersistenceUnitTransactionType transactionType = xml.getTransactionType();
/* 208 */     pi.setTransactionType(transactionType);
/*     */ 
/* 210 */     for (String jar : xml.getJarFiles())
/*     */     {
/* 212 */       jarFiles.add(this.deployment.getDeploymentUnit().getRelativeURL(jar));
/*     */     }
/*     */ 
/* 216 */     if (xml.getProvider() != null) pi.setPersistenceProviderClassName(xml.getProvider());
/* 217 */     if (this.explicitEntityClasses.size() > 0)
/*     */     {
/* 219 */       List classes = pi.getManagedClassNames();
/* 220 */       if (classes == null) classes = this.explicitEntityClasses; else
/* 221 */         classes.addAll(this.explicitEntityClasses);
/* 222 */       pi.setManagedClassnames(classes);
/*     */     }
/* 224 */     if (xml.getJtaDatasource() != null)
/*     */     {
/* 226 */       pi.setJtaDataSource((DataSource)this.initialContext.lookup(xml.getJtaDatasource()));
/*     */     }
/* 228 */     else if (transactionType == PersistenceUnitTransactionType.JTA)
/*     */     {
/* 230 */       throw new RuntimeException("Specification violation [EJB3 JPA 6.2.1.2] - You have not defined a jta-data-source for a JTA enabled persistence context named: " + this.metaData.getName());
/*     */     }
/*     */ 
/* 233 */     if (xml.getNonJtaDatasource() != null)
/*     */     {
/* 235 */       pi.setNonJtaDataSource((DataSource)this.initialContext.lookup(xml.getNonJtaDatasource()));
/*     */     }
/* 237 */     else if (transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL)
/*     */     {
/* 239 */       throw new RuntimeException("Specification violation [EJB3 JPA 6.2.1.2] - You have not defined a non-jta-data-source for a RESOURCE_LOCAL enabled persistence context named: " + this.metaData.getName());
/*     */     }
/*     */ 
/* 243 */     pi.setProperties(props);
/*     */ 
/* 245 */     if (pi.getPersistenceUnitName() == null)
/*     */     {
/* 247 */       throw new RuntimeException("you must specify a name in persistence.xml");
/*     */     }
/*     */ 
/* 250 */     Class providerClass = Thread.currentThread().getContextClassLoader().loadClass(pi.getPersistenceProviderClassName());
/*     */ 
/* 253 */     if (!pi.getProperties().containsKey("hibernate.session_factory_name"))
/*     */     {
/* 255 */       pi.getProperties().put("hibernate.session_factory_name", this.kernelName);
/*     */     }
/*     */ 
/* 258 */     PersistenceProvider pp = (PersistenceProvider)providerClass.newInstance();
/* 259 */     this.actualFactory = pp.createContainerEntityManagerFactory(pi, null);
/*     */ 
/* 261 */     this.managedFactory = new ManagedEntityManagerFactory(this.actualFactory, this.kernelName);
/*     */ 
/* 263 */     String entityManagerJndiName = (String)props.get("jboss.entity.manager.jndi.name");
/* 264 */     if (entityManagerJndiName != null)
/*     */     {
/* 266 */       EntityManager injectedManager = new TransactionScopedEntityManager(this.managedFactory);
/* 267 */       NonSerializableFactory.rebind(this.initialContext, entityManagerJndiName, injectedManager);
/*     */     }
/* 269 */     String entityManagerFactoryJndiName = (String)props.get("jboss.entity.manager.factory.jndi.name");
/* 270 */     if (entityManagerFactoryJndiName != null)
/*     */     {
/* 272 */       EntityManagerFactory injectedFactory = new InjectedEntityManagerFactory(this.managedFactory);
/* 273 */       NonSerializableFactory.rebind(this.initialContext, entityManagerFactoryJndiName, injectedFactory);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 279 */     log.info("Stopping persistence unit " + this.kernelName);
/*     */ 
/* 281 */     PersistenceMetadata xml = this.metaData.getLegacyMetadata();
/* 282 */     String entityManagerJndiName = (String)xml.getProps().get("jboss.entity.manager.jndi.name");
/* 283 */     if (entityManagerJndiName != null)
/*     */     {
/* 285 */       NonSerializableFactory.unbind(this.initialContext, entityManagerJndiName);
/*     */     }
/* 287 */     String entityManagerFactoryJndiName = (String)xml.getProps().get("jboss.entity.manager.factory.jndi.name");
/* 288 */     if (entityManagerFactoryJndiName != null)
/*     */     {
/* 290 */       NonSerializableFactory.unbind(this.initialContext, entityManagerFactoryJndiName);
/*     */     }
/* 292 */     this.managedFactory.destroy();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.PersistenceUnitDeployment
 * JD-Core Version:    0.6.0
 */