/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.hibernate.cache.CacheException;
/*     */ import org.hibernate.cache.StandardQueryCache;
/*     */ import org.jboss.cache.Fqn;
/*     */ import org.jboss.cache.InvocationContext;
/*     */ import org.jboss.cache.Node;
/*     */ import org.jboss.cache.Region;
/*     */ import org.jboss.cache.config.Configuration;
/*     */ import org.jboss.cache.config.Option;
/*     */ import org.jboss.cache.lock.TimeoutException;
/*     */ 
/*     */ public class JBCCache
/*     */   implements org.hibernate.cache.Cache
/*     */ {
/*  54 */   private static final Log log = LogFactory.getLog(JBCCache.class);
/*     */   private static final String ITEM = "item";
/*     */   private org.jboss.cache.Cache cache;
/*     */   private final String regionName;
/*     */   private final Fqn regionFqn;
/*     */   private final TransactionManager transactionManager;
/*     */   private boolean localWritesOnly;
/*     */ 
/*     */   public JBCCache(org.jboss.cache.Cache cache, String regionName, String regionPrefix, TransactionManager transactionManager)
/*     */     throws CacheException
/*     */   {
/*  67 */     this.cache = cache;
/*  68 */     this.regionName = regionName;
/*  69 */     this.regionFqn = Fqn.fromString(SecondLevelCacheUtil.createRegionFqn(regionName, regionPrefix));
/*  70 */     this.transactionManager = transactionManager;
/*  71 */     if (cache.getConfiguration().isUseRegionBasedMarshalling())
/*     */     {
/*  73 */       this.localWritesOnly = StandardQueryCache.class.getName().equals(regionName);
/*     */ 
/*  75 */       boolean fetchState = cache.getConfiguration().isFetchInMemoryState();
/*     */       try
/*     */       {
/*  80 */         if (this.localWritesOnly) {
/*  81 */           cache.getConfiguration().setFetchInMemoryState(false);
/*     */         }
/*     */ 
/*  84 */         activateCacheRegion(this.regionFqn.toString());
/*     */       }
/*     */       finally
/*     */       {
/*  89 */         if (this.localWritesOnly)
/*  90 */           cache.getConfiguration().setFetchInMemoryState(fetchState);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  95 */       log.debug("TreeCache is not configured for region based marshalling");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object get(Object key) throws CacheException {
/* 100 */     Transaction tx = suspend();
/*     */     try {
/* 102 */       Object localObject1 = read(key);
/*     */       return localObject1; } finally { resume(tx); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public Object read(Object key) throws CacheException
/*     */   {
/*     */     try {
/* 111 */       return this.cache.get(new Fqn(this.regionFqn, new Object[] { key }), "item");
/*     */     } catch (Exception e) {
/*     */     }
/* 114 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   public void update(Object key, Object value) throws CacheException
/*     */   {
/*     */     try {
/* 120 */       if (this.localWritesOnly) {
/* 121 */         Option option = new Option();
/* 122 */         option.setCacheModeLocal(true);
/* 123 */         this.cache.getInvocationContext().setOptionOverrides(option);
/* 124 */         this.cache.put(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */       }
/*     */       else {
/* 127 */         this.cache.put(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/* 131 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(Object key, Object value) throws CacheException {
/* 136 */     Transaction tx = suspend();
/*     */     try {
/* 138 */       if (this.localWritesOnly) {
/* 139 */         Option option = new Option();
/* 140 */         option.setCacheModeLocal(true);
/* 141 */         this.cache.getInvocationContext().setOptionOverrides(option);
/*     */ 
/* 143 */         this.cache.putForExternalRead(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */       }
/*     */       else {
/* 146 */         this.cache.putForExternalRead(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */       }
/*     */     }
/*     */     catch (TimeoutException te)
/*     */     {
/* 151 */       log.debug("ignoring write lock acquisition failure");
/*     */     }
/*     */     catch (Exception e) {
/* 154 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */     finally {
/* 157 */       resume(tx);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void resume(Transaction tx) {
/*     */     try {
/* 163 */       if (tx != null) this.transactionManager.resume(tx); 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 166 */       throw new CacheException("Could not resume transaction", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Transaction suspend() {
/* 171 */     Transaction tx = null;
/*     */     try {
/* 173 */       if (this.transactionManager != null)
/* 174 */         tx = this.transactionManager.suspend();
/*     */     }
/*     */     catch (SystemException se)
/*     */     {
/* 178 */       throw new CacheException("Could not suspend transaction", se);
/*     */     }
/* 180 */     return tx;
/*     */   }
/*     */ 
/*     */   public void remove(Object key) throws CacheException {
/*     */     try {
/* 185 */       if (this.localWritesOnly) {
/* 186 */         Option option = new Option();
/* 187 */         option.setCacheModeLocal(true);
/* 188 */         this.cache.getInvocationContext().setOptionOverrides(option);
/* 189 */         this.cache.removeNode(new Fqn(this.regionFqn, new Object[] { key }));
/*     */       }
/*     */       else {
/* 192 */         this.cache.removeNode(new Fqn(this.regionFqn, new Object[] { key }));
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/* 196 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clear() throws CacheException {
/*     */     try {
/* 202 */       this.cache.removeNode(this.regionFqn);
/*     */     }
/*     */     catch (Exception e) {
/* 205 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */     throws CacheException
/*     */   {
/*     */     try
/*     */     {
/* 218 */       InvocationContext ctx = this.cache.getInvocationContext();
/* 219 */       Option opt = new Option();
/* 220 */       opt.setCacheModeLocal(true);
/* 221 */       ctx.setOptionOverrides(opt);
/* 222 */       this.cache.removeNode(this.regionFqn);
/*     */ 
/* 224 */       if ((this.cache.getConfiguration().isUseRegionBasedMarshalling()) && (!SecondLevelCacheUtil.isSharedClassLoaderRegion(this.regionName)))
/*     */       {
/* 226 */         inactivateCacheRegion();
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/* 230 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void lock(Object key) throws CacheException {
/* 235 */     throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
/*     */   }
/*     */ 
/*     */   public void unlock(Object key) throws CacheException {
/* 239 */     throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
/*     */   }
/*     */ 
/*     */   public long nextTimestamp() {
/* 243 */     return System.currentTimeMillis() / 100L;
/*     */   }
/*     */ 
/*     */   public int getTimeout() {
/* 247 */     return 600;
/*     */   }
/*     */ 
/*     */   public String getRegionName() {
/* 251 */     return this.regionName;
/*     */   }
/*     */ 
/*     */   public long getSizeInMemory() {
/* 255 */     return -1L;
/*     */   }
/*     */ 
/*     */   public long getElementCountInMemory() {
/*     */     try {
/* 260 */       Set children = getChildrenNames();
/* 261 */       return children.size();
/*     */     } catch (Exception e) {
/*     */     }
/* 264 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   public long getElementCountOnDisk()
/*     */   {
/* 269 */     return 0L;
/*     */   }
/*     */ 
/*     */   public Map toMap() {
/*     */     try {
/* 274 */       Map result = new HashMap();
/* 275 */       Set childrenNames = getChildrenNames();
/* 276 */       if (childrenNames != null) {
/* 277 */         Iterator iter = childrenNames.iterator();
/* 278 */         while (iter.hasNext()) {
/* 279 */           Object key = iter.next();
/* 280 */           result.put(key, this.cache.get(new Fqn(this.regionFqn, new Object[] { key }), "item"));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 286 */       return result;
/*     */     } catch (Exception e) {
/*     */     }
/* 289 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   private Set getChildrenNames()
/*     */   {
/*     */     try
/*     */     {
/* 296 */       Node base = this.cache.getRoot().getChild(this.regionFqn);
/* 297 */       return base == null ? null : base.getChildrenNames();
/*     */     } catch (Exception e) {
/*     */     }
/* 300 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 305 */     return "JBCCache(" + this.regionName + ')';
/*     */   }
/*     */ 
/*     */   private void activateCacheRegion(String regionName) throws CacheException
/*     */   {
/* 310 */     Region region = this.cache.getRegion(this.regionFqn, true);
/* 311 */     if (!region.isActive())
/*     */     {
/*     */       try
/*     */       {
/* 317 */         if (!SecondLevelCacheUtil.isSharedClassLoaderRegion(regionName))
/*     */         {
/* 319 */           region.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
/*     */         }
/* 321 */         region.activate();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 325 */         throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void inactivateCacheRegion() throws CacheException
/*     */   {
/* 332 */     Region region = this.cache.getRegion(this.regionFqn, false);
/* 333 */     if ((region != null) && (region.isActive()))
/*     */     {
/*     */       try
/*     */       {
/* 337 */         region.deactivate();
/* 338 */         region.unregisterContextClassLoader();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 342 */         throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.JBCCache
 * JD-Core Version:    0.6.0
 */