/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.persistence.EntityManagerFactory;
/*     */ import org.hibernate.HibernateException;
/*     */ import org.hibernate.Interceptor;
/*     */ import org.hibernate.SessionFactory;
/*     */ import org.hibernate.StatelessSession;
/*     */ import org.hibernate.classic.Session;
/*     */ import org.hibernate.ejb.HibernateEntityManagerFactory;
/*     */ import org.hibernate.engine.FilterDefinition;
/*     */ import org.hibernate.metadata.ClassMetadata;
/*     */ import org.hibernate.metadata.CollectionMetadata;
/*     */ import org.hibernate.stat.Statistics;
/*     */ import org.jboss.ejb3.PersistenceUnitRegistry;
/*     */ 
/*     */ public class InjectedSessionFactory
/*     */   implements SessionFactory, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 7866450655332120010L;
/*     */   private transient EntityManagerFactory delegate;
/*     */   private transient ManagedEntityManagerFactory managedFactory;
/*     */ 
/*     */   public InjectedSessionFactory(ManagedEntityManagerFactory factory)
/*     */   {
/*  62 */     this.managedFactory = factory;
/*  63 */     this.delegate = factory.getEntityManagerFactory();
/*     */   }
/*     */ 
/*     */   public InjectedSessionFactory() {
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out) throws IOException {
/*  70 */     out.writeUTF(this.managedFactory.getKernelName());
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/*  75 */     String kernelName = in.readUTF();
/*  76 */     PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
/*  77 */     if (deployment == null) throw new IOException("Unable to find persistence unit in registry: " + kernelName);
/*  78 */     this.managedFactory = deployment.getManagedFactory();
/*  79 */     this.delegate = this.managedFactory.getEntityManagerFactory();
/*     */   }
/*     */ 
/*     */   private EntityManagerFactory getDelegate()
/*     */   {
/*  84 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   private SessionFactory getSessionFactory()
/*     */   {
/*  89 */     return ((HibernateEntityManagerFactory)getDelegate()).getSessionFactory();
/*     */   }
/*     */ 
/*     */   public Set getDefinedFilterNames()
/*     */   {
/*  94 */     return getSessionFactory().getDefinedFilterNames();
/*     */   }
/*     */ 
/*     */   public FilterDefinition getFilterDefinition(String filterName) throws HibernateException
/*     */   {
/*  99 */     return getSessionFactory().getFilterDefinition(filterName);
/*     */   }
/*     */ 
/*     */   public Session openSession(Connection connection)
/*     */   {
/* 104 */     return getSessionFactory().openSession(connection);
/*     */   }
/*     */ 
/*     */   public Session openSession(Interceptor interceptor)
/*     */     throws HibernateException
/*     */   {
/* 110 */     return getSessionFactory().openSession(interceptor);
/*     */   }
/*     */ 
/*     */   public Session openSession(Connection connection, Interceptor interceptor)
/*     */   {
/* 115 */     return getSessionFactory().openSession(connection, interceptor);
/*     */   }
/*     */ 
/*     */   public Session openSession()
/*     */     throws HibernateException
/*     */   {
/* 121 */     return getSessionFactory().openSession();
/*     */   }
/*     */ 
/*     */   public Session getCurrentSession()
/*     */     throws HibernateException
/*     */   {
/* 127 */     return getSessionFactory().getCurrentSession();
/*     */   }
/*     */ 
/*     */   public ClassMetadata getClassMetadata(Class persistentClass)
/*     */     throws HibernateException
/*     */   {
/* 133 */     return getSessionFactory().getClassMetadata(persistentClass);
/*     */   }
/*     */ 
/*     */   public ClassMetadata getClassMetadata(String entityName)
/*     */     throws HibernateException
/*     */   {
/* 139 */     return getSessionFactory().getClassMetadata(entityName);
/*     */   }
/*     */ 
/*     */   public CollectionMetadata getCollectionMetadata(String roleName)
/*     */     throws HibernateException
/*     */   {
/* 145 */     return getSessionFactory().getCollectionMetadata(roleName);
/*     */   }
/*     */ 
/*     */   public Map getAllClassMetadata()
/*     */     throws HibernateException
/*     */   {
/* 151 */     return getSessionFactory().getAllClassMetadata();
/*     */   }
/*     */ 
/*     */   public Map getAllCollectionMetadata()
/*     */     throws HibernateException
/*     */   {
/* 157 */     return getSessionFactory().getAllCollectionMetadata();
/*     */   }
/*     */ 
/*     */   public Statistics getStatistics()
/*     */   {
/* 162 */     return getSessionFactory().getStatistics();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws HibernateException
/*     */   {
/* 168 */     throw new IllegalStateException("It is illegal to close an injected SessionFactory");
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */   {
/* 173 */     return getSessionFactory().isClosed();
/*     */   }
/*     */ 
/*     */   public void evict(Class persistentClass)
/*     */     throws HibernateException
/*     */   {
/* 179 */     getSessionFactory().evict(persistentClass);
/*     */   }
/*     */ 
/*     */   public void evict(Class persistentClass, Serializable id)
/*     */     throws HibernateException
/*     */   {
/* 185 */     getSessionFactory().evict(persistentClass, id);
/*     */   }
/*     */ 
/*     */   public void evictEntity(String entityName)
/*     */     throws HibernateException
/*     */   {
/* 191 */     getSessionFactory().evictEntity(entityName);
/*     */   }
/*     */ 
/*     */   public void evictEntity(String entityName, Serializable id)
/*     */     throws HibernateException
/*     */   {
/* 197 */     getSessionFactory().evictEntity(entityName, id);
/*     */   }
/*     */ 
/*     */   public void evictCollection(String roleName)
/*     */     throws HibernateException
/*     */   {
/* 203 */     getSessionFactory().evictCollection(roleName);
/*     */   }
/*     */ 
/*     */   public void evictCollection(String roleName, Serializable id)
/*     */     throws HibernateException
/*     */   {
/* 209 */     getSessionFactory().evictCollection(roleName, id);
/*     */   }
/*     */ 
/*     */   public void evictQueries()
/*     */     throws HibernateException
/*     */   {
/* 215 */     getSessionFactory().evictQueries();
/*     */   }
/*     */ 
/*     */   public void evictQueries(String cacheRegion)
/*     */     throws HibernateException
/*     */   {
/* 221 */     getSessionFactory().evictQueries(cacheRegion);
/*     */   }
/*     */ 
/*     */   public StatelessSession openStatelessSession()
/*     */   {
/* 226 */     return getSessionFactory().openStatelessSession();
/*     */   }
/*     */ 
/*     */   public StatelessSession openStatelessSession(Connection connection)
/*     */   {
/* 231 */     return getSessionFactory().openStatelessSession(connection);
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */     throws NamingException
/*     */   {
/* 237 */     return getSessionFactory().getReference();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.InjectedSessionFactory
 * JD-Core Version:    0.6.0
 */