/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.persistence.EntityManager;
/*     */ import javax.persistence.EntityTransaction;
/*     */ import javax.persistence.FlushModeType;
/*     */ import javax.persistence.LockModeType;
/*     */ import javax.persistence.Query;
/*     */ import org.hibernate.Session;
/*     */ import org.hibernate.ejb.HibernateEntityManager;
/*     */ import org.jboss.ejb3.ThreadLocalStack;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*     */ 
/*     */ public class ExtendedEntityManager
/*     */   implements EntityManager, HibernateSession, Serializable, ExtendedPersistenceContext
/*     */ {
/*     */   private static final long serialVersionUID = -2221892311301499591L;
/*     */   private String identity;
/*     */ 
/*     */   public ExtendedEntityManager(String name)
/*     */   {
/*  46 */     this.identity = name;
/*     */   }
/*     */ 
/*     */   public ExtendedEntityManager()
/*     */   {
/*     */   }
/*     */ 
/*     */   public EntityManager getPersistenceContext()
/*     */   {
/*  55 */     StatefulBeanContext beanContext = (StatefulBeanContext)StatefulBeanContext.currentBean.get();
/*  56 */     EntityManager persistenceContext = beanContext.getExtendedPersistenceContext(this.identity);
/*  57 */     if (persistenceContext == null) {
/*  58 */       throw new RuntimeException("Unable to determine persistenceContext: " + this.identity + " in injected SFSB: " + beanContext.getContainer().getObjectName());
/*     */     }
/*  60 */     return persistenceContext;
/*     */   }
/*     */ 
/*     */   public Session getHibernateSession()
/*     */   {
/*  67 */     if ((getPersistenceContext() instanceof HibernateEntityManager))
/*     */     {
/*  69 */       return ((HibernateEntityManager)getPersistenceContext()).getSession();
/*     */     }
/*  71 */     throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
/*     */   }
/*     */ 
/*     */   public void joinTransaction()
/*     */   {
/*  76 */     getPersistenceContext().joinTransaction();
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  81 */     getPersistenceContext().clear();
/*     */   }
/*     */ 
/*     */   public void lock(Object entity, LockModeType lockMode)
/*     */   {
/*  86 */     getPersistenceContext().lock(entity, lockMode);
/*     */   }
/*     */ 
/*     */   public FlushModeType getFlushMode()
/*     */   {
/*  91 */     return getPersistenceContext().getFlushMode();
/*     */   }
/*     */ 
/*     */   public <T> T getReference(Class<T> entityClass, Object primaryKey)
/*     */   {
/*  96 */     return getPersistenceContext().getReference(entityClass, primaryKey);
/*     */   }
/*     */ 
/*     */   public void persist(Object entity)
/*     */   {
/* 101 */     getPersistenceContext().persist(entity);
/*     */   }
/*     */ 
/*     */   public <T> T merge(T entity)
/*     */   {
/* 106 */     return getPersistenceContext().merge(entity);
/*     */   }
/*     */ 
/*     */   public void remove(Object entity)
/*     */   {
/* 111 */     getPersistenceContext().remove(entity);
/*     */   }
/*     */ 
/*     */   public <T> T find(Class<T> entityClass, Object primaryKey)
/*     */   {
/* 116 */     return getPersistenceContext().find(entityClass, primaryKey);
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 121 */     getPersistenceContext().flush();
/*     */   }
/*     */ 
/*     */   public Query createQuery(String ejbqlString)
/*     */   {
/* 126 */     return getPersistenceContext().createQuery(ejbqlString);
/*     */   }
/*     */ 
/*     */   public Query createNamedQuery(String name)
/*     */   {
/* 131 */     return getPersistenceContext().createNamedQuery(name);
/*     */   }
/*     */ 
/*     */   public Query createNativeQuery(String sqlString)
/*     */   {
/* 136 */     return getPersistenceContext().createNativeQuery(sqlString);
/*     */   }
/*     */ 
/*     */   public Query createNativeQuery(String sqlString, Class resultClass)
/*     */   {
/* 141 */     return getPersistenceContext().createNativeQuery(sqlString, resultClass);
/*     */   }
/*     */ 
/*     */   public Query createNativeQuery(String sqlString, String resultSetMapping)
/*     */   {
/* 146 */     return getPersistenceContext().createNativeQuery(sqlString, resultSetMapping);
/*     */   }
/*     */ 
/*     */   public void refresh(Object entity)
/*     */   {
/* 151 */     getPersistenceContext().refresh(entity);
/*     */   }
/*     */ 
/*     */   public boolean contains(Object entity)
/*     */   {
/* 156 */     return getPersistenceContext().contains(entity);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/* 161 */     throw new IllegalStateException("It is illegal to close an injected EntityManager");
/*     */   }
/*     */ 
/*     */   public boolean isOpen()
/*     */   {
/* 166 */     return getPersistenceContext().isOpen();
/*     */   }
/*     */ 
/*     */   public EntityTransaction getTransaction()
/*     */   {
/* 171 */     return getPersistenceContext().getTransaction();
/*     */   }
/*     */ 
/*     */   public void setFlushMode(FlushModeType flushMode)
/*     */   {
/* 176 */     getPersistenceContext().setFlushMode(flushMode);
/*     */   }
/*     */ 
/*     */   public Object getDelegate()
/*     */   {
/* 181 */     return getPersistenceContext().getDelegate();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.ExtendedEntityManager
 * JD-Core Version:    0.6.0
 */