/*     */ package org.jboss.ejb3.embedded.resource;
/*     */ 
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.work.ExecutionContext;
/*     */ import javax.resource.spi.work.Work;
/*     */ import javax.resource.spi.work.WorkException;
/*     */ import javax.resource.spi.work.WorkListener;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.JBossXATerminator;
/*     */ import org.jboss.util.threadpool.BasicThreadPool;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ 
/*     */ public class JBossWorkManager
/*     */   implements WorkManager
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(Ejb3DeploymentInfo.class);
/*     */ 
/*  45 */   private ThreadPool threadPool = new BasicThreadPool();
/*     */   private JBossXATerminator xaTerminator;
/*     */   private ObjectName xaTerminatorName;
/*     */ 
/*     */   public ObjectName getXATerminatorName()
/*     */   {
/*  55 */     return this.xaTerminatorName;
/*     */   }
/*     */ 
/*     */   public void setXATerminatorName(ObjectName xaTerminatorName)
/*     */   {
/*  60 */     this.xaTerminatorName = xaTerminatorName;
/*     */   }
/*     */ 
/*     */   public WorkManager getInstance()
/*     */   {
/*  65 */     return this;
/*     */   }
/*     */ 
/*     */   public void doWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException
/*     */   {
/*  70 */     if (ctx == null)
/*  71 */       ctx = new ExecutionContext();
/*  72 */     WorkWrapper wrapper = new WorkWrapper(this, work, 2, startTimeout, ctx, listener);
/*  73 */     importWork(wrapper);
/*  74 */     executeWork(wrapper);
/*  75 */     if (wrapper.getWorkException() != null)
/*  76 */       throw wrapper.getWorkException();
/*     */   }
/*     */ 
/*     */   public void doWork(Work work) throws WorkException
/*     */   {
/*  81 */     doWork(work, 9223372036854775807L, null, null);
/*     */   }
/*     */ 
/*     */   public long startWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException
/*     */   {
/*  86 */     if (ctx == null)
/*  87 */       ctx = new ExecutionContext();
/*  88 */     WorkWrapper wrapper = new WorkWrapper(this, work, 1, startTimeout, ctx, listener);
/*  89 */     importWork(wrapper);
/*  90 */     executeWork(wrapper);
/*  91 */     if (wrapper.getWorkException() != null)
/*  92 */       throw wrapper.getWorkException();
/*  93 */     return wrapper.getBlockedElapsed();
/*     */   }
/*     */ 
/*     */   public long startWork(Work work) throws WorkException
/*     */   {
/*  98 */     return startWork(work, 9223372036854775807L, null, null);
/*     */   }
/*     */ 
/*     */   public void scheduleWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException
/*     */   {
/* 103 */     if (ctx == null)
/* 104 */       ctx = new ExecutionContext();
/* 105 */     WorkWrapper wrapper = new WorkWrapper(this, work, 0, startTimeout, ctx, listener);
/* 106 */     importWork(wrapper);
/* 107 */     executeWork(wrapper);
/* 108 */     if (wrapper.getWorkException() != null)
/* 109 */       throw wrapper.getWorkException();
/*     */   }
/*     */ 
/*     */   public void scheduleWork(Work work) throws WorkException
/*     */   {
/* 114 */     scheduleWork(work, 9223372036854775807L, null, null);
/*     */   }
/*     */ 
/*     */   protected void importWork(WorkWrapper wrapper)
/*     */     throws WorkException
/*     */   {
/* 125 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 126 */     if (ctx != null)
/*     */     {
/* 128 */       Xid xid = ctx.getXid();
/* 129 */       if (xid != null)
/*     */       {
/* 131 */         long timeout = ctx.getTransactionTimeout();
/* 132 */         this.xaTerminator.registerWork(wrapper.getWork(), xid, timeout);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void executeWork(WorkWrapper wrapper)
/*     */     throws WorkException
/*     */   {
/* 145 */     this.threadPool.runTaskWrapper(wrapper);
/*     */   }
/*     */ 
/*     */   protected void startWork(WorkWrapper wrapper)
/*     */     throws WorkException
/*     */   {
/* 156 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 157 */     if (ctx != null)
/*     */     {
/* 159 */       Xid xid = ctx.getXid();
/* 160 */       if (xid != null)
/*     */       {
/* 162 */         this.xaTerminator.startWork(wrapper.getWork(), xid);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void endWork(WorkWrapper wrapper)
/*     */   {
/* 175 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 176 */     if (ctx != null)
/*     */     {
/* 178 */       Xid xid = ctx.getXid();
/* 179 */       if (xid != null)
/*     */       {
/* 181 */         this.xaTerminator.endWork(wrapper.getWork(), xid);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void cancelWork(WorkWrapper wrapper)
/*     */   {
/* 194 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 195 */     if (ctx != null)
/*     */     {
/* 197 */       Xid xid = ctx.getXid();
/* 198 */       if (xid != null)
/*     */       {
/* 200 */         this.xaTerminator.cancelWork(wrapper.getWork(), xid);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.resource.JBossWorkManager
 * JD-Core Version:    0.6.0
 */