/*    */ package org.jboss.ejb3.embedded.resource;
/*    */ 
/*    */ import java.net.URL;
/*    */ import java.util.jar.JarFile;
/*    */ import java.util.zip.ZipEntry;
/*    */ import org.jboss.deployment.DeploymentInfo;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.resource.deployment.ResourceAdapterObjectModelFactory;
/*    */ import org.jboss.resource.metadata.ConnectorMetaData;
/*    */ import org.jboss.resource.metadata.MessageListenerMetaData;
/*    */ import org.jboss.xb.binding.ObjectModelFactory;
/*    */ import org.jboss.xb.binding.Unmarshaller;
/*    */ import org.jboss.xb.binding.UnmarshallerFactory;
/*    */ 
/*    */ public class Ejb3DeploymentInfo extends DeploymentInfo
/*    */ {
/*    */   private static final long serialVersionUID = -4205809229239091579L;
/* 47 */   private static final Logger log = Logger.getLogger(Ejb3DeploymentInfo.class);
/*    */   protected String rarName;
/*    */   protected String listenerType;
/*    */   protected String activationSpecType;
/*    */ 
/*    */   public Ejb3DeploymentInfo(String rarName, String listenerType, String activationSpecType)
/*    */     throws Exception
/*    */   {
/* 55 */     super(Thread.currentThread().getContextClassLoader().getResource(rarName), null, null);
/*    */ 
/* 57 */     this.rarName = rarName;
/* 58 */     this.listenerType = listenerType;
/* 59 */     this.activationSpecType = activationSpecType;
/*    */ 
/* 61 */     MessageListenerMetaData listener = new MessageListenerMetaData();
/* 62 */     listener.setType(listenerType);
/* 63 */     listener.setActivationSpecType(activationSpecType);
/* 64 */     ConnectorMetaData metaData = getConnectorMetaData();
/* 65 */     this.metaData = metaData;
/*    */   }
/*    */ 
/*    */   protected ConnectorMetaData getConnectorMetaData() throws Exception
/*    */   {
/* 70 */     ObjectModelFactory factory = new ResourceAdapterObjectModelFactory();
/* 71 */     UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
/* 72 */     Unmarshaller unmarshaller = unmarshallerFactory.newUnmarshaller();
/*    */ 
/* 74 */     URL rar = Thread.currentThread().getContextClassLoader().getResource(this.rarName);
/* 75 */     JarFile rarFile = new JarFile(rar.getFile());
/* 76 */     ZipEntry entry = rarFile.getEntry("META-INF/ra.xml");
/*    */ 
/* 78 */     ConnectorMetaData metaData = (ConnectorMetaData)unmarshaller.unmarshal(rarFile.getInputStream(entry), factory, null);
/*    */ 
/* 81 */     return metaData;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.resource.Ejb3DeploymentInfo
 * JD-Core Version:    0.6.0
 */