/*     */ package org.jboss.ejb3.embedded;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.ejb3.tx.TxUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class UserTransactionImpl
/*     */   implements UserTransaction, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 1218305610431187820L;
/*  48 */   protected static Logger log = Logger.getLogger(UserTransactionImpl.class);
/*     */   private TransactionManager tm;
/*     */ 
/*     */   public void start()
/*     */   {
/*  62 */     if (log.isDebugEnabled())
/*  63 */       log.debug("new UserTx: " + this);
/*  64 */     this.tm = TxUtil.getTransactionManager();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*  69 */     this.tm = null;
/*     */   }
/*     */ 
/*     */   public void begin()
/*     */     throws NotSupportedException, SystemException
/*     */   {
/*  76 */     this.tm.begin();
/*     */ 
/*  78 */     Transaction tx = this.tm.getTransaction();
/*  79 */     if (log.isDebugEnabled())
/*  80 */       log.debug("UserTx begin: " + tx);
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */   {
/*  88 */     Transaction tx = this.tm.getTransaction();
/*  89 */     if (log.isDebugEnabled()) {
/*  90 */       log.debug("UserTx commit: " + tx);
/*     */     }
/*  92 */     this.tm.commit();
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws IllegalStateException, SecurityException, SystemException
/*     */   {
/*  98 */     Transaction tx = this.tm.getTransaction();
/*  99 */     if (log.isDebugEnabled())
/* 100 */       log.debug("UserTx rollback: " + tx);
/* 101 */     this.tm.rollback();
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */     throws IllegalStateException, SystemException
/*     */   {
/* 107 */     Transaction tx = this.tm.getTransaction();
/* 108 */     if (log.isDebugEnabled()) {
/* 109 */       log.debug("UserTx setRollbackOnly: " + tx);
/*     */     }
/* 111 */     this.tm.setRollbackOnly();
/*     */   }
/*     */ 
/*     */   public int getStatus()
/*     */     throws SystemException
/*     */   {
/* 117 */     return this.tm.getStatus();
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int seconds)
/*     */     throws SystemException
/*     */   {
/* 127 */     this.tm.setTransactionTimeout(seconds);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 137 */     this.tm = TxUtil.getTransactionManager();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.UserTransactionImpl
 * JD-Core Version:    0.6.0
 */