/*     */ package org.jboss.ejb3.embedded;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.servlet.ServletContext;
/*     */ import javax.servlet.ServletContextEvent;
/*     */ import javax.servlet.ServletContextListener;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
/*     */ import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ServletBootstrapListener
/*     */   implements ServletContextListener
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ServletBootstrapListener.class);
/*     */   protected Kernel kernel;
/*  54 */   protected List<KernelDeployment> deployments = new ArrayList();
/*  55 */   protected List<URL> aopDeployments = new ArrayList();
/*     */ 
/*  86 */   public static Set<Object> ignoredJars = new HashSet();
/*     */   private EJB3StandaloneDeployer deployer;
/*     */ 
/*     */   protected void createKernel()
/*     */     throws Exception
/*     */   {
/*  61 */     BasicBootstrap bootstrap1 = new BasicBootstrap();
/*  62 */     bootstrap1.run();
/*  63 */     this.kernel = bootstrap1.getKernel();
/*     */   }
/*     */ 
/*     */   protected void deployXmlResource(String resource)
/*     */   {
/*     */     try
/*     */     {
/*  70 */       BeanXMLDeployer deployer = new BeanXMLDeployer(this.kernel);
/*  71 */       URL bootstrap = Thread.currentThread().getContextClassLoader().getResource(resource);
/*  72 */       if (bootstrap == null)
/*  73 */         throw new RuntimeException("Cannot find " + resource);
/*  74 */       KernelDeployment deployment = deployer.deploy(bootstrap);
/*  75 */       deployer.validate();
/*  76 */       this.deployments.add(0, deployment);
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/*  80 */       throwable.printStackTrace();
/*  81 */       throw new RuntimeException(throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void contextInitialized(ServletContextEvent servletContextEvent)
/*     */   {
/*     */     try
/*     */     {
/* 141 */       createKernel();
/*     */ 
/* 143 */       ServletContext servletContext = servletContextEvent.getServletContext();
/* 144 */       String aop = servletContext.getInitParameter("jboss-aop-deployments");
/*     */ 
/* 146 */       if (aop == null) aop = "ejb3-interceptors-aop.xml";
/*     */ 
/* 148 */       StringTokenizer tokenizer = new StringTokenizer(aop, ",");
/* 149 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 151 */         String token = tokenizer.nextToken().trim();
/* 152 */         log.debug("deploying aop xml: " + token);
/* 153 */         URL url = Thread.currentThread().getContextClassLoader().getResource(token);
/*     */         try
/*     */         {
/* 156 */           AspectXmlLoader.deployXML(url);
/* 157 */           this.aopDeployments.add(0, url);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 161 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/*     */ 
/* 165 */       String deployments = servletContext.getInitParameter("jboss-kernel-deployments");
/*     */ 
/* 167 */       if (deployments == null) deployments = "embedded-jboss-beans.xml";
/*     */ 
/* 169 */       tokenizer = new StringTokenizer(deployments, ",");
/* 170 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 172 */         String token = tokenizer.nextToken().trim();
/* 173 */         log.debug("deploying kernel xml: " + token);
/* 174 */         deployXmlResource(token);
/*     */       }
/*     */ 
/* 177 */       String scan = servletContext.getInitParameter("automatic-scan");
/* 178 */       if ((scan != null) && (!scan.equals("false"))) return;
/*     */ 
/* 180 */       Set libJars = servletContext.getResourcePaths("/WEB-INF/lib");
/* 181 */       this.deployer = new EJB3StandaloneDeployer();
/* 182 */       this.deployer.setJndiProperties(getInitialContextProperties());
/* 183 */       this.deployer.setKernel(this.kernel);
/* 184 */       for (Iterator i$ = libJars.iterator(); i$.hasNext(); ) { Object jar = i$.next();
/*     */ 
/* 186 */         if (!ignoredJars.contains(jar)) {
/* 187 */           URL archive = servletContext.getResource((String)jar);
/* 188 */           this.deployer.getArchives().add(archive);
/*     */         } }
/* 190 */       if (this.deployer.getArchives().size() == 0)
/*     */       {
/* 192 */         this.deployer = null;
/* 193 */         return;
/*     */       }
/* 195 */       this.deployer.create();
/* 196 */       this.deployer.start();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 200 */       log.error(e);
/* 201 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 204 */     if (!KernelErrors.validate(this.kernel)) throw new RuntimeException("Problems scanning ServletContext.getResourcePaths");
/*     */   }
/*     */ 
/*     */   protected Hashtable getInitialContextProperties()
/*     */   {
/* 209 */     Hashtable hash = null;
/* 210 */     ControllerContext context = this.kernel.getController().getInstalledContext("InitialContextProperties");
/* 211 */     if (context != null)
/* 212 */       hash = (Hashtable)context.getTarget();
/*     */     else
/* 214 */       log.warn("could not find an configured InitialContextProperties, this is ok if your already have a correct jndi.properties file");
/* 215 */     return hash;
/*     */   }
/*     */ 
/*     */   public void contextDestroyed(ServletContextEvent servletContextEvent)
/*     */   {
/*     */     try
/*     */     {
/* 223 */       if (this.deployer != null)
/*     */       {
/* 225 */         this.deployer.stop();
/* 226 */         this.deployer.destroy();
/*     */       }
/* 228 */       BeanXMLDeployer deployer = new BeanXMLDeployer(this.kernel);
/* 229 */       for (KernelDeployment deployment : this.deployments)
/*     */       {
/* 231 */         deployer.undeploy(deployment);
/*     */       }
/*     */ 
/* 234 */       for (URL url : this.aopDeployments)
/*     */       {
/* 236 */         AspectXmlLoader.undeployXML(url);
/*     */       }
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 241 */       throwable.printStackTrace();
/* 242 */       throw new RuntimeException(throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  90 */     ignoredJars.add("/WEB-INF/lib/antlr-2.7.5H3.jar");
/*  91 */     ignoredJars.add("/WEB-INF/lib/asm-attrs.jar");
/*  92 */     ignoredJars.add("/WEB-INF/lib/asm.jar");
/*  93 */     ignoredJars.add("/WEB-INF/lib/cglib-2.1.1.jar");
/*  94 */     ignoredJars.add("/WEB-INF/lib/commons-collections.jar");
/*  95 */     ignoredJars.add("/WEB-INF/lib/commons-logging-api.jar");
/*  96 */     ignoredJars.add("/WEB-INF/lib/commons-logging.jar");
/*  97 */     ignoredJars.add("/WEB-INF/lib/concurrent.jar");
/*  98 */     ignoredJars.add("/WEB-INF/lib/dom4j.jar");
/*  99 */     ignoredJars.add("/WEB-INF/lib/ejb3-persistence.jar");
/* 100 */     ignoredJars.add("/WEB-INF/lib/hibernate3.jar");
/* 101 */     ignoredJars.add("/WEB-INF/lib/hibernate-annotations.jar");
/* 102 */     ignoredJars.add("/WEB-INF/lib/hibernate-entitymanager.jar");
/* 103 */     ignoredJars.add("/WEB-INF/lib/hsqldb.jar");
/* 104 */     ignoredJars.add("/WEB-INF/lib/javassist.jar");
/* 105 */     ignoredJars.add("/WEB-INF/lib/jboss-annotations-ejb3.jar");
/* 106 */     ignoredJars.add("/WEB-INF/lib/jboss-aop-jdk50.jar");
/* 107 */     ignoredJars.add("/WEB-INF/lib/jboss-aspect-library-jdk50.jar");
/* 108 */     ignoredJars.add("/WEB-INF/lib/jboss-common.jar");
/* 109 */     ignoredJars.add("/WEB-INF/lib/jboss-common-jdbc-wrapper.jar");
/* 110 */     ignoredJars.add("/WEB-INF/lib/jboss-container.jar");
/* 111 */     ignoredJars.add("/WEB-INF/lib/jboss-dependency.jar");
/* 112 */     ignoredJars.add("/WEB-INF/lib/jboss-ejb3.jar");
/* 113 */     ignoredJars.add("/WEB-INF/lib/jboss-ejb3x.jar");
/* 114 */     ignoredJars.add("/WEB-INF/lib/jboss-j2ee.jar");
/* 115 */     ignoredJars.add("/WEB-INF/lib/jboss-j2se.jar");
/* 116 */     ignoredJars.add("/WEB-INF/lib/jboss.jar");
/* 117 */     ignoredJars.add("/WEB-INF/lib/jboss-jca.jar");
/* 118 */     ignoredJars.add("/WEB-INF/lib/jboss-local-jdbc.jar");
/* 119 */     ignoredJars.add("/WEB-INF/lib/jboss-microcontainer.jar");
/* 120 */     ignoredJars.add("/WEB-INF/lib/jbossmq.jar");
/* 121 */     ignoredJars.add("/WEB-INF/lib/jboss-remoting.jar");
/* 122 */     ignoredJars.add("/WEB-INF/lib/jbosssx.jar");
/* 123 */     ignoredJars.add("/WEB-INF/lib/jboss-system.jar");
/* 124 */     ignoredJars.add("/WEB-INF/lib/jboss-transaction.jar");
/* 125 */     ignoredJars.add("/WEB-INF/lib/jboss-xa-jdbc.jar");
/* 126 */     ignoredJars.add("/WEB-INF/lib/jnpserver.jar");
/* 127 */     ignoredJars.add("/WEB-INF/lib/log4j.jar");
/* 128 */     ignoredJars.add("/WEB-INF/lib/resolver.jar");
/* 129 */     ignoredJars.add("/WEB-INF/lib/trove.jar");
/* 130 */     ignoredJars.add("/WEB-INF/lib/xercesImpl.jar");
/* 131 */     ignoredJars.add("/WEB-INF/lib/xml-apis.jar");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.ServletBootstrapListener
 * JD-Core Version:    0.6.0
 */