/*     */ package org.jboss.ejb3.embedded;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.JarURLConnection;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.net.URLConnection;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import java.util.jar.JarFile;
/*     */ import java.util.zip.ZipFile;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.ejb3.DeploymentUnit;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.plugins.context.jar.JarUtils;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
/*     */ 
/*     */ public class EJB3StandaloneDeployer
/*     */ {
/* 263 */   protected static final Logger log = Logger.getLogger(EJB3StandaloneDeployer.class);
/*     */ 
/* 265 */   protected Set<URL> archives = new HashSet();
/* 266 */   protected Set<URL> deployDirs = new HashSet();
/* 267 */   protected Set<String> archivesByResource = new HashSet();
/* 268 */   protected Set<String> deployDirsByResource = new HashSet();
/*     */   protected ClassLoader classLoader;
/*     */   private Map defaultPersistenceProperties;
/*     */   private Hashtable jndiProperties;
/* 273 */   private List<EJB3StandaloneDeployment> deployments = new ArrayList();
/*     */   private Kernel kernel;
/*     */   private MBeanServer mbeanServer;
/*     */ 
/*     */   public EJB3StandaloneDeployer()
/*     */   {
/* 281 */     this.classLoader = Thread.currentThread().getContextClassLoader();
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/* 286 */     return this.kernel;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel)
/*     */   {
/* 291 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMbeanServer()
/*     */   {
/* 301 */     return this.mbeanServer;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer mbeanServer)
/*     */   {
/* 306 */     this.mbeanServer = mbeanServer;
/*     */   }
/*     */ 
/*     */   public Set<URL> getArchives()
/*     */   {
/* 316 */     return this.archives;
/*     */   }
/*     */ 
/*     */   public void setArchives(Set archives)
/*     */   {
/* 321 */     new Exception().printStackTrace();
/* 322 */     this.archives = archives;
/*     */   }
/*     */ 
/*     */   public Set<URL> getDeployDirs()
/*     */   {
/* 335 */     return this.deployDirs;
/*     */   }
/*     */ 
/*     */   public void setDeployDirs(Set deployDirs)
/*     */   {
/* 340 */     this.deployDirs = deployDirs;
/*     */   }
/*     */ 
/*     */   public Set<String> getArchivesByResource()
/*     */   {
/* 351 */     return this.archivesByResource;
/*     */   }
/*     */ 
/*     */   public void setArchivesByResource(Set archivesByResource)
/*     */   {
/* 356 */     this.archivesByResource = archivesByResource;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeployDirsByResource()
/*     */   {
/* 368 */     return this.deployDirsByResource;
/*     */   }
/*     */ 
/*     */   public void setDeployDirsByResource(Set deployDirsByResource)
/*     */   {
/* 373 */     this.deployDirsByResource = deployDirsByResource;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 378 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classLoader)
/*     */   {
/* 389 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   public Map getDefaultPersistenceProperties()
/*     */   {
/* 394 */     return this.defaultPersistenceProperties;
/*     */   }
/*     */ 
/*     */   public void setDefaultPersistenceProperties(Map defaultPersistenceProperties)
/*     */   {
/* 406 */     this.defaultPersistenceProperties = defaultPersistenceProperties;
/*     */   }
/*     */ 
/*     */   public Hashtable getJndiProperties()
/*     */   {
/* 411 */     return this.jndiProperties;
/*     */   }
/*     */ 
/*     */   public void setJndiProperties(Hashtable jndiProperties)
/*     */   {
/* 416 */     this.jndiProperties = jndiProperties;
/*     */   }
/*     */ 
/*     */   public List<EJB3StandaloneDeployment> getDeployments()
/*     */   {
/* 426 */     return this.deployments;
/*     */   }
/*     */ 
/*     */   public void setDeployments(List<EJB3StandaloneDeployment> deployments)
/*     */   {
/* 431 */     this.deployments = deployments;
/*     */   }
/*     */ 
/*     */   public static URL getContainingUrlFromResource(URL url, String resource) throws Exception
/*     */   {
/* 436 */     if (url.getProtocol().equals("jar"))
/*     */     {
/* 438 */       URL jarURL = url;
/* 439 */       URLConnection urlConn = jarURL.openConnection();
/* 440 */       JarURLConnection jarConn = (JarURLConnection)urlConn;
/*     */ 
/* 442 */       String parentArchiveName = jarConn.getJarFile().getName();
/* 443 */       File fp = new File(parentArchiveName);
/* 444 */       return fp.toURL();
/*     */     }
/*     */ 
/* 448 */     String base = url.toString();
/* 449 */     int idx = base.lastIndexOf(resource);
/* 450 */     base = base.substring(0, idx);
/* 451 */     return new URL(base);
/*     */   }
/*     */ 
/*     */   public static URL getDeployDirFromResource(URL url, String resource) throws Exception
/*     */   {
/* 456 */     if (url.getProtocol().equals("jar"))
/*     */     {
/* 458 */       URL jarURL = url;
/* 459 */       URLConnection urlConn = jarURL.openConnection();
/* 460 */       JarURLConnection jarConn = (JarURLConnection)urlConn;
/*     */ 
/* 462 */       String parentArchiveName = jarConn.getJarFile().getName();
/* 463 */       File fp = new File(parentArchiveName);
/* 464 */       return fp.getParentFile().toURL();
/*     */     }
/*     */ 
/* 468 */     String base = url.toString();
/* 469 */     int idx = base.lastIndexOf(resource);
/* 470 */     base = base.substring(0, idx);
/* 471 */     File fp = new File(base);
/* 472 */     return fp.getParentFile().toURL();
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 479 */       for (String resource : this.deployDirsByResource)
/*     */       {
/* 481 */         Enumeration urls = this.classLoader.getResources(resource);
/* 482 */         while (urls.hasMoreElements())
/*     */         {
/* 484 */           URL url = (URL)urls.nextElement();
/* 485 */           URL deployUrl = getDeployDirFromResource(url, resource);
/* 486 */           this.deployDirs.add(deployUrl);
/*     */         }
/*     */       }
/*     */ 
/* 490 */       for (URL url : this.deployDirs)
/*     */       {
/* 492 */         File dir = new File(url.toURI());
/* 493 */         for (File fp : dir.listFiles())
/*     */         {
/* 495 */           if (fp.isDirectory())
/*     */           {
/* 497 */             this.archives.add(fp.toURL());
/*     */           }
/*     */           else {
/*     */             try
/*     */             {
/* 502 */               ZipFile zip = new ZipFile(fp);
/* 503 */               zip.entries();
/* 504 */               zip.close();
/* 505 */               this.archives.add(fp.toURL());
/*     */             }
/*     */             catch (IOException e)
/*     */             {
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 513 */       for (String resource : this.archivesByResource)
/*     */       {
/* 515 */         Enumeration urls = this.classLoader.getResources(resource);
/* 516 */         while (urls.hasMoreElements())
/*     */         {
/* 518 */           URL url = (URL)urls.nextElement();
/* 519 */           URL archiveUrl = getContainingUrlFromResource(url, resource);
/* 520 */           this.archives.add(archiveUrl);
/*     */         }
/*     */       }
/*     */ 
/* 524 */       if (this.defaultPersistenceProperties == null)
/*     */       {
/* 526 */         InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("default.persistence.properties");
/* 527 */         if (is == null) throw new RuntimeException("cannot find default.persistence.properties");
/* 528 */         Properties defaults = new Properties();
/* 529 */         defaults.load(is);
/* 530 */         this.defaultPersistenceProperties = defaults;
/*     */       }
/*     */ 
/* 533 */       for (URL archive : this.archives)
/*     */       {
/* 535 */         DeployerUnit du = new DeployerUnit(this.classLoader, archive, this.defaultPersistenceProperties, this.jndiProperties);
/* 536 */         EJB3StandaloneDeployment deployment = new EJB3StandaloneDeployment(du, this.kernel, this.mbeanServer);
/* 537 */         this.deployments.add(deployment);
/* 538 */         deployment.create();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 543 */       e.printStackTrace();
/* 544 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void lookup(String name)
/*     */   {
/* 550 */     System.out.println("lookup " + name);
/*     */     try {
/* 552 */       InitialContext jndiContext = InitialContextFactory.getInitialContext();
/* 553 */       NamingEnumeration names = jndiContext.list(name);
/* 554 */       if (names != null)
/* 555 */         while (names.hasMore())
/* 556 */           System.out.println("  " + names.next());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 567 */       loadMbeanServer();
/*     */ 
/* 569 */       for (EJB3StandaloneDeployment deployment : this.deployments)
/*     */       {
/* 571 */         if (deployment.getMbeanServer() == null)
/*     */         {
/* 573 */           deployment.setMbeanServer(this.mbeanServer);
/*     */         }
/*     */ 
/* 576 */         deployment.start();
/* 577 */         lookup("");
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 582 */       e.printStackTrace();
/* 583 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void loadMbeanServer()
/*     */   {
/* 589 */     if (this.mbeanServer == null)
/*     */     {
/* 591 */       ControllerContext context = this.kernel.getController().getInstalledContext("MBeanServer");
/*     */ 
/* 593 */       if (context != null) {
/* 594 */         this.mbeanServer = ((MBeanServer)context.getTarget());
/*     */       }
/*     */       else {
/* 597 */         ArrayList servers = MBeanServerFactory.findMBeanServer(null);
/* 598 */         if (servers.size() == 0)
/* 599 */           this.mbeanServer = MBeanServerFactory.createMBeanServer();
/*     */         else
/* 601 */           this.mbeanServer = ((MBeanServer)MBeanServerFactory.findMBeanServer(null).get(0));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 608 */     for (EJB3StandaloneDeployment deployment : this.deployments)
/*     */     {
/* 610 */       deployment.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy() throws Exception
/*     */   {
/* 616 */     for (EJB3StandaloneDeployment deployment : this.deployments)
/*     */     {
/* 618 */       deployment.destroy();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class DeployerUnit
/*     */     implements DeploymentUnit
/*     */   {
/*     */     private URL url;
/*     */     private ClassLoader resourceLoader;
/*     */     private ClassLoader loader;
/*     */     private Map defaultProps;
/*     */     private Hashtable jndiProperties;
/*     */     private InterceptorInfoRepository interceptorInfoRepository;
/*     */     private VirtualFile vfsRoot;
/*     */ 
/*     */     public DeployerUnit(ClassLoader loader, URL url, Map defaultProps, Hashtable jndiProperties)
/*     */     {
/*  83 */       this.loader = loader;
/*  84 */       this.url = url;
/*  85 */       URL[] urls = { url };
/*  86 */       URL[] empty = new URL[0];
/*  87 */       URLClassLoader parent = new URLClassLoader(empty)
/*     */       {
/*     */         public URL getResource(String name)
/*     */         {
/*  92 */           return null;
/*     */         }
/*     */       };
/*  95 */       this.resourceLoader = new URLClassLoader(urls, parent);
/*  96 */       this.defaultProps = defaultProps;
/*  97 */       this.jndiProperties = jndiProperties;
/*     */       try
/*     */       {
/* 100 */         VFS vfs = VFS.getVFS(url);
/* 101 */         this.vfsRoot = vfs.getRoot();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 105 */         throw new RuntimeException();
/*     */       }
/* 107 */       this.interceptorInfoRepository = new InterceptorInfoRepository(loader);
/*     */     }
/*     */ 
/*     */     public VirtualFile getRootFile()
/*     */     {
/* 112 */       return this.vfsRoot;
/*     */     }
/*     */ 
/*     */     public URL getRelativeURL(String jar)
/*     */     {
/* 117 */       URL url = null;
/*     */       try
/*     */       {
/* 120 */         url = new URL(jar);
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/*     */         try
/*     */         {
/* 126 */           if (jar.startsWith(".."))
/*     */           {
/* 128 */             if (getUrl() == null)
/* 129 */               throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
/* 130 */             String base = getUrl().toString();
/* 131 */             jar = jar.replaceAll("\\.\\./", "+");
/* 132 */             int idx = jar.lastIndexOf('+');
/* 133 */             jar = jar.substring(idx + 1);
/* 134 */             for (int i = 0; i < idx + 1; i++)
/*     */             {
/* 136 */               int slash = base.lastIndexOf('/');
/* 137 */               base = base.substring(0, slash + 1);
/*     */             }
/* 139 */             url = new URL(base + jar.substring(idx));
/*     */           }
/*     */           else
/*     */           {
/* 143 */             File fp = new File(jar);
/* 144 */             url = fp.toURL();
/*     */           }
/*     */         }
/*     */         catch (MalformedURLException e1)
/*     */         {
/* 149 */           throw new RuntimeException("Unable to find relative url: " + jar, e1);
/*     */         }
/*     */       }
/* 152 */       return url;
/*     */     }
/*     */ 
/*     */     public List<VirtualFile> getResources(VirtualFileFilter filter)
/*     */     {
/* 158 */       VisitorAttributes va = new VisitorAttributes();
/* 159 */       va.setLeavesOnly(true);
/* 160 */       SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
/* 161 */       va.setRecurseFilter(noJars);
/* 162 */       FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
/*     */       try
/*     */       {
/* 165 */         this.vfsRoot.visit(visitor);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 169 */         throw new RuntimeException(e);
/*     */       }
/* 171 */       return visitor.getMatched();
/*     */     }
/*     */ 
/*     */     public Hashtable getJndiProperties()
/*     */     {
/* 177 */       return this.jndiProperties;
/*     */     }
/*     */ 
/*     */     public URL getPersistenceXml()
/*     */     {
/* 182 */       return getResourceLoader().getResource("META-INF/persistence.xml");
/*     */     }
/*     */ 
/*     */     public URL getEjbJarXml()
/*     */     {
/* 187 */       return getResourceLoader().getResource("META-INF/ejb-jar.xml");
/*     */     }
/*     */ 
/*     */     public URL getJbossXml()
/*     */     {
/* 192 */       return getResourceLoader().getResource("META-INF/jboss.xml");
/*     */     }
/*     */ 
/*     */     public List<Class> getClasses()
/*     */     {
/* 197 */       return null;
/*     */     }
/*     */ 
/*     */     public ClassLoader getClassLoader()
/*     */     {
/* 202 */       return this.loader;
/*     */     }
/*     */ 
/*     */     public ClassLoader getResourceLoader()
/*     */     {
/* 207 */       return this.resourceLoader;
/*     */     }
/*     */ 
/*     */     public String getShortName()
/*     */     {
/* 212 */       String url = getUrl().toString();
/* 213 */       if (url.endsWith("/")) url = url.substring(0, url.length() - 1);
/*     */ 
/* 215 */       int dotIdx = url.lastIndexOf('.');
/* 216 */       int slashIdx = url.lastIndexOf('/');
/* 217 */       String name = null;
/* 218 */       if (slashIdx > dotIdx)
/*     */       {
/* 220 */         name = url.substring(url.lastIndexOf('/') + 1);
/*     */       }
/*     */       else
/*     */       {
/* 224 */         name = url.substring(url.lastIndexOf('/') + 1, url.lastIndexOf('.'));
/*     */       }
/* 226 */       return name;
/*     */     }
/*     */ 
/*     */     public URL getUrl()
/*     */     {
/* 231 */       return this.url;
/*     */     }
/*     */ 
/*     */     public String getDefaultEntityManagerName()
/*     */     {
/* 236 */       return getShortName();
/*     */     }
/*     */ 
/*     */     public Map getDefaultPersistenceProperties()
/*     */     {
/* 241 */       return this.defaultProps;
/*     */     }
/*     */ 
/*     */     public InterceptorInfoRepository getInterceptorInfoRepository()
/*     */     {
/* 246 */       return this.interceptorInfoRepository;
/*     */     }
/*     */ 
/*     */     public VirtualFile getMetaDataFile(String path)
/*     */     {
/*     */       try
/*     */       {
/* 253 */         return this.vfsRoot.findChild(path);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 257 */         EJB3StandaloneDeployer.log.debug("Cannot get meta data file: " + path);
/* 258 */       }return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.EJB3StandaloneDeployer
 * JD-Core Version:    0.6.0
 */