/*     */ package org.jboss.ejb3.embedded;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.KernelAbstractionFactory;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
/*     */ import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
/*     */ import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ 
/*     */ public class EJB3StandaloneBootstrap
/*     */ {
/*  63 */   private static final Logger log = Logger.getLogger(EJB3StandaloneBootstrap.class);
/*     */ 
/*  65 */   private static final ObjectName DEFAULT_LOADER_NAME = ObjectNameFactory.create("JMImplementation:service=LoaderRepository,name=Default");
/*     */   public static Kernel kernel;
/*     */   private static MBeanServer mbeanServer;
/*     */   private static EJB3StandaloneDeployer deployer;
/*  73 */   private static boolean warned = false;
/*     */ 
/*  80 */   private static ArrayList<KernelDeployment> deployments = new ArrayList();
/*  81 */   private static ArrayList<URL> aopDeployments = new ArrayList();
/*     */ 
/* 125 */   public static HashSet ignoredJars = new HashSet();
/*     */ 
/*     */   public static Kernel getKernel()
/*     */   {
/*  77 */     return kernel;
/*     */   }
/*     */ 
/*     */   public static void deployXmlResource(String resource)
/*     */   {
/*     */     try
/*     */     {
/*  93 */       BeanXMLDeployer deployer = new BeanXMLDeployer(kernel);
/*  94 */       URL bootstrap = Thread.currentThread().getContextClassLoader().getResource(resource);
/*  95 */       if (bootstrap == null)
/*  96 */         throw new RuntimeException("Cannot find " + resource);
/*  97 */       KernelDeployment deployment = deployer.deploy(bootstrap);
/*  98 */       deployments.add(0, deployment);
/*  99 */       deployer.validate();
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 103 */       throw new RuntimeException(throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object getDeployment(String name)
/*     */   {
/* 109 */     Iterator allDeployments = deployments.iterator();
/* 110 */     while (allDeployments.hasNext())
/*     */     {
/* 112 */       KernelDeployment deployment = (KernelDeployment)allDeployments.next();
/* 113 */       Iterator contexts = deployment.getInstalledContexts().iterator();
/* 114 */       while (contexts.hasNext())
/*     */       {
/* 116 */         AbstractKernelControllerContext context = (AbstractKernelControllerContext)contexts.next();
/* 117 */         if (context.getName().equals(name)) {
/* 118 */           return context.getTarget();
/*     */         }
/*     */       }
/*     */     }
/* 122 */     return null;
/*     */   }
/*     */ 
/*     */   public static Hashtable getInitialContextProperties()
/*     */   {
/* 179 */     Hashtable hash = null;
/* 180 */     ControllerContext context = kernel.getController().getInstalledContext("InitialContextProperties");
/* 181 */     if (context != null) {
/* 182 */       hash = (Hashtable)context.getTarget();
/* 183 */     } else if (!warned)
/*     */     {
/* 185 */       log.warn("Could not find an configured InitialContextProperties, this is ok if your already have a correct jndi.properties file");
/* 186 */       warned = true;
/*     */     }
/* 188 */     return hash;
/*     */   }
/*     */ 
/*     */   public static void scanClasspath(String paths)
/*     */   {
/*     */     try
/*     */     {
/* 201 */       String classpath = System.getProperty("java.class.path");
/* 202 */       StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
/* 203 */       String[] split = paths.split(",");
/* 204 */       for (int i = 0; i < split.length; i++)
/*     */       {
/* 206 */         split[i] = split[i].trim();
/*     */       }
/*     */ 
/* 209 */       deployer = createDeployer();
/*     */ 
/* 211 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 213 */         String path = tokenizer.nextToken().trim();
/* 214 */         boolean found = false;
/* 215 */         for (String wantedPath : split)
/*     */         {
/* 217 */           if (!path.endsWith(System.getProperty("file.separator") + wantedPath))
/*     */             continue;
/* 219 */           found = true;
/* 220 */           break;
/*     */         }
/*     */ 
/* 223 */         if (found) {
/* 224 */           File fp = new File(path);
/* 225 */           if (!ignoredJars.contains(fp.getName())) {
/* 226 */             URL archive = fp.toURL();
/* 227 */             deployer.getArchives().add(archive);
/*     */           }
/*     */         }
/*     */       }
/* 229 */       if (deployer.getArchives().size() == 0)
/*     */       {
/* 231 */         deployer = null;
/* 232 */         return;
/*     */       }
/* 234 */       deployer.create();
/* 235 */       deployer.start();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 240 */       throw new RuntimeException(e);
/*     */     }
/* 242 */     if (!KernelErrors.validate(kernel)) throw new RuntimeException("Problems scanning classpath");
/*     */   }
/*     */ 
/*     */   public static void scanClasspath()
/*     */   {
/*     */     try
/*     */     {
/* 255 */       String classpath = System.getProperty("java.class.path");
/* 256 */       StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
/*     */ 
/* 258 */       deployer = createDeployer();
/*     */ 
/* 260 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 262 */         String path = tokenizer.nextToken();
/* 263 */         File fp = new File(path);
/* 264 */         if (!ignoredJars.contains(fp.getName())) {
/* 265 */           URL archive = fp.toURL();
/* 266 */           deployer.getArchives().add(archive);
/*     */         }
/*     */       }
/* 268 */       if (deployer.getArchives().size() == 0)
/*     */       {
/* 270 */         deployer = null;
/* 271 */         return;
/*     */       }
/* 273 */       deployer.create();
/* 274 */       deployer.start();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 279 */       throw new RuntimeException(e);
/*     */     }
/* 281 */     if (!KernelErrors.validate(kernel)) throw new RuntimeException("Problems scanning classpath");
/*     */   }
/*     */ 
/*     */   public static EJB3StandaloneDeployer createDeployer()
/*     */   {
/* 294 */     EJB3StandaloneDeployer deployer = new EJB3StandaloneDeployer();
/* 295 */     deployer.setJndiProperties(getInitialContextProperties());
/* 296 */     deployer.setKernel(kernel);
/* 297 */     deployer.setMbeanServer(mbeanServer);
/*     */ 
/* 299 */     return deployer;
/*     */   }
/*     */ 
/*     */   public static void shutdown()
/*     */   {
/*     */     try
/*     */     {
/* 306 */       if (deployer != null)
/*     */       {
/* 308 */         deployer.stop();
/* 309 */         deployer.destroy();
/* 310 */         deployer = null;
/*     */       }
/* 312 */       BeanXMLDeployer deployer = new BeanXMLDeployer(kernel);
/* 313 */       for (KernelDeployment deployment : deployments)
/*     */       {
/* 315 */         deployer.undeploy(deployment);
/*     */       }
/*     */ 
/* 318 */       for (URL url : aopDeployments)
/*     */       {
/*     */         try
/*     */         {
/* 322 */           AspectXmlLoader.undeployXML(url);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 326 */           log.warn(e);
/*     */         }
/*     */       }
/* 329 */       kernel = null;
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 333 */       log.warn(throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void initInitialContext()
/*     */   {
/* 340 */     Properties jndiProps = new Properties();
/* 341 */     jndiProps.put("java.naming.factory.initial", "org.jnp.interfaces.LocalOnlyContextFactory");
/* 342 */     jndiProps.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
/* 343 */     InitialContextFactory.setProperties(jndiProps);
/*     */   }
/*     */ 
/*     */   public static void boot(String configPath)
/*     */   {
/* 353 */     initInitialContext();
/*     */ 
/* 355 */     String basePath = "";
/* 356 */     if ((configPath != null) && (!configPath.equals("")))
/*     */     {
/* 358 */       basePath = configPath;
/* 359 */       if (!configPath.endsWith("/"))
/*     */       {
/* 361 */         basePath = basePath + "/";
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 367 */       URL bootstrap = Thread.currentThread().getContextClassLoader().getResource(basePath + "embedded-jboss-beans.xml");
/* 368 */       createKernel();
/* 369 */       loadMBeanServer();
/* 370 */       BeanXMLDeployer deployer = new BeanXMLDeployer(kernel);
/* 371 */       if (bootstrap == null)
/* 372 */         throw new RuntimeException("Cannot find embedded-jboss-beans.xml");
/* 373 */       deployments.add(0, deployer.deploy(bootstrap));
/* 374 */       deployer.validate();
/*     */ 
/* 376 */       URL ejb3_interceptors = Thread.currentThread().getContextClassLoader().getResource(basePath + "ejb3-interceptors-aop.xml");
/* 377 */       if (ejb3_interceptors == null)
/* 378 */         throw new RuntimeException("Cannot find ejb3-interceptors-aop.xml");
/* 379 */       AspectXmlLoader.deployXML(ejb3_interceptors);
/* 380 */       aopDeployments.add(ejb3_interceptors);
/*     */ 
/* 382 */       getDeployment("");
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 386 */       throw new RuntimeException(throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void loadMBeanServer() throws Exception
/*     */   {
/* 392 */     ControllerContext context = kernel.getController().getInstalledContext("MBeanServer");
/*     */ 
/* 394 */     if (context != null)
/*     */     {
/* 396 */       mbeanServer = (MBeanServer)context.getTarget();
/*     */     }
/*     */     else
/*     */     {
/* 400 */       ArrayList servers = MBeanServerFactory.findMBeanServer(null);
/* 401 */       if (servers.size() == 0)
/*     */       {
/* 403 */         mbeanServer = MBeanServerFactory.createMBeanServer();
/* 404 */         MBeanServerLocator.setJBoss(mbeanServer);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void createKernel()
/*     */     throws Exception
/*     */   {
/* 413 */     BasicBootstrap bootstrap1 = new BasicBootstrap();
/* 414 */     bootstrap1.run();
/* 415 */     kernel = bootstrap1.getKernel();
/* 416 */     KernelAbstractionFactory.setKernel(kernel);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 129 */     ignoredJars.add("antlr-2.7.5H3.jar");
/* 130 */     ignoredJars.add("asm-attrs.jar");
/* 131 */     ignoredJars.add("asm.jar");
/* 132 */     ignoredJars.add("cglib-2.1.1.jar");
/* 133 */     ignoredJars.add("commons-collections.jar");
/* 134 */     ignoredJars.add("commons-logging-api.jar");
/* 135 */     ignoredJars.add("commons-logging.jar");
/* 136 */     ignoredJars.add("concurrent.jar");
/* 137 */     ignoredJars.add("dom4j.jar");
/* 138 */     ignoredJars.add("ejb3-persistence.jar");
/* 139 */     ignoredJars.add("hibernate3.jar");
/* 140 */     ignoredJars.add("hibernate-annotations.jar");
/* 141 */     ignoredJars.add("hibernate-entitymanager.jar");
/* 142 */     ignoredJars.add("hsqldb.jar");
/* 143 */     ignoredJars.add("javassist.jar");
/* 144 */     ignoredJars.add("jboss-annotations-ejb3.jar");
/* 145 */     ignoredJars.add("jboss-aop-jdk50.jar");
/* 146 */     ignoredJars.add("jboss-aspect-library-jdk50.jar");
/* 147 */     ignoredJars.add("jboss-common.jar");
/* 148 */     ignoredJars.add("jboss-common-jdbc-wrapper.jar");
/* 149 */     ignoredJars.add("jboss-container.jar");
/* 150 */     ignoredJars.add("jboss-dependency.jar");
/* 151 */     ignoredJars.add("jboss-ejb3.jar");
/* 152 */     ignoredJars.add("jboss-ejb3x.jar");
/* 153 */     ignoredJars.add("jboss-j2ee.jar");
/* 154 */     ignoredJars.add("jboss-j2se.jar");
/* 155 */     ignoredJars.add("jboss.jar");
/* 156 */     ignoredJars.add("jboss-jca.jar");
/* 157 */     ignoredJars.add("jboss-local-jdbc.jar");
/* 158 */     ignoredJars.add("jboss-microcontainer.jar");
/* 159 */     ignoredJars.add("jbossmq.jar");
/* 160 */     ignoredJars.add("jboss-remoting.jar");
/* 161 */     ignoredJars.add("jbosssx.jar");
/* 162 */     ignoredJars.add("jboss-system.jar");
/* 163 */     ignoredJars.add("jboss-transaction.jar");
/* 164 */     ignoredJars.add("jboss-xa-jdbc.jar");
/* 165 */     ignoredJars.add("jnpserver.jar");
/* 166 */     ignoredJars.add("log4j.jar");
/* 167 */     ignoredJars.add("resolver.jar");
/* 168 */     ignoredJars.add("trove.jar");
/* 169 */     ignoredJars.add("xercesImpl.jar");
/* 170 */     ignoredJars.add("xml-apis.jar");
/* 171 */     ignoredJars.add("jboss-ejb3-all.jar");
/* 172 */     ignoredJars.add("hibernate-all.jar");
/* 173 */     ignoredJars.add("thirdparty-all.jar");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.EJB3StandaloneBootstrap
 * JD-Core Version:    0.6.0
 */