/*     */ package org.jboss.ejb3.deployers;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import javax.persistence.spi.PersistenceUnitTransactionType;
/*     */ import org.hibernate.cfg.EJB3DTDEntityResolver;
/*     */ import org.hibernate.ejb.packaging.PersistenceXmlLoader;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
/*     */ import org.jboss.ejb3.protocol.jarjar.Handler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class PersistenceUnitParsingDeployer extends AbstractVFSParsingDeployer<PersistenceUnitsMetaData>
/*     */ {
/*     */   private static final Logger log;
/*     */ 
/*     */   public PersistenceUnitParsingDeployer()
/*     */   {
/*  62 */     super(PersistenceUnitsMetaData.class);
/*  63 */     setName("persistence.xml");
/*     */   }
/*     */ 
/*     */   protected PersistenceUnitsMetaData parse(DeploymentUnit unit, String name, PersistenceUnitsMetaData root)
/*     */     throws Exception
/*     */   {
/*  70 */     VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
/*     */ 
/*  72 */     VirtualFile file = vfsDeploymentUnit.getMetaDataFile(name);
/*  73 */     if (file == null)
/*     */     {
/*     */       try
/*     */       {
/*  78 */         file = vfsDeploymentUnit.getFile("WEB-INF/classes/META-INF/persistence.xml");
/*  79 */         if (file == null)
/*  80 */           return null;
/*     */       }
/*     */       catch (IllegalStateException e)
/*     */       {
/*  84 */         return null;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  89 */     PersistenceUnitsMetaData result = parse(vfsDeploymentUnit, file, root);
/*  90 */     if (result != null)
/*  91 */       init(vfsDeploymentUnit, result, file);
/*  92 */     return result;
/*     */   }
/*     */ 
/*     */   protected PersistenceUnitsMetaData parse(VFSDeploymentUnit unit, VirtualFile file, PersistenceUnitsMetaData root)
/*     */     throws Exception
/*     */   {
/*  99 */     VirtualFile persistenceRoot = file.getParent().getParent();
/*     */ 
/* 109 */     URL persistenceUnitRootUrl = persistenceRoot.getHandler().toURL();
/* 110 */     assert ((persistenceUnitRootUrl.getProtocol().equals("jar")) || (persistenceUnitRootUrl.getProtocol().equals("file"))) : ("expected a jar or file url, but was " + persistenceUnitRootUrl);
/*     */ 
/* 112 */     URL persistenceXmlUrl = file.toURL();
/* 113 */     PersistenceUnitsMetaData metaData = new PersistenceUnitsMetaData(persistenceUnitRootUrl, PersistenceXmlLoader.deploy(persistenceXmlUrl, new HashMap(), new EJB3DTDEntityResolver(), PersistenceUnitTransactionType.JTA));
/*     */ 
/* 115 */     log.info("Found persistence units " + metaData);
/*     */ 
/* 117 */     return metaData;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  53 */     log = Logger.getLogger(PersistenceUnitParsingDeployer.class);
/*     */ 
/*  57 */     Handler.init();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.PersistenceUnitParsingDeployer
 * JD-Core Version:    0.6.0
 */