/*    */ package org.jboss.ejb3.deployers;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
/*    */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*    */ import org.jboss.metadata.client.spec.ApplicationClientMetaData;
/*    */ 
/*    */ public class JBossClientParsingDeployer extends SchemaResolverDeployer<JBossClientMetaData>
/*    */ {
/*    */   public JBossClientParsingDeployer()
/*    */   {
/* 48 */     super(JBossClientMetaData.class);
/*    */ 
/* 50 */     setInputs(new Class[] { ApplicationClientMetaData.class });
/* 51 */     setName("jboss-client.xml");
/*    */   }
/*    */ 
/*    */   protected void createMetaData(DeploymentUnit unit, String name, String suffix)
/*    */     throws DeploymentException
/*    */   {
/* 60 */     super.createMetaData(unit, name, suffix);
/* 61 */     JBossClientMetaData jbossMetaData = (JBossClientMetaData)getMetaData(unit, JBossClientMetaData.class.getName());
/* 62 */     ApplicationClientMetaData acmd = (ApplicationClientMetaData)unit.getAttachment(ApplicationClientMetaData.class);
/*    */ 
/* 64 */     if ((jbossMetaData == null) && (acmd == null)) {
/* 65 */       return;
/*    */     }
/*    */ 
/* 68 */     if (jbossMetaData == null)
/*    */     {
/* 70 */       jbossMetaData = new JBossClientMetaData();
/*    */     }
/*    */ 
/* 73 */     JBossClientMetaData metaData = new JBossClientMetaData();
/* 74 */     metaData.merge(jbossMetaData, acmd, true);
/*    */ 
/* 76 */     unit.getTransientManagedObjects().addAttachment(JBossClientMetaData.class.getName(), metaData, getOutput());
/*    */ 
/* 79 */     unit.getTransientManagedObjects().addAttachment("Raw" + JBossClientMetaData.class.getName(), jbossMetaData, getOutput());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.JBossClientParsingDeployer
 * JD-Core Version:    0.6.0
 */