/*     */ package org.jboss.ejb3.deployers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.ejb3.DeploymentUnit;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.plugins.context.jar.JarUtils;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
/*     */ 
/*     */ public class JBoss5DeploymentUnit
/*     */   implements DeploymentUnit
/*     */ {
/*     */   private VFSDeploymentUnit unit;
/*     */   private ClassLoader classLoader;
/*     */   private InterceptorInfoRepository interceptorInfoRepository;
/*     */   private Map defaultPersistenceProperties;
/*     */ 
/*     */   public JBoss5DeploymentUnit(VFSDeploymentUnit unit)
/*     */   {
/*  55 */     this(unit, unit.getClassLoader());
/*     */   }
/*     */ 
/*     */   public JBoss5DeploymentUnit(VFSDeploymentUnit unit, ClassLoader classLoader)
/*     */   {
/*  60 */     assert (unit != null) : "unit is null";
/*  61 */     assert (classLoader != null) : "classLoader is null";
/*     */ 
/*  63 */     this.unit = unit;
/*  64 */     this.classLoader = classLoader;
/*  65 */     this.interceptorInfoRepository = new InterceptorInfoRepository(classLoader);
/*     */   }
/*     */ 
/*     */   public VirtualFile getRootFile()
/*     */   {
/*  70 */     return this.unit.getFile("");
/*     */   }
/*     */ 
/*     */   public URL getRelativeURL(String jar)
/*     */   {
/*     */     try
/*     */     {
/*  77 */       return new URL(jar);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*     */       try
/*     */       {
/*  83 */         if (getUrl() == null)
/*  84 */           throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
/*  85 */         return new URL(getUrl(), jar);
/*     */       } catch (Exception e1) {
/*     */       }
/*     */     }
/*  89 */     throw new RuntimeException("could not find relative path: " + jar, e1);
/*     */   }
/*     */ 
/*     */   URL extractDescriptorUrl(String resource)
/*     */   {
/*     */     try
/*     */     {
/*  98 */       VirtualFile vf = this.unit.getMetaDataFile(resource);
/*  99 */       if (vf == null) return null;
/* 100 */       return vf.toURL();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 104 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public URL getPersistenceXml()
/*     */   {
/* 110 */     return extractDescriptorUrl("persistence.xml");
/*     */   }
/*     */ 
/*     */   public URL getEjbJarXml()
/*     */   {
/* 115 */     return extractDescriptorUrl("ejb-jar.xml");
/*     */   }
/*     */ 
/*     */   public URL getJbossXml()
/*     */   {
/* 120 */     return extractDescriptorUrl("jboss.xml");
/*     */   }
/*     */ 
/*     */   public VirtualFile getMetaDataFile(String name)
/*     */   {
/* 125 */     return this.unit.getMetaDataFile(name);
/*     */   }
/*     */ 
/*     */   public List<Class> getClasses()
/*     */   {
/* 130 */     return null;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 135 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public ClassLoader getResourceLoader()
/*     */   {
/* 140 */     return getClassLoader();
/*     */   }
/*     */ 
/*     */   public String getShortName()
/*     */   {
/* 145 */     return this.unit.getFile("").getName();
/*     */   }
/*     */ 
/*     */   public URL getUrl()
/*     */   {
/*     */     try
/*     */     {
/* 152 */       return this.unit.getFile("").toURL();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 156 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public String getDefaultEntityManagerName()
/*     */   {
/* 162 */     String url = getUrl().toString();
/* 163 */     String name = url.substring(url.lastIndexOf('/') + 1, url.lastIndexOf('.'));
/* 164 */     return name;
/*     */   }
/*     */ 
/*     */   public Map getDefaultPersistenceProperties()
/*     */   {
/* 169 */     return this.defaultPersistenceProperties;
/*     */   }
/*     */ 
/*     */   public void setDefaultPersistenceProperties(Map defaultPersistenceProperties)
/*     */   {
/* 174 */     this.defaultPersistenceProperties = defaultPersistenceProperties;
/*     */   }
/*     */ 
/*     */   public Hashtable getJndiProperties()
/*     */   {
/* 179 */     return null;
/*     */   }
/*     */ 
/*     */   public InterceptorInfoRepository getInterceptorInfoRepository()
/*     */   {
/* 184 */     return this.interceptorInfoRepository;
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getResources(VirtualFileFilter filter)
/*     */   {
/* 189 */     VisitorAttributes va = new VisitorAttributes();
/* 190 */     va.setLeavesOnly(true);
/* 191 */     SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
/* 192 */     va.setRecurseFilter(noJars);
/* 193 */     FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
/*     */     try
/*     */     {
/* 197 */       VirtualFile root = getRootFile();
/* 198 */       if (!root.isLeaf())
/* 199 */         root.visit(visitor);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 203 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 206 */     List resources = visitor.getMatched();
/*     */ 
/* 208 */     return resources;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.JBoss5DeploymentUnit
 * JD-Core Version:    0.6.0
 */