/*    */ package org.jboss.ejb3.deployers;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.concurrent.ConcurrentHashMap;
/*    */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*    */ import org.jboss.ejb3.DeploymentScope;
/*    */ import org.jboss.ejb3.DeploymentUnit;
/*    */ import org.jboss.ejb3.Ejb3Deployment;
/*    */ 
/*    */ public class JBoss5DeploymentScope
/*    */   implements DeploymentScope
/*    */ {
/*    */   private ConcurrentHashMap<String, Ejb3Deployment> deployments;
/*    */   private String shortName;
/*    */   private String baseName;
/*    */ 
/*    */   public JBoss5DeploymentScope(VFSDeploymentUnit parent)
/*    */   {
/* 46 */     this.shortName = parent.getSimpleName();
/* 47 */     this.baseName = this.shortName;
/*    */ 
/* 49 */     int idx = this.shortName.lastIndexOf('.');
/* 50 */     if (idx > 0) {
/* 51 */       this.baseName = this.shortName.substring(0, idx);
/*    */     }
/* 53 */     this.deployments = ((ConcurrentHashMap)parent.getAttachment("EJB_DEPLOYMENTS"));
/* 54 */     if (this.deployments == null)
/*    */     {
/* 56 */       this.deployments = new ConcurrentHashMap();
/* 57 */       parent.addAttachment("EJB_DEPLOYMENTS", this.deployments);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Collection<Ejb3Deployment> getEjbDeployments()
/*    */   {
/* 63 */     return this.deployments.values();
/*    */   }
/*    */ 
/*    */   public void register(Ejb3Deployment deployment)
/*    */   {
/* 68 */     this.deployments.put(deployment.getDeploymentUnit().getShortName(), deployment);
/*    */   }
/*    */ 
/*    */   public void unregister(Ejb3Deployment deployment)
/*    */   {
/* 73 */     this.deployments.remove(deployment.getDeploymentUnit().getShortName());
/*    */   }
/*    */ 
/*    */   public Ejb3Deployment findRelativeDeployment(String relativeName)
/*    */   {
/* 78 */     if (relativeName.startsWith("../"))
/*    */     {
/* 80 */       relativeName = relativeName.substring(3);
/*    */     }
/* 82 */     return (Ejb3Deployment)this.deployments.get(relativeName);
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 87 */     return this.shortName;
/*    */   }
/*    */ 
/*    */   public String getShortName()
/*    */   {
/* 92 */     return this.shortName;
/*    */   }
/*    */ 
/*    */   public String getBaseName()
/*    */   {
/* 97 */     return this.baseName;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.JBoss5DeploymentScope
 * JD-Core Version:    0.6.0
 */