/*     */ package org.jboss.ejb3.deployers;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.deployment.security.JaccPolicyUtil;
/*     */ import org.jboss.ejb3.DeploymentScope;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.cache.CacheFactoryRegistry;
/*     */ import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry;
/*     */ import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
/*     */ import org.jboss.ejb3.pool.PoolFactoryRegistry;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactoryRegistry;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class Ejb3Deployer extends AbstractVFSRealDeployer
/*     */ {
/*     */   private Set<String> allowedSuffixes;
/*     */   private Properties defaultPersistenceProperties;
/*     */   private boolean deploymentDescriptorRequired;
/*     */   private Set<String> ignoredJarsSet;
/*     */   private Kernel kernel;
/*     */   private MBeanServer mbeanServer;
/*     */   private CacheFactoryRegistry cacheFactoryRegistry;
/*     */   private PoolFactoryRegistry poolFactoryRegistry;
/*     */   private RemoteProxyFactoryRegistry remoteProxyFactoryRegistry;
/*     */   private PersistenceManagerFactoryRegistry persistenceManagerFactoryRegistry;
/*     */ 
/*     */   public Ejb3Deployer()
/*     */   {
/*  78 */     addInput(JBossMetaData.class);
/*     */ 
/*  80 */     addInput(PersistenceUnitsMetaData.class);
/*     */ 
/*  82 */     setOutput(Ejb3Deployment.class);
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  88 */     deploy(unit, (JBossMetaData)unit.getAttachment(JBossMetaData.class), (PersistenceUnitsMetaData)unit.getAttachment(PersistenceUnitsMetaData.class));
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit, JBossMetaData metaData, PersistenceUnitsMetaData persistenceUnitsMetaData)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/*  96 */       if ((metaData != null) && ((metaData.isEJB2x()) || (metaData.isEJB1x())))
/*     */       {
/*  98 */         assert (persistenceUnitsMetaData == null) : "Found persistence units in legacy deployment";
/*     */ 
/* 100 */         this.log.debug("Ignoring legacy EJB deployment " + unit);
/* 101 */         return;
/*     */       }
/*     */ 
/* 104 */       VirtualFile jar = unit.getRoot();
/* 105 */       if ((jar.isLeaf()) || (this.ignoredJarsSet.contains(jar.getName())))
/*     */       {
/* 107 */         this.log.trace(getClass().getName() + " ignoring: " + jar.getName());
/* 108 */         return;
/*     */       }
/* 110 */       if (!hasAllowedSuffix(jar.getName()))
/*     */       {
/* 112 */         this.log.trace(getClass().getName() + " suffix not allowed: " + jar.getName());
/* 113 */         return;
/*     */       }
/*     */ 
/* 118 */       if ((isDeploymentDescriptorRequired()) && (metaData == null) && (persistenceUnitsMetaData == null))
/*     */       {
/* 120 */         this.log.trace(getClass().getSimpleName() + " skipping deployment \"" + unit.getSimpleName() + "\", jar: \"" + jar.getName() + "\" - either EJB3 Deployment Descriptor or \"jboss.xml\" is required and neither were found.");
/*     */ 
/* 123 */         return;
/*     */       }
/*     */ 
/* 126 */       this.log.debug("********* " + getClass().getSimpleName() + " Begin Unit: " + unit.getSimpleName() + " jar: " + jar.getName());
/*     */ 
/* 128 */       DeploymentScope scope = null;
/* 129 */       VFSDeploymentUnit parent = unit.getParent();
/* 130 */       if ((parent != null) && (parent.getSimpleName().endsWith(".ear")))
/*     */       {
/* 132 */         scope = (DeploymentScope)parent.getAttachment(DeploymentScope.class);
/* 133 */         if (scope == null)
/*     */         {
/* 135 */           scope = new JBoss5DeploymentScope(unit.getParent());
/* 136 */           parent.addAttachment(DeploymentScope.class, scope);
/*     */         }
/*     */       }
/* 139 */       JBoss5DeploymentUnit du = new JBoss5DeploymentUnit(unit);
/* 140 */       du.setDefaultPersistenceProperties(this.defaultPersistenceProperties);
/* 141 */       Ejb3JBoss5Deployment deployment = new Ejb3JBoss5Deployment(du, this.kernel, this.mbeanServer, unit, scope, metaData, persistenceUnitsMetaData, this);
/*     */ 
/* 143 */       if (scope != null) scope.register(deployment);
/*     */ 
/* 145 */       deployment.create();
/* 146 */       if ((deployment.getEjbContainers().size() == 0) && (deployment.getPersistenceUnitDeployments().size() == 0))
/*     */       {
/* 148 */         this.log.trace("Found no containers in scanned jar, consider adding it to the ignore list: " + jar.getName() + " url: " + jar.toURL() + " unit: " + unit.getSimpleName());
/* 149 */         deployment.destroy();
/* 150 */         return;
/*     */       }
/* 152 */       unit.addAttachment(Ejb3Deployment.class, deployment);
/*     */ 
/* 154 */       unit.addAttachment(JaccPolicyUtil.IGNORE_ME_NAME, Boolean.valueOf(true), Boolean.class);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 158 */       throw new DeploymentException("Error deploying " + unit.getSimpleName() + ": " + t.getMessage(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set<String> getAllowedSuffixes()
/*     */   {
/* 164 */     return this.allowedSuffixes;
/*     */   }
/*     */ 
/*     */   public CacheFactoryRegistry getCacheFactoryRegistry()
/*     */   {
/* 169 */     return this.cacheFactoryRegistry;
/*     */   }
/*     */ 
/*     */   public void setCacheFactoryRegistry(CacheFactoryRegistry cacheFactoryRegistry)
/*     */   {
/* 174 */     this.cacheFactoryRegistry = cacheFactoryRegistry;
/*     */   }
/*     */ 
/*     */   public PoolFactoryRegistry getPoolFactoryRegistry()
/*     */   {
/* 179 */     return this.poolFactoryRegistry;
/*     */   }
/*     */ 
/*     */   public void setPoolFactoryRegistry(PoolFactoryRegistry poolFactoryRegistry)
/*     */   {
/* 184 */     this.poolFactoryRegistry = poolFactoryRegistry;
/*     */   }
/*     */ 
/*     */   public RemoteProxyFactoryRegistry getRemoteProxyFactoryRegistry()
/*     */   {
/* 189 */     return this.remoteProxyFactoryRegistry;
/*     */   }
/*     */ 
/*     */   public void setRemoteProxyFactoryRegistry(RemoteProxyFactoryRegistry remoteProxyFactoryRegistry)
/*     */   {
/* 194 */     this.remoteProxyFactoryRegistry = remoteProxyFactoryRegistry;
/*     */   }
/*     */ 
/*     */   public PersistenceManagerFactoryRegistry getPersistenceManagerFactoryRegistry()
/*     */   {
/* 199 */     return this.persistenceManagerFactoryRegistry;
/*     */   }
/*     */ 
/*     */   public void setPersistenceManagerFactoryRegistry(PersistenceManagerFactoryRegistry persistenceManagerFactoryRegistry)
/*     */   {
/* 204 */     this.persistenceManagerFactoryRegistry = persistenceManagerFactoryRegistry;
/*     */   }
/*     */ 
/*     */   private boolean hasAllowedSuffix(String name)
/*     */   {
/* 209 */     if (this.allowedSuffixes == null) {
/* 210 */       return true;
/*     */     }
/* 212 */     for (String suffix : this.allowedSuffixes)
/*     */     {
/* 214 */       if (name.endsWith(suffix))
/*     */       {
/* 216 */         return true;
/*     */       }
/*     */     }
/* 219 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isDeploymentDescriptorRequired()
/*     */   {
/* 224 */     return this.deploymentDescriptorRequired;
/*     */   }
/*     */ 
/*     */   public void setAllowedSuffixes(Set<String> s)
/*     */   {
/* 229 */     this.allowedSuffixes = s;
/*     */   }
/*     */ 
/*     */   public void setDefaultPersistenceProperties(Properties p)
/*     */   {
/* 234 */     this.defaultPersistenceProperties = p;
/*     */   }
/*     */ 
/*     */   public void setDeploymentDescriptorRequired(boolean b)
/*     */   {
/* 239 */     this.deploymentDescriptorRequired = b;
/*     */   }
/*     */ 
/*     */   public void setIgnoredJarsSet(Set<String> s)
/*     */   {
/* 244 */     this.ignoredJarsSet = s;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel)
/*     */   {
/* 249 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer server)
/*     */   {
/* 254 */     this.mbeanServer = server;
/*     */   }
/*     */ 
/*     */   public void undeploy(VFSDeploymentUnit unit)
/*     */   {
/* 260 */     Ejb3Deployment deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
/* 261 */     if (deployment == null) return;
/*     */ 
/*     */     try
/*     */     {
/* 265 */       deployment.destroy();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 269 */       this.log.warn("Failed to destroy deployment " + deployment, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.Ejb3Deployer
 * JD-Core Version:    0.6.0
 */