/*     */ package org.jboss.ejb3.deployers;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.jar.Attributes;
/*     */ import java.util.jar.Attributes.Name;
/*     */ import java.util.jar.Manifest;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.structure.ClassPathEntry;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.KernelAbstraction;
/*     */ import org.jboss.ejb3.MCKernelAbstraction;
/*     */ import org.jboss.ejb3.clientmodule.ClientENCInjectionContainer;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class Ejb3ClientDeployer extends AbstractSimpleVFSRealDeployer<JBossClientMetaData>
/*     */ {
/*     */   private Kernel kernel;
/*     */   private MBeanServer server;
/*  61 */   private boolean linkDeploymentJndiName = true;
/*     */ 
/*     */   public Ejb3ClientDeployer()
/*     */   {
/*  68 */     super(JBossClientMetaData.class);
/*  69 */     setOutput(ClientENCInjectionContainer.class);
/*     */   }
/*     */ 
/*     */   public boolean isLinkDeploymentJndiName()
/*     */   {
/*  74 */     return this.linkDeploymentJndiName;
/*     */   }
/*     */ 
/*     */   public void setLinkDeploymentJndiName(boolean linkDeploymentJndiName)
/*     */   {
/*  79 */     this.linkDeploymentJndiName = linkDeploymentJndiName;
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit, JBossClientMetaData metaData)
/*     */     throws DeploymentException
/*     */   {
/*  85 */     this.log.debug("deploy " + unit.getName());
/*     */ 
/*  87 */     String appClientName = getJndiName(metaData);
/*  88 */     String deploymentClientName = null;
/*  89 */     if (appClientName == null)
/*  90 */       appClientName = getDeploymentJndiName(unit);
/*  91 */     else if (this.linkDeploymentJndiName) {
/*  92 */       deploymentClientName = getDeploymentJndiName(unit);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  97 */       InitialContext iniCtx = InitialContextFactory.getInitialContext();
/*  98 */       Context encCtx = Util.createSubcontext(iniCtx, appClientName);
/*  99 */       this.log.debug("Creating client ENC binding under: " + appClientName);
/* 100 */       if ((deploymentClientName != null) && (!deploymentClientName.equals(appClientName)))
/*     */       {
/* 102 */         Util.createLinkRef(iniCtx, deploymentClientName, appClientName);
/*     */       }
/*     */ 
/* 106 */       encCtx.bind("classPathEntries", getClassPathEntries(unit));
/*     */ 
/* 110 */       encCtx.bind("metaData", metaData);
/*     */ 
/* 112 */       String mainClassName = getMainClassName(unit, true);
/*     */ 
/* 114 */       Class mainClass = loadClass(unit, mainClassName);
/*     */ 
/* 116 */       ClientENCInjectionContainer container = new ClientENCInjectionContainer(unit, metaData, mainClass, appClientName, unit.getClassLoader(), encCtx);
/*     */ 
/* 119 */       unit.addAttachment(ClientENCInjectionContainer.class, container);
/* 120 */       getKernelAbstraction().install(container.getObjectName().getCanonicalName(), container.getDependencyPolicy(), container);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 124 */       this.log.error("Could not deploy " + unit.getName(), e);
/* 125 */       undeploy(unit, metaData);
/* 126 */       throw new DeploymentException("Could not deploy " + unit.getName(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private List<ClassPathEntry> getClassPathEntries(VFSDeploymentUnit unit)
/*     */   {
/* 137 */     StructureMetaData smd = (StructureMetaData)unit.getTopLevel().getAttachment(StructureMetaData.class);
/* 138 */     if (smd == null) {
/* 139 */       return null;
/*     */     }
/* 141 */     return smd.getContext("").getClassPath();
/*     */   }
/*     */ 
/*     */   private String getJndiName(JBossClientMetaData dd)
/*     */   {
/* 154 */     String jndiName = dd.getJndiName();
/* 155 */     return jndiName;
/*     */   }
/*     */ 
/*     */   private String getDeploymentJndiName(DeploymentUnit unit)
/*     */   {
/* 160 */     String shortName = unit.getSimpleName();
/*     */     String jndiName;
/* 161 */     if (shortName.endsWith(".jar/")) {
/* 162 */       jndiName = shortName.substring(0, shortName.length() - 5);
/*     */     }
/*     */     else
/*     */     {
/*     */       String jndiName;
/* 163 */       if (shortName.endsWith(".jar"))
/* 164 */         jndiName = shortName.substring(0, shortName.length() - 4);
/*     */       else
/* 166 */         throw new IllegalStateException("Expected either '.jar' or '.jar/' at the end of " + shortName);
/*     */     }
/*     */     String jndiName;
/* 168 */     return jndiName;
/*     */   }
/*     */ 
/*     */   private KernelAbstraction getKernelAbstraction()
/*     */   {
/* 178 */     return new MCKernelAbstraction(this.kernel, this.server);
/*     */   }
/*     */ 
/*     */   protected String getMainClassName(VFSDeploymentUnit unit, boolean fail)
/*     */     throws Exception
/*     */   {
/* 184 */     VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
/* 185 */     this.log.trace("parsing " + file);
/*     */ 
/* 187 */     String mainClassName = "org.jboss.client.AppClientMain";
/*     */ 
/* 189 */     if (file != null)
/*     */     {
/*     */       try
/*     */       {
/* 193 */         Manifest mf = VFSUtils.readManifest(file);
/* 194 */         Attributes attrs = mf.getMainAttributes();
/* 195 */         String className = attrs.getValue(Attributes.Name.MAIN_CLASS);
/* 196 */         if (className != null)
/*     */         {
/* 198 */           mainClassName = className;
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 203 */         file.close();
/*     */       }
/*     */     }
/* 206 */     return mainClassName;
/*     */   }
/*     */ 
/*     */   private Class<?> loadClass(DeploymentUnit unit, String className) throws ClassNotFoundException
/*     */   {
/* 211 */     ClassLoader old = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 214 */       Thread.currentThread().setContextClassLoader(unit.getClassLoader());
/* 215 */       Class localClass = Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */       return localClass; } finally { Thread.currentThread().setContextClassLoader(old); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel)
/*     */   {
/* 225 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer server)
/*     */   {
/* 230 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public void undeploy(VFSDeploymentUnit unit, JBossClientMetaData metaData)
/*     */   {
/* 236 */     this.log.debug("undeploy " + unit.getName());
/*     */ 
/* 238 */     ClientENCInjectionContainer container = (ClientENCInjectionContainer)unit.getAttachment(ClientENCInjectionContainer.class);
/* 239 */     if (container != null) {
/* 240 */       getKernelAbstraction().uninstall(container.getObjectName().getCanonicalName());
/*     */     }
/* 242 */     String appClientName = getJndiName(metaData);
/* 243 */     String deploymentClientName = null;
/* 244 */     if (appClientName == null)
/* 245 */       appClientName = getDeploymentJndiName(unit);
/* 246 */     else if (this.linkDeploymentJndiName) {
/* 247 */       deploymentClientName = getDeploymentJndiName(unit);
/*     */     }
/* 249 */     this.log.debug("Removing client ENC from: " + appClientName);
/*     */     try
/*     */     {
/* 252 */       InitialContext iniCtx = InitialContextFactory.getInitialContext();
/* 253 */       Util.unbind(iniCtx, appClientName);
/* 254 */       if ((deploymentClientName != null) && (!deploymentClientName.equals(appClientName))) {
/* 255 */         Util.removeLinkRef(deploymentClientName);
/*     */       }
/*     */     }
/*     */     catch (NameNotFoundException e)
/*     */     {
/* 260 */       this.log.debug("Could not find client ENC");
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 264 */       this.log.error("Failed to remove client ENC", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.Ejb3ClientDeployer
 * JD-Core Version:    0.6.0
 */