/*     */ package org.jboss.ejb3.deployers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Field;
/*     */ import java.util.jar.Attributes;
/*     */ import java.util.jar.Attributes.Name;
/*     */ import java.util.jar.Manifest;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class AppClientScanningDeployer extends AbstractOptionalVFSRealDeployer<JBossClientMetaData>
/*     */ {
/*     */   public AppClientScanningDeployer()
/*     */   {
/*  47 */     super(JBossClientMetaData.class);
/*  48 */     setOutput(JBossClientMetaData.class);
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit, JBossClientMetaData dd)
/*     */     throws DeploymentException
/*     */   {
/*  61 */     if (dd != null) {
/*  62 */       return;
/*     */     }
/*     */     try
/*     */     {
/*  66 */       String mainClassName = getMainClassName(unit);
/*  67 */       if (mainClassName == null) {
/*  68 */         return;
/*     */       }
/*  70 */       Class mainClass = unit.getClassLoader().loadClass(mainClassName);
/*     */ 
/*  72 */       this.log.info("mainClass = " + mainClass);
/*     */ 
/*  74 */       if (hasAnnotations(mainClass))
/*     */       {
/*  77 */         dd = new JBossClientMetaData();
/*  78 */         unit.addAttachment(JBossClientMetaData.class, dd);
/*     */       }
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  83 */       throw new DeploymentException(e);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  87 */       throw new DeploymentException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getMainClassName(VFSDeploymentUnit unit)
/*     */     throws IOException
/*     */   {
/*  94 */     VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
/*  95 */     this.log.trace("parsing " + file);
/*     */ 
/*  97 */     if (file == null)
/*     */     {
/*  99 */       return null;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 104 */       Manifest mf = VFSUtils.readManifest(file);
/* 105 */       Attributes attrs = mf.getMainAttributes();
/* 106 */       String className = attrs.getValue(Attributes.Name.MAIN_CLASS);
/* 107 */       String str1 = className;
/*     */       return str1; } finally { file.close(); } throw localObject;
/*     */   }
/*     */ 
/*     */   private boolean hasAnnotations(Class<?> cls)
/*     */   {
/* 118 */     if (cls == null) {
/* 119 */       return false;
/*     */     }
/*     */ 
/* 122 */     if (cls.getAnnotations().length > 0) {
/* 123 */       return true;
/*     */     }
/* 125 */     for (Field f : cls.getDeclaredFields())
/*     */     {
/* 127 */       if (f.getAnnotations().length > 0) {
/* 128 */         return true;
/*     */       }
/*     */     }
/* 131 */     return hasAnnotations(cls.getSuperclass());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.AppClientScanningDeployer
 * JD-Core Version:    0.6.0
 */