/*    */ package org.jboss.ejb3.deployers;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*    */ 
/*    */ public abstract class AbstractOptionalVFSRealDeployer<T> extends AbstractRealDeployer
/*    */ {
/*    */   private Class<T> optionalInput;
/*    */ 
/*    */   public AbstractOptionalVFSRealDeployer(Class<T> optionalInput)
/*    */   {
/* 42 */     assert (optionalInput != null) : "optionalInput is null";
/*    */ 
/* 44 */     this.optionalInput = optionalInput;
/* 45 */     setInputs(new Class[] { optionalInput });
/*    */   }
/*    */ 
/*    */   public void internalDeploy(DeploymentUnit unit) throws DeploymentException
/*    */   {
/* 50 */     deploy(unit, unit.getAttachment(this.optionalInput));
/*    */   }
/*    */ 
/*    */   public void deploy(DeploymentUnit unit, T deployment) throws DeploymentException
/*    */   {
/* 55 */     if (!(unit instanceof VFSDeploymentUnit)) {
/* 56 */       return;
/*    */     }
/* 58 */     VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
/* 59 */     deploy(vfsDeploymentUnit, deployment);
/*    */   }
/*    */ 
/*    */   public abstract void deploy(VFSDeploymentUnit paramVFSDeploymentUnit, T paramT)
/*    */     throws DeploymentException;
/*    */ 
/*    */   public void internalUndeploy(DeploymentUnit unit)
/*    */   {
/* 74 */     undeploy(unit, unit.getAttachment(this.optionalInput));
/*    */   }
/*    */ 
/*    */   public void undeploy(DeploymentUnit unit, T deployment)
/*    */   {
/* 79 */     if (!(unit instanceof VFSDeploymentUnit)) {
/* 80 */       return;
/*    */     }
/* 82 */     VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
/* 83 */     undeploy(vfsDeploymentUnit, deployment);
/*    */   }
/*    */ 
/*    */   public void undeploy(VFSDeploymentUnit unit, T deployment)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.AbstractOptionalVFSRealDeployer
 * JD-Core Version:    0.6.0
 */