/*     */ package org.jboss.ejb3.dependency;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import org.jboss.beans.metadata.spi.DemandMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class JndiDemandMetaData extends JBossObject
/*     */   implements DemandMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  55 */   private static final Logger log = Logger.getLogger(JndiDemandMetaData.class);
/*     */   private String jndiName;
/*     */   private Object demand;
/*     */   private ClassLoader loader;
/*  63 */   private ControllerState whenRequired = ControllerState.INSTALLED;
/*     */ 
/*     */   public JndiDemandMetaData(String jndiName, ClassLoader loader)
/*     */   {
/*  73 */     this.jndiName = jndiName;
/*  74 */     this.loader = loader;
/*     */   }
/*     */ 
/*     */   public Object getDemand()
/*     */   {
/*  79 */     return this.demand;
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequired()
/*     */   {
/*  84 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/*  89 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/*  94 */     return null;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/*  99 */     KernelControllerContext context = visitor.getControllerContext();
/* 100 */     DependencyItem item = new JndiDemandDependencyItem(context.getName());
/* 101 */     visitor.addDependency(item);
/* 102 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 108 */     buffer.append("demand=").append(this.jndiName);
/* 109 */     buffer.append(" whenRequired=").append(this.whenRequired.getStateString());
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 115 */     buffer.append(this.jndiName);
/*     */   }
/*     */ 
/*     */   private class JndiDemandDependencyItem extends AbstractDependencyItem
/*     */   {
/*     */     public JndiDemandDependencyItem(Object name)
/*     */     {
/* 122 */       super(null, JndiDemandMetaData.this.whenRequired, null);
/*     */     }
/*     */ 
/*     */     public boolean resolve(Controller controller)
/*     */     {
/* 128 */       ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/*     */       try
/*     */       {
/* 131 */         Thread.currentThread().setContextClassLoader(JndiDemandMetaData.this.loader);
/* 132 */         InitialContext ctx = new InitialContext();
/* 133 */         JndiDemandMetaData.access$202(JndiDemandMetaData.this, ctx.lookup(JndiDemandMetaData.this.jndiName));
/* 134 */         setResolved(true);
/* 135 */         boolean bool = isResolved();
/*     */         return bool;
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/*     */       }
/*     */       catch (Throwable ignored)
/*     */       {
/* 143 */         if (JndiDemandMetaData.log.isTraceEnabled())
/* 144 */           JndiDemandMetaData.log.trace("Unexpected error", ignored);
/*     */       }
/*     */       finally
/*     */       {
/* 148 */         Thread.currentThread().setContextClassLoader(tcl);
/*     */       }
/* 150 */       setResolved(false);
/* 151 */       return isResolved();
/*     */     }
/*     */ 
/*     */     public void toString(JBossStringBuilder buffer)
/*     */     {
/* 157 */       super.toString(buffer);
/* 158 */       buffer.append(" demand=").append(JndiDemandMetaData.this.jndiName);
/*     */     }
/*     */ 
/*     */     public void toShortString(JBossStringBuilder buffer)
/*     */     {
/* 164 */       buffer.append(getName()).append(" demands ").append(JndiDemandMetaData.this.jndiName);
/*     */     }
/*     */ 
/*     */     public String toHumanReadableString()
/*     */     {
/* 170 */       StringBuilder builder = new StringBuilder();
/* 171 */       builder.append("Demands '").append(JndiDemandMetaData.this.jndiName);
/* 172 */       return builder.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.dependency.JndiDemandMetaData
 * JD-Core Version:    0.6.0
 */