/*     */ package org.jboss.ejb3.clientmodule;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.Environment;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationUsageType;
/*     */ import org.jboss.metadata.javaee.spec.ResourceAuthorityType;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metamodel.descriptor.EjbLocalRef;
/*     */ import org.jboss.metamodel.descriptor.EjbRef;
/*     */ import org.jboss.metamodel.descriptor.EnvEntry;
/*     */ import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
/*     */ import org.jboss.metamodel.descriptor.InjectionTarget;
/*     */ import org.jboss.metamodel.descriptor.JndiRef;
/*     */ import org.jboss.metamodel.descriptor.MessageDestinationRef;
/*     */ import org.jboss.metamodel.descriptor.PersistenceContextRef;
/*     */ import org.jboss.metamodel.descriptor.PersistenceUnitRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceEnvRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceRef;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*     */ 
/*     */ public class EnvironmentRefGroupConveter extends EnvironmentRefGroup
/*     */ {
/*  64 */   private static final Logger log = Logger.getLogger(EnvironmentRefGroupConveter.class);
/*     */   private Environment refs;
/*     */   private boolean convertedEjbLocalRefs;
/*  67 */   private boolean convertedEjbRefs = false;
/*  68 */   private boolean convertedEnvEntries = false;
/*  69 */   private boolean convertedMessageDestinationRefs = false;
/*  70 */   private boolean convertedResourceEnvRefs = false;
/*  71 */   private boolean convertedResourceRefs = false;
/*  72 */   private boolean convertedServiceRefs = false;
/*     */ 
/*     */   public EnvironmentRefGroupConveter(Environment refs)
/*     */   {
/*  76 */     this.refs = refs;
/*     */   }
/*     */ 
/*     */   public Collection<EjbLocalRef> getEjbLocalRefs()
/*     */   {
/*  82 */     if (!this.convertedEjbLocalRefs)
/*     */     {
/*  84 */       this.convertedEjbLocalRefs = true;
/*     */     }
/*  86 */     return super.getEjbLocalRefs();
/*     */   }
/*     */ 
/*     */   public Collection<EjbRef> getEjbRefs()
/*     */   {
/*  92 */     if (!this.convertedEjbRefs)
/*     */     {
/*  94 */       EJBReferencesMetaData erefs = this.refs.getEjbReferences();
/*  95 */       if (erefs != null)
/*  96 */         for (EJBReferenceMetaData ref : erefs)
/*     */         {
/*  98 */           EjbRef eref = new EjbRef();
/*  99 */           eref.setEjbLink(ref.getLink());
/* 100 */           eref.setEjbRefName(ref.getEjbRefName());
/* 101 */           eref.setEjbRefType(ref.getType());
/* 102 */           eref.setHome(ref.getHome());
/* 103 */           eref.setRemote(ref.getRemote());
/* 104 */           eref.setIgnoreDependency(ref.isDependencyIgnored());
/* 105 */           eref.setMappedName(ref.getMappedName());
/* 106 */           eref.setInjectionTarget(getInjectionTarget(ref.getInjectionTargets()));
/* 107 */           this.ejbRefs.put(ref.getEjbRefName(), eref);
/*     */         }
/* 109 */       log.info("Converted " + this.ejbRefs.size() + " refs: " + this.ejbRefs.keySet());
/* 110 */       this.convertedEjbRefs = true;
/*     */     }
/* 112 */     return super.getEjbRefs();
/*     */   }
/*     */ 
/*     */   public Collection<EnvEntry> getEnvEntries()
/*     */   {
/* 118 */     if (!this.convertedEnvEntries)
/*     */     {
/* 120 */       EnvironmentEntriesMetaData env = this.refs.getEnvironmentEntries();
/* 121 */       if (env != null)
/*     */       {
/* 123 */         for (EnvironmentEntryMetaData entry : env)
/*     */         {
/* 125 */           EnvEntry ee = new EnvEntry();
/* 126 */           ee.setEnvEntryName(entry.getEnvEntryName());
/* 127 */           ee.setEnvEntryType(entry.getType());
/* 128 */           ee.setEnvEntryValue(entry.getValue());
/* 129 */           Set rits = entry.getInjectionTargets();
/* 130 */           if ((rits != null) && (!rits.isEmpty()))
/*     */           {
/* 132 */             ResourceInjectionTargetMetaData rit = (ResourceInjectionTargetMetaData)rits.iterator().next();
/* 133 */             InjectionTarget it = new InjectionTarget();
/* 134 */             it.setTargetClass(rit.getInjectionTargetClass());
/* 135 */             it.setTargetName(rit.getInjectionTargetName());
/* 136 */             ee.setInjectionTarget(it);
/*     */           }
/* 138 */           ee.setIgnoreDependency(entry.isDependencyIgnored());
/* 139 */           this.envEntries.put(ee.getEnvEntryName(), ee);
/*     */         }
/* 141 */         log.info("Converted " + this.envEntries.size() + " envs: " + this.envEntries.keySet());
/*     */       }
/* 143 */       this.convertedEnvEntries = true;
/*     */     }
/* 145 */     return super.getEnvEntries();
/*     */   }
/*     */ 
/*     */   public Collection<JndiRef> getJndiRefs()
/*     */   {
/* 151 */     return super.getJndiRefs();
/*     */   }
/*     */ 
/*     */   public MessageDestinationRef getMessageDestinationRefForLink(String link)
/*     */   {
/* 157 */     if (!this.convertedMessageDestinationRefs)
/* 158 */       getMessageDestinationRefs();
/* 159 */     return super.getMessageDestinationRefForLink(link);
/*     */   }
/*     */ 
/*     */   public Collection<MessageDestinationRef> getMessageDestinationRefs()
/*     */   {
/* 165 */     if (!this.convertedMessageDestinationRefs)
/*     */     {
/* 167 */       MessageDestinationReferencesMetaData mrefs = this.refs.getMessageDestinationReferences();
/* 168 */       if (mrefs != null)
/* 169 */         for (MessageDestinationReferenceMetaData mref : mrefs)
/*     */         {
/* 171 */           MessageDestinationRef ref = new MessageDestinationRef();
/* 172 */           ref.setIgnoreDependency(mref.isDependencyIgnored());
/* 173 */           ref.setMappedName(mref.getMappedName());
/* 174 */           ref.setJndiName(mref.getMappedName());
/* 175 */           ref.setMessageDestinationLink(mref.getLink());
/* 176 */           ref.setMessageDestinationRefName(mref.getMessageDestinationRefName());
/* 177 */           ref.setMessageDestinationType(mref.getType());
/* 178 */           MessageDestinationUsageType usage = mref.getMessageDestinationUsage();
/* 179 */           if (usage != null)
/* 180 */             ref.setMessageDestinationUsage(usage.name());
/* 181 */           this.messageDestinationRefs.put(ref.getMessageDestinationRefName(), ref);
/*     */         }
/* 183 */       log.info("Converted " + this.messageDestinationRefs.size() + " msgRefs: " + this.messageDestinationRefs.keySet());
/* 184 */       this.convertedMessageDestinationRefs = true;
/*     */     }
/* 186 */     return super.getMessageDestinationRefs();
/*     */   }
/*     */ 
/*     */   public List<PersistenceContextRef> getPersistenceContextRefs()
/*     */   {
/* 193 */     return super.getPersistenceContextRefs();
/*     */   }
/*     */ 
/*     */   public List<PersistenceUnitRef> getPersistenceUnitRefs()
/*     */   {
/* 200 */     return super.getPersistenceUnitRefs();
/*     */   }
/*     */ 
/*     */   public Collection<ResourceEnvRef> getResourceEnvRefs()
/*     */   {
/* 206 */     if (!this.convertedResourceEnvRefs)
/*     */     {
/* 208 */       ResourceEnvironmentReferencesMetaData rrefs = this.refs.getResourceEnvironmentReferences();
/* 209 */       if (rrefs != null)
/* 210 */         for (ResourceEnvironmentReferenceMetaData rref : rrefs)
/*     */         {
/* 212 */           ResourceEnvRef ref = new ResourceEnvRef();
/* 213 */           ref.setResRefName(rref.getResourceEnvRefName());
/* 214 */           ref.setIgnoreDependency(ref.isIgnoreDependency());
/* 215 */           ref.setResType(rref.getType());
/* 216 */           ref.setJndiName(rref.getJndiName());
/* 217 */           ref.setMappedName(rref.getMappedName());
/* 218 */           ref.setResAuth("Container");
/* 219 */           ref.setInjectionTarget(getInjectionTarget(rref.getInjectionTargets()));
/* 220 */           this.resourceEnvRefs.put(ref.getResRefName(), ref);
/*     */         }
/* 222 */       log.info("Converted " + this.resourceEnvRefs.size() + " envRefs: " + this.resourceEnvRefs.keySet());
/* 223 */       this.convertedResourceEnvRefs = true;
/*     */     }
/* 225 */     return super.getResourceEnvRefs();
/*     */   }
/*     */ 
/*     */   public Collection<ResourceRef> getResourceRefs()
/*     */   {
/* 231 */     if (!this.convertedResourceRefs)
/*     */     {
/* 233 */       ResourceReferencesMetaData rrefs = this.refs.getResourceReferences();
/* 234 */       if (rrefs != null)
/* 235 */         for (ResourceReferenceMetaData rref : rrefs)
/*     */         {
/* 237 */           ResourceRef ref = new ResourceRef();
/* 238 */           ref.setResRefName(rref.getResourceRefName());
/* 239 */           ref.setIgnoreDependency(ref.isIgnoreDependency());
/* 240 */           ref.setResType(rref.getType());
/* 241 */           ref.setJndiName(rref.getJndiName());
/* 242 */           ref.setMappedName(rref.getMappedName());
/* 243 */           ref.setResUrl(rref.getResUrl());
/* 244 */           ResourceAuthorityType authType = rref.getResAuth();
/* 245 */           if (authType != null)
/* 246 */             ref.setResAuth(authType.name());
/* 247 */           ref.setInjectionTarget(getInjectionTarget(rref.getInjectionTargets()));
/* 248 */           this.resourceRefs.put(ref.getResRefName(), ref);
/*     */         }
/* 250 */       log.info("Converted " + this.resourceRefs.size() + " resRefs: " + this.resourceRefs.keySet());
/* 251 */       this.convertedResourceRefs = true;
/*     */     }
/* 253 */     return super.getResourceRefs();
/*     */   }
/*     */ 
/*     */   public ServiceRefMetaData getServiceRef(String name)
/*     */   {
/* 259 */     if (!this.convertedServiceRefs)
/* 260 */       getServiceRefs();
/* 261 */     return super.getServiceRef(name);
/*     */   }
/*     */ 
/*     */   public Collection<ServiceRefMetaData> getServiceRefs()
/*     */   {
/* 267 */     if (!this.convertedServiceRefs)
/*     */     {
/* 269 */       this.convertedServiceRefs = true;
/*     */     }
/* 271 */     return super.getServiceRefs();
/*     */   }
/*     */ 
/*     */   private InjectionTarget getInjectionTarget(Set<ResourceInjectionTargetMetaData> rits)
/*     */   {
/* 276 */     InjectionTarget it = null;
/* 277 */     if ((rits != null) && (!rits.isEmpty()))
/*     */     {
/* 279 */       ResourceInjectionTargetMetaData rit = (ResourceInjectionTargetMetaData)rits.iterator().next();
/* 280 */       it = new InjectionTarget();
/* 281 */       it.setTargetClass(rit.getInjectionTargetClass());
/* 282 */       it.setTargetName(rit.getInjectionTargetName());
/*     */     }
/* 284 */     return it;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.clientmodule.EnvironmentRefGroupConveter
 * JD-Core Version:    0.6.0
 */