/*     */ package org.jboss.ejb3.clientmodule;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.DependencyPolicy;
/*     */ import org.jboss.ejb3.DeploymentScope;
/*     */ import org.jboss.ejb3.DeploymentUnit;
/*     */ import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
/*     */ import org.jboss.ejb3.deployers.JBoss5DeploymentScope;
/*     */ import org.jboss.ejb3.deployers.JBoss5DeploymentUnit;
/*     */ import org.jboss.ejb3.enc.DeploymentEjbResolver;
/*     */ import org.jboss.ejb3.enc.MessageDestinationResolver;
/*     */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*     */ import org.jboss.ejb3.javaee.AbstractJavaEEComponent;
/*     */ import org.jboss.ejb3.javaee.SimpleJavaEEModule;
/*     */ import org.jboss.injection.DependsHandler;
/*     */ import org.jboss.injection.EJBRemoteHandler;
/*     */ import org.jboss.injection.EncInjector;
/*     */ import org.jboss.injection.InjectionContainer;
/*     */ import org.jboss.injection.InjectionHandler;
/*     */ import org.jboss.injection.InjectionUtil;
/*     */ import org.jboss.injection.Injector;
/*     */ import org.jboss.injection.PersistenceUnitHandler;
/*     */ import org.jboss.injection.ResourceHandler;
/*     */ import org.jboss.injection.WebServiceRefHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.metadata.serviceref.ServiceReferenceHandler;
/*     */ import org.jboss.metadata.serviceref.VirtualFileAdaptor;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ 
/*     */ public class ClientENCInjectionContainer extends AbstractJavaEEComponent
/*     */   implements InjectionContainer
/*     */ {
/*  85 */   private static final Logger log = Logger.getLogger(ClientENCInjectionContainer.class);
/*     */   private DeploymentUnit ejb3Unit;
/*     */   private JBossClientMetaData clientMetaData;
/*     */   private Class<?> mainClass;
/*     */   private String applicationClientName;
/*     */   private ClassLoader classLoader;
/*  94 */   private List<Injector> injectors = new ArrayList();
/*  95 */   private Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap();
/*  96 */   private Map<String, EncInjector> encInjectors = new HashMap();
/*     */   private Context enc;
/*     */   private DeploymentEjbResolver ejbResolver;
/*     */   private DeploymentScope deploymentScope;
/*     */   private ObjectName objectName;
/* 103 */   private DependencyPolicy dependencyPolicy = new JBoss5DependencyPolicy(this);
/*     */   private MessageDestinationResolver messageDestinationResolver;
/*     */ 
/*     */   public ClientENCInjectionContainer(VFSDeploymentUnit unit, JBossClientMetaData xml, Class<?> mainClass, String applicationClientName, ClassLoader classLoader, Context encCtx)
/*     */     throws NamingException
/*     */   {
/* 110 */     super(new SimpleJavaEEModule(unit.getParent() != null ? unit.getParent().getSimpleName() : null, unit.getSimpleName()));
/* 111 */     if (mainClass == null)
/* 112 */       throw new NullPointerException("mainClass is mandatory");
/* 113 */     if (applicationClientName == null)
/* 114 */       throw new NullPointerException("applicationClientName is mandatory");
/* 115 */     if (classLoader == null) {
/* 116 */       throw new NullPointerException("classLoader is mandatory");
/*     */     }
/* 118 */     this.ejb3Unit = new JBoss5DeploymentUnit(unit);
/* 119 */     this.clientMetaData = xml;
/* 120 */     this.mainClass = mainClass;
/* 121 */     this.applicationClientName = applicationClientName;
/* 122 */     this.classLoader = classLoader;
/*     */ 
/* 124 */     this.enc = encCtx;
/*     */ 
/* 147 */     if (unit.getParent() != null)
/*     */     {
/* 149 */       this.deploymentScope = new JBoss5DeploymentScope(unit.getParent());
/*     */     }
/*     */ 
/* 152 */     this.ejbResolver = new ClientEjbResolver(this.deploymentScope, unit.getSimpleName());
/* 153 */     this.messageDestinationResolver = new MessageDestinationResolver(this.deploymentScope, xml.getMessageDestinations());
/*     */ 
/* 155 */     String on = "jboss.j2ee:service=EJB3" + createScopeKernelName(unit, this.deploymentScope) + ",name=" + applicationClientName;
/*     */     try
/*     */     {
/* 158 */       this.objectName = new ObjectName(on);
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 163 */       throw new RuntimeException("Malformed object name " + on, e);
/*     */     }
/*     */ 
/* 166 */     processMetaData();
/*     */   }
/*     */ 
/*     */   private String createScopeKernelName(VFSDeploymentUnit unit, DeploymentScope ear)
/*     */   {
/* 171 */     String scopedKernelName = "";
/* 172 */     if (ear != null)
/* 173 */       scopedKernelName = scopedKernelName + ",ear=" + ear.getShortName();
/* 174 */     scopedKernelName = scopedKernelName + ",jar=" + unit.getSimpleName();
/* 175 */     return scopedKernelName;
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz)
/*     */   {
/* 180 */     return clazz.getAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method)
/*     */   {
/* 185 */     return method.getAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method)
/*     */   {
/* 190 */     return method.getAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field)
/*     */   {
/* 195 */     return field.getAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field)
/*     */   {
/* 200 */     return field.getAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public VirtualFile getRootFile()
/*     */   {
/* 205 */     return this.ejb3Unit.getRootFile();
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassloader()
/*     */   {
/* 210 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public DependencyPolicy getDependencyPolicy()
/*     */   {
/* 215 */     return this.dependencyPolicy;
/*     */   }
/*     */ 
/*     */   public String getDeploymentDescriptorType()
/*     */   {
/* 220 */     return "application-client.xml";
/*     */   }
/*     */ 
/*     */   public String getEjbJndiName(Class businessInterface) throws NameNotFoundException
/*     */   {
/* 225 */     return this.ejbResolver.getEjbJndiName(businessInterface);
/*     */   }
/*     */ 
/*     */   public String getEjbJndiName(String link, Class businessInterface)
/*     */   {
/* 230 */     return this.ejbResolver.getEjbJndiName(link, businessInterface);
/*     */   }
/*     */ 
/*     */   public Context getEnc()
/*     */   {
/* 235 */     return this.enc;
/*     */   }
/*     */ 
/*     */   public Map<String, Map<AccessibleObject, Injector>> getEncInjections()
/*     */   {
/* 240 */     return this.encInjections;
/*     */   }
/*     */ 
/*     */   public Map<String, EncInjector> getEncInjectors()
/*     */   {
/* 245 */     return this.encInjectors;
/*     */   }
/*     */ 
/*     */   public RemoteEnvironment getEnvironmentRefGroup()
/*     */   {
/* 250 */     return this.clientMetaData;
/*     */   }
/*     */ 
/*     */   public String getIdentifier()
/*     */   {
/* 255 */     return this.applicationClientName;
/*     */   }
/*     */ 
/*     */   public List<Injector> getInjectors()
/*     */   {
/* 265 */     return this.injectors;
/*     */   }
/*     */ 
/*     */   public Class<?> getMainClass()
/*     */   {
/* 270 */     return this.mainClass;
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 275 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException
/*     */   {
/* 280 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public boolean hasJNDIBinding(String jndiName)
/*     */   {
/* 285 */     return false;
/*     */   }
/*     */ 
/*     */   private void populateEnc()
/*     */   {
/* 290 */     for (EncInjector injector : this.encInjectors.values())
/*     */     {
/* 292 */       log.trace("encInjector: " + injector);
/* 293 */       injector.inject(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processMetaData()
/*     */   {
/* 299 */     if (this.clientMetaData.getDepends() != null) {
/* 300 */       for (String dependency : this.clientMetaData.getDepends())
/*     */       {
/* 302 */         getDependencyPolicy().addDependency(dependency);
/*     */       }
/*     */     }
/*     */ 
/* 306 */     Collection handlers = new ArrayList();
/* 307 */     handlers.add(new EJBRemoteHandler());
/* 308 */     handlers.add(new DependsHandler());
/*     */ 
/* 311 */     handlers.add(new PersistenceUnitHandler());
/* 312 */     handlers.add(new ResourceHandler());
/* 313 */     handlers.add(new WebServiceRefHandler());
/*     */ 
/* 315 */     ClassLoader old = Thread.currentThread().getContextClassLoader();
/* 316 */     Thread.currentThread().setContextClassLoader(this.classLoader);
/*     */     try
/*     */     {
/* 320 */       for (InjectionHandler handler : handlers) {
/* 321 */         handler.loadXml(this.clientMetaData, this);
/*     */       }
/* 323 */       Map tmp = InjectionUtil.processAnnotations(this, handlers, getMainClass());
/* 324 */       this.injectors.addAll(tmp.values());
/*     */ 
/* 343 */       if (this.clientMetaData != null)
/*     */       {
/* 345 */         ServiceReferencesMetaData serviceRefs = this.clientMetaData.getServiceReferences();
/* 346 */         if (serviceRefs != null)
/*     */         {
/* 348 */           Iterator itRefs = serviceRefs.iterator();
/* 349 */           while (itRefs.hasNext())
/*     */           {
/* 351 */             ServiceReferenceMetaData sref = (ServiceReferenceMetaData)itRefs.next();
/*     */             try
/*     */             {
/* 354 */               String name = sref.getServiceRefName();
/* 355 */               String encName = "env/" + name;
/* 356 */               Context encCtx = getEnc();
/*     */ 
/* 358 */               UnifiedVirtualFile vfsRoot = new VirtualFileAdaptor(getRootFile());
/* 359 */               new ServiceReferenceHandler().bindServiceRef(encCtx, encName, vfsRoot, getClassloader(), sref);
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 364 */               log.error("Failed to bind service-ref", e);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 372 */       Thread.currentThread().setContextClassLoader(old);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Container resolveEjbContainer(String link, Class businessIntf)
/*     */   {
/* 378 */     return this.ejbResolver.getEjbContainer(link, businessIntf);
/*     */   }
/*     */ 
/*     */   public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException
/*     */   {
/* 383 */     return this.ejbResolver.getEjbContainer(businessIntf);
/*     */   }
/*     */ 
/*     */   public String resolveMessageDestination(String link)
/*     */   {
/* 409 */     return this.messageDestinationResolver.resolveMessageDestination(link);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 414 */     populateEnc();
/*     */ 
/* 418 */     log.info("STARTED CLIENT ENC CONTAINER: " + this.applicationClientName);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 423 */     log.info("STOPPED CLIENT ENC CONTAINER: " + this.applicationClientName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.clientmodule.ClientENCInjectionContainer
 * JD-Core Version:    0.6.0
 */