/*     */ package org.jboss.ejb3.cache.tree;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchEJBException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.cache.Cache;
/*     */ import org.jboss.cache.CacheException;
/*     */ import org.jboss.cache.CacheSPI;
/*     */ import org.jboss.cache.Fqn;
/*     */ import org.jboss.cache.InvocationContext;
/*     */ import org.jboss.cache.Node;
/*     */ import org.jboss.cache.Region;
/*     */ import org.jboss.cache.RegionManager;
/*     */ import org.jboss.cache.config.EvictionPolicyConfig;
/*     */ import org.jboss.cache.config.Option;
/*     */ import org.jboss.cache.eviction.LRUConfiguration;
/*     */ import org.jboss.cache.jmx.CacheJmxWrapperMBean;
/*     */ import org.jboss.cache.notifications.annotation.CacheListener;
/*     */ import org.jboss.cache.notifications.annotation.NodeActivated;
/*     */ import org.jboss.cache.notifications.annotation.NodePassivated;
/*     */ import org.jboss.cache.notifications.event.NodeActivatedEvent;
/*     */ import org.jboss.cache.notifications.event.NodePassivatedEvent;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.annotation.CacheConfig;
/*     */ import org.jboss.ejb3.cache.ClusteredStatefulCache;
/*     */ import org.jboss.ejb3.pool.Pool;
/*     */ import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
/*     */ import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
/*     */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class StatefulTreeCache
/*     */   implements ClusteredStatefulCache
/*     */ {
/*     */   private static final int FQN_SIZE = 3;
/*     */   private static final int DEFAULT_BUCKET_COUNT = 100;
/*  79 */   private static final String[] DEFAULT_HASH_BUCKETS = new String[100];
/*     */ 
/*  81 */   private static Option LOCAL_ONLY_OPTION = new Option();
/*  82 */   private static Option GRAVITATE_OPTION = new Option();
/*     */   private ThreadLocal<Boolean> localActivity;
/*     */   private Logger log;
/*     */   private Pool pool;
/*     */   private WeakReference<ClassLoader> classloader;
/*     */   private Cache cache;
/*     */   private Fqn cacheNode;
/*     */   private Region region;
/*     */   private ClusteredStatefulCacheListener listener;
/*     */   public static long MarkInUseWaitTime;
/*     */   protected String[] hashBuckets;
/*     */   protected int createCount;
/*     */   protected int passivatedCount;
/*     */   protected int removeCount;
/*     */   protected long removalTimeout;
/*     */   protected RemovalTimeoutTask removalTask;
/*     */   protected boolean running;
/*     */   protected Map<Object, Long> beans;
/*     */   protected EJBContainer ejbContainer;
/*     */ 
/*     */   public StatefulTreeCache()
/*     */   {
/*  94 */     this.localActivity = new ThreadLocal();
/*  95 */     this.log = Logger.getLogger(StatefulTreeCache.class);
/*     */ 
/* 105 */     this.hashBuckets = DEFAULT_HASH_BUCKETS;
/* 106 */     this.createCount = 0;
/* 107 */     this.passivatedCount = 0;
/* 108 */     this.removeCount = 0;
/* 109 */     this.removalTimeout = 0L;
/* 110 */     this.removalTask = null;
/* 111 */     this.running = true;
/* 112 */     this.beans = new ConcurrentHashMap();
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext create()
/*     */   {
/* 117 */     StatefulBeanContext ctx = null;
/*     */     try
/*     */     {
/* 120 */       ctx = (StatefulBeanContext)this.pool.get();
/* 121 */       if (this.log.isTraceEnabled())
/*     */       {
/* 123 */         this.log.trace("Caching context " + ctx.getId() + " of type " + ctx.getClass());
/*     */       }
/* 125 */       putInCache(ctx);
/* 126 */       ctx.setInUse(true);
/* 127 */       ctx.lastUsed = System.currentTimeMillis();
/* 128 */       this.createCount += 1;
/* 129 */       this.beans.put(ctx.getId(), new Long(ctx.lastUsed));
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 133 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 137 */       throw new EJBException(e);
/*     */     }
/* 139 */     return ctx;
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext create(Class[] initTypes, Object[] initValues)
/*     */   {
/* 144 */     StatefulBeanContext ctx = null;
/*     */     try
/*     */     {
/* 147 */       ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
/* 148 */       if (this.log.isTraceEnabled())
/*     */       {
/* 150 */         this.log.trace("Caching context " + ctx.getId() + " of type " + ctx.getClass());
/*     */       }
/* 152 */       putInCache(ctx);
/* 153 */       ctx.setInUse(true);
/* 154 */       ctx.lastUsed = System.currentTimeMillis();
/* 155 */       this.createCount += 1;
/* 156 */       this.beans.put(ctx.getId(), new Long(ctx.lastUsed));
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 160 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 164 */       throw new EJBException(e);
/*     */     }
/* 166 */     return ctx;
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext get(Object key) throws EJBException
/*     */   {
/* 171 */     return get(key, true);
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException
/*     */   {
/* 176 */     StatefulBeanContext entry = null;
/* 177 */     Fqn id = getFqn(key, false);
/* 178 */     Boolean active = (Boolean)this.localActivity.get();
/*     */     try
/*     */     {
/* 181 */       this.localActivity.set(Boolean.TRUE);
/*     */ 
/* 183 */       InvocationContext ictx = this.cache.getInvocationContext();
/* 184 */       ictx.setOptionOverrides(getGravitateOption());
/* 185 */       entry = (StatefulBeanContext)this.cache.get(id, "bean");
/*     */     }
/*     */     catch (CacheException e)
/*     */     {
/* 189 */       RuntimeException re = convertToRuntimeException(e);
/* 190 */       throw re;
/*     */     }
/*     */     finally
/*     */     {
/* 194 */       this.localActivity.set(active);
/*     */     }
/*     */ 
/* 197 */     if (entry == null)
/*     */     {
/* 199 */       throw new NoSuchEJBException("Could not find stateful bean: " + key);
/*     */     }
/* 201 */     if ((markInUse) && (entry.isRemoved()))
/*     */     {
/* 203 */       throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed)");
/*     */     }
/*     */ 
/* 207 */     entry.postReplicate();
/*     */ 
/* 209 */     if (markInUse)
/*     */     {
/* 211 */       entry.setInUse(true);
/*     */ 
/* 215 */       this.region.markNodeCurrentlyInUse(new Fqn(new Object[] { key.toString() }), MarkInUseWaitTime);
/* 216 */       entry.lastUsed = System.currentTimeMillis();
/* 217 */       this.beans.put(key, new Long(entry.lastUsed));
/*     */     }
/*     */ 
/* 220 */     if (this.log.isTraceEnabled())
/*     */     {
/* 222 */       this.log.trace("get: retrieved bean with cache id " + id.toString());
/*     */     }
/*     */ 
/* 225 */     return entry;
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext peek(Object key) throws NoSuchEJBException
/*     */   {
/* 230 */     return get(key, false);
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/* 235 */     Fqn id = getFqn(key, false);
/*     */     try
/*     */     {
/* 238 */       if (this.log.isTraceEnabled())
/*     */       {
/* 240 */         this.log.trace("remove: cache id " + id.toString());
/*     */       }
/* 242 */       InvocationContext ictx = this.cache.getInvocationContext();
/* 243 */       ictx.setOptionOverrides(getGravitateOption());
/* 244 */       StatefulBeanContext ctx = (StatefulBeanContext)this.cache.get(id, "bean");
/*     */ 
/* 246 */       if (ctx != null)
/*     */       {
/* 248 */         if (!ctx.isRemoved()) {
/* 249 */           this.pool.remove(ctx);
/*     */         }
/* 251 */         if (ctx.getCanRemoveFromCache())
/*     */         {
/* 254 */           this.cache.removeNode(id);
/*     */         }
/*     */         else
/*     */         {
/* 260 */           putInCache(ctx);
/*     */         }
/*     */ 
/* 263 */         this.removeCount += 1;
/* 264 */         this.beans.remove(key);
/*     */       }
/*     */     }
/*     */     catch (CacheException e)
/*     */     {
/* 269 */       RuntimeException re = convertToRuntimeException(e);
/* 270 */       throw re;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void release(StatefulBeanContext ctx)
/*     */   {
/* 276 */     synchronized (ctx)
/*     */     {
/* 278 */       ctx.setInUse(false);
/* 279 */       ctx.lastUsed = System.currentTimeMillis();
/* 280 */       this.beans.put(ctx.getId(), new Long(ctx.lastUsed));
/*     */ 
/* 283 */       this.region.unmarkNodeCurrentlyInUse(getFqn(ctx.getId(), true));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void replicate(StatefulBeanContext ctx)
/*     */   {
/* 292 */     if ((ctx instanceof NestedStatefulBeanContext))
/*     */     {
/* 294 */       throw new IllegalArgumentException("Received unexpected replicate call for nested context " + ctx.getId());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 299 */       putInCache(ctx);
/*     */     }
/*     */     catch (CacheException e)
/*     */     {
/* 303 */       RuntimeException re = convertToRuntimeException(e);
/* 304 */       throw re;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void initialize(Container container) throws Exception
/*     */   {
/* 310 */     this.ejbContainer = ((EJBContainer)container);
/*     */ 
/* 312 */     this.log = Logger.getLogger(getClass().getName() + "." + this.ejbContainer.getEjbName());
/*     */ 
/* 314 */     this.pool = this.ejbContainer.getPool();
/* 315 */     ClassLoader cl = this.ejbContainer.getClassloader();
/* 316 */     this.classloader = new WeakReference(cl);
/*     */ 
/* 318 */     Advisor advisor = this.ejbContainer;
/* 319 */     CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
/* 320 */     MBeanServer server = MBeanServerLocator.locateJBoss();
/* 321 */     String name = config.name();
/* 322 */     if ((name == null) || (name.trim().length() == 0))
/* 323 */       name = "jboss.cache:service=EJB3SFSBClusteredCache";
/* 324 */     ObjectName cacheON = new ObjectName(name);
/* 325 */     CacheJmxWrapperMBean mbean = (CacheJmxWrapperMBean)MBeanProxyExt.create(CacheJmxWrapperMBean.class, cacheON, server);
/* 326 */     this.cache = mbean.getCache();
/*     */ 
/* 328 */     this.cacheNode = new Fqn(new Object[] { this.ejbContainer.getDeploymentQualifiedName() });
/*     */ 
/* 331 */     this.region = this.cache.getRegion(this.cacheNode, true);
/* 332 */     EvictionPolicyConfig epc = getEvictionPolicyConfig((int)config.idleTimeoutSeconds(), config.maxSize());
/*     */ 
/* 334 */     this.region.setEvictionPolicy(epc);
/*     */ 
/* 337 */     cleanBeanRegion();
/*     */ 
/* 340 */     this.region.registerContextClassLoader(cl);
/* 341 */     this.region.activate();
/*     */ 
/* 343 */     this.log.debug("initialize(): created region: " + this.region + " for ejb: " + this.ejbContainer.getEjbName());
/*     */ 
/* 345 */     this.removalTimeout = config.removalTimeoutSeconds();
/* 346 */     if (this.removalTimeout > 0L)
/* 347 */       this.removalTask = new RemovalTimeoutTask("SFSB Removal Thread - " + this.ejbContainer.getObjectName().getCanonicalName());
/*     */   }
/*     */ 
/*     */   protected EvictionPolicyConfig getEvictionPolicyConfig(int timeToLiveSeconds, int maxNodes)
/*     */   {
/* 352 */     LRUConfiguration epc = new LRUConfiguration();
/*     */ 
/* 354 */     epc.setEvictionPolicyClass(AbortableLRUPolicy.class.getName());
/* 355 */     epc.setTimeToLiveSeconds(timeToLiveSeconds);
/* 356 */     epc.setMaxNodes(maxNodes);
/* 357 */     return epc;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 367 */     this.listener = new ClusteredStatefulCacheListener();
/* 368 */     this.cache.addCacheListener(this.listener);
/*     */ 
/* 370 */     if (this.removalTask != null) {
/* 371 */       this.removalTask.start();
/*     */     }
/* 373 */     this.running = true;
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 378 */     this.running = false;
/*     */ 
/* 380 */     if (this.cache != null)
/*     */     {
/* 383 */       if (this.listener != null) {
/* 384 */         this.cache.removeCacheListener(this.listener);
/*     */       }
/*     */ 
/* 388 */       cleanBeanRegion();
/*     */       try
/*     */       {
/* 393 */         InvocationContext ctx = this.cache.getInvocationContext();
/* 394 */         ctx.setOptionOverrides(getLocalOnlyOption());
/* 395 */         this.cache.removeNode(this.cacheNode);
/*     */       }
/*     */       catch (CacheException e)
/*     */       {
/* 399 */         this.log.error("stop(): can't remove bean from the underlying distributed cache");
/*     */       }
/*     */ 
/* 402 */       if (this.region != null)
/*     */       {
/* 404 */         this.region.deactivate();
/* 405 */         this.region.unregisterContextClassLoader();
/*     */ 
/* 408 */         ((CacheSPI)this.cache).getRegionManager().removeRegion(this.region.getFqn());
/*     */ 
/* 410 */         this.region.resetEvictionQueues();
/* 411 */         this.region = null;
/*     */       }
/*     */     }
/*     */ 
/* 415 */     this.classloader = null;
/*     */ 
/* 417 */     if (this.removalTask != null) {
/* 418 */       this.removalTask.interrupt();
/*     */     }
/* 420 */     this.log.debug("stop(): StatefulTreeCache stopped successfully for " + this.cacheNode);
/*     */   }
/*     */ 
/*     */   public int getCacheSize()
/*     */   {
/* 425 */     int count = 0;
/*     */     try
/*     */     {
/* 428 */       Set children = null;
/* 429 */       for (int i = 0; i < this.hashBuckets.length; i++)
/*     */       {
/* 431 */         Node node = this.cache.getRoot().getChild(new Fqn(this.cacheNode, new Object[] { this.hashBuckets[i] }));
/* 432 */         if (node == null)
/*     */           continue;
/* 434 */         children = node.getChildrenNames();
/* 435 */         count += (children == null ? 0 : children.size());
/*     */       }
/*     */ 
/* 438 */       count -= this.passivatedCount;
/*     */     }
/*     */     catch (CacheException e)
/*     */     {
/* 442 */       this.log.error("Caught exception calculating cache size", e);
/* 443 */       count = -1;
/*     */     }
/* 445 */     return count;
/*     */   }
/*     */ 
/*     */   public int getTotalSize()
/*     */   {
/* 450 */     return this.beans.size();
/*     */   }
/*     */ 
/*     */   public int getCreateCount()
/*     */   {
/* 455 */     return this.createCount;
/*     */   }
/*     */ 
/*     */   public int getPassivatedCount()
/*     */   {
/* 460 */     return this.passivatedCount;
/*     */   }
/*     */ 
/*     */   public int getRemoveCount()
/*     */   {
/* 465 */     return this.removeCount;
/*     */   }
/*     */ 
/*     */   public int getAvailableCount()
/*     */   {
/* 470 */     return -1;
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 475 */     return -1;
/*     */   }
/*     */ 
/*     */   public int getCurrentSize()
/*     */   {
/* 480 */     return getCacheSize();
/*     */   }
/*     */ 
/*     */   private void putInCache(StatefulBeanContext ctx)
/*     */   {
/* 485 */     Boolean active = (Boolean)this.localActivity.get();
/*     */     try
/*     */     {
/* 488 */       this.localActivity.set(Boolean.TRUE);
/* 489 */       ctx.preReplicate();
/* 490 */       this.cache.put(getFqn(ctx.getId(), false), "bean", ctx);
/* 491 */       ctx.markedForReplication = false;
/*     */     }
/*     */     finally
/*     */     {
/* 495 */       this.localActivity.set(active);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Fqn getFqn(Object id, boolean regionRelative)
/*     */   {
/* 501 */     String beanId = id.toString();
/*     */     int index;
/*     */     int index;
/* 503 */     if ((id instanceof GUID))
/*     */     {
/* 505 */       index = (id.hashCode() & 0x7FFFFFFF) % this.hashBuckets.length;
/*     */     }
/*     */     else
/*     */     {
/* 509 */       index = (beanId.hashCode() & 0x7FFFFFFF) % this.hashBuckets.length;
/*     */     }
/*     */ 
/* 512 */     if (regionRelative) {
/* 513 */       return new Fqn(new Object[] { this.hashBuckets[index], beanId });
/*     */     }
/* 515 */     return new Fqn(this.cacheNode, new Object[] { this.hashBuckets[index], beanId });
/*     */   }
/*     */ 
/*     */   private void cleanBeanRegion()
/*     */   {
/*     */     try
/*     */     {
/* 522 */       this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
/* 523 */       this.cache.removeNode(this.cacheNode);
/*     */     }
/*     */     catch (CacheException e)
/*     */     {
/* 527 */       this.log.error("Stop(): can't remove bean from the underlying distributed cache");
/*     */     }
/*     */   }
/*     */ 
/*     */   private RuntimeException convertToRuntimeException(CacheException e)
/*     */   {
/* 539 */     RuntimeException re = new RuntimeException(e.getClass().getName() + " " + e.getMessage());
/* 540 */     re.setStackTrace(e.getStackTrace());
/* 541 */     return re;
/*     */   }
/*     */ 
/*     */   private static Option getLocalOnlyOption()
/*     */   {
/*     */     try
/*     */     {
/* 687 */       return LOCAL_ONLY_OPTION.clone();
/*     */     }
/*     */     catch (CloneNotSupportedException e) {
/*     */     }
/* 691 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private static Option getGravitateOption()
/*     */   {
/*     */     try
/*     */     {
/* 699 */       return GRAVITATE_OPTION.clone();
/*     */     }
/*     */     catch (CloneNotSupportedException e) {
/*     */     }
/* 703 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  85 */     LOCAL_ONLY_OPTION.setCacheModeLocal(true);
/*  86 */     GRAVITATE_OPTION.setForceDataGravitation(true);
/*     */ 
/*  88 */     for (int i = 0; i < DEFAULT_HASH_BUCKETS.length; i++)
/*     */     {
/*  90 */       DEFAULT_HASH_BUCKETS[i] = String.valueOf(i);
/*     */     }
/*     */ 
/* 103 */     MarkInUseWaitTime = 15000L;
/*     */   }
/*     */ 
/*     */   private class RemovalTimeoutTask extends Thread
/*     */   {
/*     */     public RemovalTimeoutTask(String name)
/*     */     {
/* 711 */       super();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 716 */       while (StatefulTreeCache.this.running)
/*     */       {
/*     */         try
/*     */         {
/* 720 */           Thread.sleep(StatefulTreeCache.this.removalTimeout * 1000L);
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 724 */           StatefulTreeCache.this.running = false;
/* 725 */           return;
/*     */         }
/*     */         try
/*     */         {
/* 729 */           long now = System.currentTimeMillis();
/*     */ 
/* 731 */           Iterator it = StatefulTreeCache.this.beans.entrySet().iterator();
/* 732 */           while (it.hasNext())
/*     */           {
/* 734 */             Map.Entry entry = (Map.Entry)it.next();
/* 735 */             long lastUsed = ((Long)entry.getValue()).longValue();
/* 736 */             if (now - lastUsed >= StatefulTreeCache.this.removalTimeout * 1000L)
/*     */             {
/* 738 */               StatefulTreeCache.this.remove(entry.getKey());
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 744 */           StatefulTreeCache.this.log.error("problem removing SFSB thread", ex);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   @CacheListener
/*     */   public class ClusteredStatefulCacheListener
/*     */   {
/*     */     public ClusteredStatefulCacheListener()
/*     */     {
/*     */     }
/*     */ 
/*     */     @NodeActivated
/*     */     public void nodeActivated(NodeActivatedEvent event)
/*     */     {
/* 555 */       if (event.isPre()) return;
/* 556 */       Map nodeData = event.getData();
/* 557 */       if (nodeData == null) return;
/* 558 */       Fqn fqn = event.getFqn();
/* 559 */       if (fqn.size() != 3) return;
/* 560 */       if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) return;
/*     */ 
/* 564 */       if (Boolean.TRUE != StatefulTreeCache.this.localActivity.get())
/*     */       {
/* 567 */         StatefulTreeCache.this.passivatedCount -= 1;
/* 568 */         return;
/*     */       }
/*     */ 
/* 571 */       StatefulBeanContext bean = (StatefulBeanContext)nodeData.get("bean");
/*     */ 
/* 573 */       if (bean == null)
/*     */       {
/* 575 */         throw new IllegalStateException("nodeLoaded(): null bean instance.");
/*     */       }
/*     */ 
/* 578 */       StatefulTreeCache.this.passivatedCount -= 1;
/*     */ 
/* 580 */       if (StatefulTreeCache.this.log.isTraceEnabled())
/*     */       {
/* 582 */         StatefulTreeCache.this.log.trace("nodeLoaded(): send postActivate event to bean at fqn: " + fqn);
/*     */       }
/*     */ 
/* 585 */       ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/*     */       try
/*     */       {
/* 588 */         ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
/* 589 */         if (cl != null)
/*     */         {
/* 591 */           Thread.currentThread().setContextClassLoader(cl);
/*     */         }
/*     */ 
/* 594 */         bean.activateAfterReplication();
/*     */       }
/*     */       finally
/*     */       {
/* 598 */         Thread.currentThread().setContextClassLoader(oldCl);
/*     */       }
/*     */     }
/*     */ 
/*     */     @NodePassivated
/*     */     public void nodePassivated(NodePassivatedEvent event)
/*     */     {
/* 607 */       if (!event.isPre()) return;
/* 608 */       Fqn fqn = event.getFqn();
/* 609 */       if (fqn.size() != 3) return;
/* 610 */       if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) return;
/*     */ 
/* 612 */       StatefulBeanContext bean = null;
/* 613 */       ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/* 614 */       Boolean active = (Boolean)StatefulTreeCache.this.localActivity.get();
/*     */       try
/*     */       {
/* 617 */         StatefulTreeCache.this.localActivity.set(Boolean.TRUE);
/* 618 */         bean = (StatefulBeanContext)event.getData().get("bean");
/* 619 */         if (bean != null)
/*     */         {
/* 621 */           ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
/* 622 */           if (cl != null)
/*     */           {
/* 624 */             Thread.currentThread().setContextClassLoader(cl);
/*     */           }
/*     */ 
/* 627 */           if (!bean.getCanPassivate())
/*     */           {
/* 630 */             throw new ContextInUseException("Cannot passivate bean " + fqn + " -- it or one if its children is currently in use");
/*     */           }
/*     */ 
/* 634 */           if (StatefulTreeCache.this.log.isTraceEnabled())
/*     */           {
/* 636 */             StatefulTreeCache.this.log.trace("nodePassivated(): send prePassivate event to bean at fqn: " + fqn);
/*     */           }
/*     */ 
/* 639 */           bean.passivateAfterReplication();
/* 640 */           StatefulTreeCache.this.passivatedCount += 1;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NoSuchEJBException e)
/*     */       {
/* 647 */         if ((bean instanceof ProxiedStatefulBeanContext))
/*     */         {
/*     */           try
/*     */           {
/* 652 */             bean.getContainedIn();
/*     */ 
/* 654 */             throw e;
/*     */           }
/*     */           catch (NoSuchEJBException n)
/*     */           {
/* 658 */             StatefulTreeCache.this.log.debug("nodePassivated(): removing orphaned proxy at " + fqn);
/*     */             try
/*     */             {
/* 661 */               StatefulTreeCache.this.cache.removeNode(fqn);
/*     */             }
/*     */             catch (CacheException c)
/*     */             {
/* 665 */               StatefulTreeCache.this.log.error("nodePassivated(): could not remove orphaned proxy at " + fqn, c);
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 672 */           throw e;
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 677 */         Thread.currentThread().setContextClassLoader(oldCl);
/* 678 */         StatefulTreeCache.this.localActivity.set(active);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.tree.StatefulTreeCache
 * JD-Core Version:    0.6.0
 */