/*    */ package org.jboss.ejb3.cache.tree;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import java.util.List;
/*    */ import java.util.regex.Matcher;
/*    */ import java.util.regex.Pattern;
/*    */ import org.apache.commons.logging.Log;
/*    */ import org.apache.commons.logging.LogFactory;
/*    */ import org.jboss.cache.Fqn;
/*    */ import org.jboss.cache.loader.FileCacheLoader;
/*    */ 
/*    */ public class SFSBFileCacheLoader extends FileCacheLoader
/*    */ {
/* 35 */   Log log = LogFactory.getLog(SFSBFileCacheLoader.class);
/*    */ 
/*    */   protected boolean isCharacterPortableTree(Fqn fqn)
/*    */   {
/* 42 */     Pattern fqnPattern = Pattern.compile("[\\\\\\/:*<>|\"?]");
/*    */ 
/* 44 */     List elements = fqn.peekElements();
/* 45 */     for (Iterator i$ = elements.iterator(); i$.hasNext(); ) { Object anElement = i$.next();
/*    */ 
/* 47 */       Matcher matcher = fqnPattern.matcher(anElement.toString());
/* 48 */       if (matcher.find())
/*    */       {
/* 50 */         this.log.warn("One of the Fqn ( " + fqn + " ) elements contains one of these characters: '*' '<' '>' '|' '\"' '?' '\\' '/' ':' ");
/* 51 */         this.log.warn("Directories containing these characters are illegal in some operative systems and could lead to portability issues");
/* 52 */         return false;
/*    */       }
/*    */     }
/*    */ 
/* 56 */     return true;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.tree.SFSBFileCacheLoader
 * JD-Core Version:    0.6.0
 */