/*     */ package org.jboss.ejb3.cache.simple;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.serial.io.JBossObjectInputStream;
/*     */ import org.jboss.serial.io.JBossObjectOutputStream;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.util.id.UID;
/*     */ 
/*     */ public class StatefulSessionFilePersistenceManager
/*     */   implements StatefulSessionPersistenceManager
/*     */ {
/*     */   private String storeDirName;
/*     */   private File storeDir;
/*     */   private Container con;
/*     */   private boolean purgeEnabled;
/*     */ 
/*     */   public StatefulSessionFilePersistenceManager()
/*     */   {
/*  81 */     this.storeDirName = "sessions";
/*     */ 
/*  94 */     this.purgeEnabled = true;
/*     */   }
/*     */ 
/*     */   public void setStoreDirectoryName(String dirName)
/*     */   {
/* 112 */     this.storeDirName = dirName;
/*     */   }
/*     */ 
/*     */   public String getStoreDirectoryName()
/*     */   {
/* 124 */     return this.storeDirName;
/*     */   }
/*     */ 
/*     */   public void setPurgeEnabled(boolean flag)
/*     */   {
/* 134 */     this.purgeEnabled = flag;
/*     */   }
/*     */ 
/*     */   public boolean getPurgeEnabled()
/*     */   {
/* 144 */     return this.purgeEnabled;
/*     */   }
/*     */ 
/*     */   public File getStoreDirectory()
/*     */   {
/* 154 */     return this.storeDir;
/*     */   }
/*     */ 
/*     */   public void setContainer(Container con)
/*     */   {
/* 159 */     this.con = con;
/*     */   }
/*     */ 
/*     */   public void initialize(Container con)
/*     */     throws Exception
/*     */   {
/* 169 */     this.con = con;
/* 170 */     boolean debug = log.isDebugEnabled();
/*     */ 
/* 174 */     String ejbName = con.getEjbName();
/*     */ 
/* 177 */     File dir = ServerConfigLocator.locate().getServerTempDir();
/*     */ 
/* 180 */     dir = new File(dir, this.storeDirName);
/*     */ 
/* 182 */     dir = new File(dir, ejbName + "-" + new UID().toString());
/* 183 */     this.storeDir = dir;
/*     */ 
/* 185 */     if (debug)
/*     */     {
/* 187 */       log.debug("Storing sessions for '" + ejbName + "' in: " + this.storeDir);
/*     */     }
/*     */ 
/* 191 */     if (!this.storeDir.exists())
/*     */     {
/* 193 */       if (!MkdirsFileAction.mkdirs(this.storeDir))
/*     */       {
/* 195 */         throw new IOException("Failed to create directory: " + this.storeDir);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 200 */     if (!this.storeDir.isDirectory())
/*     */     {
/* 202 */       throw new IOException("File exists where directory expected: " + this.storeDir);
/*     */     }
/*     */ 
/* 206 */     if ((!this.storeDir.canWrite()) || (!this.storeDir.canRead()))
/*     */     {
/* 208 */       throw new IOException("Directory must be readable and writable: " + this.storeDir);
/*     */     }
/*     */ 
/* 212 */     purgeAllSessionData();
/*     */   }
/*     */ 
/*     */   public void purgeAllSessionData()
/*     */   {
/* 220 */     if (!this.purgeEnabled) return;
/*     */ 
/* 222 */     log.debug("Purging all session data in: " + this.storeDir);
/*     */ 
/* 224 */     File[] sessions = this.storeDir.listFiles();
/* 225 */     for (int i = 0; i < sessions.length; i++)
/*     */     {
/* 227 */       if (!sessions[i].delete())
/*     */       {
/* 229 */         log.warn("Failed to delete session state file: " + sessions[i]);
/*     */       }
/*     */       else
/*     */       {
/* 233 */         log.debug("Removed stale session state: " + sessions[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */     throws Exception
/*     */   {
/* 244 */     purgeAllSessionData();
/*     */ 
/* 247 */     if ((this.purgeEnabled) && (!this.storeDir.delete()))
/*     */     {
/* 249 */       log.warn("Failed to delete session state storage directory: " + this.storeDir);
/*     */     }
/*     */   }
/*     */ 
/*     */   private File getFile(Object id)
/*     */   {
/* 263 */     return new File(this.storeDir, String.valueOf(id) + ".ser");
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext activateSession(Object id)
/*     */   {
/* 272 */     boolean debug = log.isDebugEnabled();
/* 273 */     if (debug)
/*     */     {
/* 275 */       log.debug("Attempting to activate; id=" + id);
/*     */     }
/*     */ 
/* 279 */     File file = getFile(id);
/* 280 */     if (!file.exists()) return null;
/*     */ 
/* 282 */     if (debug)
/*     */     {
/* 284 */       log.debug("Reading session state from: " + file);
/*     */     }
/*     */ 
/* 287 */     StatefulBeanContext bean = null;
/*     */     try
/*     */     {
/* 290 */       FileInputStream fis = FISAction.open(file);
/*     */ 
/* 294 */       ObjectInputStream in = new JBossObjectInputStream(new BufferedInputStream(fis));
/*     */       try
/*     */       {
/* 297 */         bean = (StatefulBeanContext)in.readObject();
/*     */       }
/*     */       finally
/*     */       {
/* 301 */         fis.close();
/* 302 */         in.close();
/*     */       }
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 307 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 311 */       throw new EJBException("Could not activate; failed to restore state", e);
/*     */     }
/*     */ 
/* 315 */     removePassivated(id);
/*     */ 
/* 317 */     bean.postActivate();
/* 318 */     return bean;
/*     */   }
/*     */ 
/*     */   public List<StatefulBeanContext> getPassivatedBeans()
/*     */   {
/* 323 */     List beans = new LinkedList();
/*     */ 
/* 325 */     File[] files = this.storeDir.listFiles();
/* 326 */     for (File file : files)
/*     */     {
/*     */       try
/*     */       {
/* 332 */         FileInputStream fis = FISAction.open(file);
/*     */ 
/* 334 */         ObjectInputStream in = new JBossObjectInputStream(new BufferedInputStream(fis));
/*     */         try
/*     */         {
/* 337 */           StatefulBeanContext bean = (StatefulBeanContext)in.readObject();
/* 338 */           beans.add(bean);
/*     */         }
/*     */         finally
/*     */         {
/* 342 */           fis.close();
/* 343 */           in.close();
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 348 */         log.warn("Could not read for timeout removal for file " + file.getName(), e);
/*     */       }
/*     */     }
/*     */ 
/* 352 */     return beans;
/*     */   }
/*     */ 
/*     */   public void passivateSession(StatefulBeanContext ctx)
/*     */   {
/* 361 */     boolean debug = log.isDebugEnabled();
/* 362 */     if (debug)
/*     */     {
/* 364 */       log.debug("Attempting to passivate; id=" + ctx.getId());
/*     */     }
/*     */ 
/* 367 */     ctx.prePassivate();
/*     */ 
/* 370 */     File file = getFile(ctx.getId());
/* 371 */     if (debug)
/*     */     {
/* 373 */       log.debug("Saving session state to: " + file);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 378 */       FileOutputStream fos = FOSAction.open(file);
/*     */ 
/* 382 */       ObjectOutputStream out = new JBossObjectOutputStream(fos, false);
/*     */       try
/*     */       {
/* 386 */         out.writeObject(ctx);
/* 387 */         out.flush();
/* 388 */         fos.flush();
/* 389 */         fos.close();
/*     */       }
/*     */       finally
/*     */       {
/* 393 */         out.close();
/*     */       }
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 398 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 402 */       throw new EJBException("Could not passivate; failed to save state", e);
/*     */     }
/*     */ 
/* 405 */     if (debug)
/*     */     {
/* 407 */       log.debug("Passivation complete; id=" + ctx.getId());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removePassivated(Object id)
/*     */   {
/* 416 */     boolean debug = log.isDebugEnabled();
/*     */ 
/* 418 */     File file = getFile(id);
/*     */ 
/* 421 */     if (file.exists())
/*     */     {
/* 423 */       if (debug)
/*     */       {
/* 425 */         log.debug("Removing passivated state file: " + file);
/*     */       }
/*     */ 
/* 428 */       if (!DeleteFileAction.delete(file))
/*     */       {
/* 430 */         log.warn("Failed to delete passivated state file: " + file);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class FOSAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     FOSAction(File file)
/*     */     {
/* 519 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception
/*     */     {
/* 524 */       FileOutputStream fis = new FileOutputStream(this.file);
/* 525 */       return fis;
/*     */     }
/*     */ 
/*     */     static FileOutputStream open(File file) throws FileNotFoundException
/*     */     {
/* 530 */       FOSAction action = new FOSAction(file);
/* 531 */       FileOutputStream fos = null;
/*     */       try
/*     */       {
/* 534 */         fos = (FileOutputStream)AccessController.doPrivileged(action);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 538 */         throw ((FileNotFoundException)e.getException());
/*     */       }
/*     */ 
/* 541 */       return fos;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class FISAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     FISAction(File file)
/*     */     {
/* 487 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception
/*     */     {
/* 492 */       FileInputStream fis = new FileInputStream(this.file);
/* 493 */       return fis;
/*     */     }
/*     */ 
/*     */     static FileInputStream open(File file) throws FileNotFoundException
/*     */     {
/* 498 */       FISAction action = new FISAction(file);
/* 499 */       FileInputStream fis = null;
/*     */       try
/*     */       {
/* 502 */         fis = (FileInputStream)AccessController.doPrivileged(action);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 506 */         throw ((FileNotFoundException)e.getException());
/*     */       }
/*     */ 
/* 509 */       return fis;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class MkdirsFileAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     MkdirsFileAction(File file)
/*     */     {
/* 464 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 469 */       boolean ok = this.file.mkdirs();
/* 470 */       return new Boolean(ok);
/*     */     }
/*     */ 
/*     */     static boolean mkdirs(File file)
/*     */     {
/* 475 */       MkdirsFileAction action = new MkdirsFileAction(file);
/* 476 */       Boolean ok = (Boolean)AccessController.doPrivileged(action);
/* 477 */       return ok.booleanValue();
/*     */     }
/*     */   }
/*     */ 
/*     */   static class DeleteFileAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     DeleteFileAction(File file)
/*     */     {
/* 441 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 446 */       boolean deleted = this.file.delete();
/* 447 */       return new Boolean(deleted);
/*     */     }
/*     */ 
/*     */     static boolean delete(File file)
/*     */     {
/* 452 */       DeleteFileAction action = new DeleteFileAction(file);
/* 453 */       Boolean deleted = (Boolean)AccessController.doPrivileged(action);
/* 454 */       return deleted.booleanValue();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.simple.StatefulSessionFilePersistenceManager
 * JD-Core Version:    0.6.0
 */