/*    */ package org.jboss.ejb3.cache.persistence;
/*    */ 
/*    */ import java.util.Map;
/*    */ 
/*    */ public class PersistenceManagerFactoryRegistry
/*    */ {
/*    */   private Map<String, Class<? extends PersistenceManagerFactory>> factories;
/*    */ 
/*    */   public Map<String, Class<? extends PersistenceManagerFactory>> getFactories()
/*    */   {
/* 41 */     return this.factories;
/*    */   }
/*    */ 
/*    */   public void setFactories(Map<String, Class<? extends PersistenceManagerFactory>> factories)
/*    */   {
/* 46 */     this.factories = factories;
/*    */   }
/*    */ 
/*    */   public PersistenceManagerFactory getPersistenceManagerFactory(String name)
/*    */     throws PersistenceManagerFactoryNotRegisteredException
/*    */   {
/* 60 */     Class persistenceManagerFactory = (Class)this.factories.get(name);
/*    */ 
/* 63 */     if (persistenceManagerFactory == null)
/*    */     {
/* 65 */       throw new PersistenceManagerFactoryNotRegisteredException("PersistenceManager Factory with name " + name + " is not registered.");
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 71 */       return (PersistenceManagerFactory)persistenceManagerFactory.newInstance();
/*    */     }
/*    */     catch (InstantiationException e)
/*    */     {
/* 75 */       throw new RuntimeException("Error in instanciating persistence manager factory " + persistenceManagerFactory.getName(), e);
/*    */     }
/*    */     catch (IllegalAccessException e) {
/*    */     }
/* 79 */     throw new RuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry
 * JD-Core Version:    0.6.0
 */