/*     */ package org.jboss.ejb3.cache.impl;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.ejb.NoSuchEJBException;
/*     */ import org.jboss.ejb3.cache.Cache;
/*     */ import org.jboss.ejb3.cache.Identifiable;
/*     */ import org.jboss.ejb3.cache.LongevityCache;
/*     */ 
/*     */ public class SimpleLongevityCache<T extends Identifiable>
/*     */   implements LongevityCache<T>
/*     */ {
/*     */   private Cache<T> delegate;
/*     */   private Map<Object, SimpleLongevityCache<T>.Entry> cache;
/*     */ 
/*     */   public SimpleLongevityCache(Cache<T> delegate)
/*     */   {
/*  65 */     assert (delegate != null) : "delegate is null";
/*     */ 
/*  67 */     this.delegate = delegate;
/*  68 */     this.cache = new HashMap();
/*     */   }
/*     */ 
/*     */   public void finished(T obj)
/*     */   {
/*  73 */     synchronized (this.cache)
/*     */     {
/*  75 */       Entry entry = (Entry)this.cache.get(obj.getId());
/*  76 */       if (entry.state != State.IN_OPERATION)
/*  77 */         throw new IllegalStateException("entry " + entry + " is not in operation");
/*  78 */       entry.state = State.FINISHED;
/*  79 */       entry.lastUsed = System.currentTimeMillis();
/*     */     }
/*     */   }
/*     */ 
/*     */   public T create(Class<?>[] initTypes, Object[] initValues)
/*     */   {
/*  85 */     Identifiable obj = this.delegate.create(initTypes, initValues);
/*  86 */     Entry entry = new Entry(obj);
/*  87 */     synchronized (this.cache)
/*     */     {
/*  89 */       this.cache.put(obj.getId(), entry);
/*     */     }
/*  91 */     return obj;
/*     */   }
/*     */ 
/*     */   public T get(Object key) throws NoSuchEJBException
/*     */   {
/*  96 */     synchronized (this.cache)
/*     */     {
/*  98 */       Entry entry = (Entry)this.cache.get(key);
/*  99 */       if (entry == null)
/*     */       {
/* 101 */         Identifiable obj = this.delegate.get(key);
/* 102 */         entry = new Entry(obj);
/* 103 */         this.cache.put(obj.getId(), entry);
/* 104 */         return obj;
/*     */       }
/* 106 */       if (entry.state != State.FINISHED)
/* 107 */         throw new IllegalStateException("entry " + entry + " is not finished");
/* 108 */       entry.state = State.IN_OPERATION;
/* 109 */       entry.lastUsed = System.currentTimeMillis();
/* 110 */       return entry.obj;
/*     */     }
/*     */   }
/*     */ 
/*     */   public T peek(Object key)
/*     */     throws NoSuchEJBException
/*     */   {
/* 117 */     return this.delegate.peek(key);
/*     */   }
/*     */ 
/*     */   public void release(T obj)
/*     */   {
/* 122 */     synchronized (this.cache)
/*     */     {
/* 124 */       Object key = obj.getId();
/* 125 */       Entry entry = (Entry)this.cache.get(key);
/* 126 */       if (entry.state != State.FINISHED)
/* 127 */         throw new IllegalStateException("entry " + entry + " is not finished");
/* 128 */       this.delegate.release(obj);
/* 129 */       this.cache.remove(key);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/* 136 */     this.delegate.remove(key);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 141 */     this.delegate.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 146 */     this.delegate.stop();
/*     */   }
/*     */ 
/*     */   private class Entry
/*     */   {
/*     */     long lastUsed;
/*     */     T obj;
/*     */     SimpleLongevityCache.State state;
/*     */ 
/*     */     Entry()
/*     */     {
/*  55 */       assert (obj != null) : "obj is null";
/*     */ 
/*  57 */       this.lastUsed = System.currentTimeMillis();
/*  58 */       this.obj = obj;
/*  59 */       this.state = SimpleLongevityCache.State.IN_OPERATION;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static enum State
/*     */   {
/*  45 */     FINISHED, IN_OPERATION;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.impl.SimpleLongevityCache
 * JD-Core Version:    0.6.0
 */