/*     */ package org.jboss.ejb3.cache.impl;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.ejb.NoSuchEJBException;
/*     */ import org.jboss.ejb3.cache.Cache;
/*     */ import org.jboss.ejb3.cache.Identifiable;
/*     */ import org.jboss.ejb3.cache.StatefulObjectFactory;
/*     */ 
/*     */ public class EntryStateCache<T extends Identifiable>
/*     */   implements Cache<T>
/*     */ {
/*     */   private StatefulObjectFactory<T> factory;
/*     */   private Map<Object, EntryStateCache<T>.Entry> cache;
/*     */ 
/*     */   public EntryStateCache(StatefulObjectFactory<T> factory)
/*     */   {
/*  64 */     assert (factory != null) : "factory is null";
/*     */ 
/*  66 */     this.factory = factory;
/*  67 */     this.cache = new HashMap();
/*     */   }
/*     */ 
/*     */   public T create(Class<?>[] initTypes, Object[] initValues)
/*     */   {
/*  72 */     Identifiable obj = (Identifiable)this.factory.create(initTypes, initValues);
/*  73 */     Entry entry = new Entry(obj);
/*  74 */     synchronized (this.cache)
/*     */     {
/*  76 */       this.cache.put(obj.getId(), entry);
/*     */     }
/*  78 */     return obj;
/*     */   }
/*     */ 
/*     */   public T get(Object key) throws NoSuchEJBException
/*     */   {
/*  83 */     synchronized (this.cache)
/*     */     {
/*  85 */       Entry entry = (Entry)this.cache.get(key);
/*  86 */       if (entry == null)
/*  87 */         throw new NoSuchEJBException(String.valueOf(key));
/*  88 */       if (entry.state != State.READY)
/*  89 */         throw new IllegalStateException("entry " + entry + " is not ready");
/*  90 */       entry.state = State.IN_USE;
/*  91 */       entry.lastUsed = System.currentTimeMillis();
/*  92 */       return entry.obj;
/*     */     }
/*     */   }
/*     */ 
/*     */   public T peek(Object key) throws NoSuchEJBException
/*     */   {
/*  98 */     synchronized (this.cache)
/*     */     {
/* 100 */       Entry entry = (Entry)this.cache.get(key);
/* 101 */       if (entry == null)
/* 102 */         throw new NoSuchEJBException(String.valueOf(key));
/* 103 */       return entry.obj;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void release(T obj)
/*     */   {
/* 109 */     synchronized (this.cache)
/*     */     {
/* 111 */       Entry entry = (Entry)this.cache.get(obj.getId());
/* 112 */       if (entry.state != State.IN_USE)
/* 113 */         throw new IllegalStateException("entry " + entry + " is not in use");
/* 114 */       entry.state = State.READY;
/* 115 */       entry.lastUsed = System.currentTimeMillis();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/*     */     Entry entry;
/* 122 */     synchronized (this.cache)
/*     */     {
/* 124 */       entry = (Entry)this.cache.remove(key);
/* 125 */       if (entry.state != State.READY)
/* 126 */         throw new IllegalStateException("entry " + entry + " is not ready");
/*     */     }
/* 128 */     if (entry != null)
/* 129 */       this.factory.destroy(entry.obj);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   private class Entry
/*     */   {
/*     */     long lastUsed;
/*     */     T obj;
/*     */     EntryStateCache.State state;
/*     */ 
/*     */     Entry()
/*     */     {
/*  54 */       assert (obj != null) : "obj is null";
/*     */ 
/*  56 */       this.lastUsed = System.currentTimeMillis();
/*  57 */       this.obj = obj;
/*  58 */       this.state = EntryStateCache.State.IN_USE;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static enum State
/*     */   {
/*  44 */     READY, IN_USE;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.impl.EntryStateCache
 * JD-Core Version:    0.6.0
 */