/*     */ package org.jboss.ejb3.cache;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Stack;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*     */ import org.jboss.ejb3.stateful.StatefulContainer;
/*     */ import org.jboss.ejb3.stateful.StatefulContainerInvocation;
/*     */ 
/*     */ public class StatefulReplicationInterceptor
/*     */   implements Interceptor
/*     */ {
/*  44 */   private static final ThreadLocal<Map<StatefulBeanContext, Stack<Boolean>>> replicationContext = new ThreadLocal();
/*     */ 
/*     */   public String getName()
/*     */   {
/*  49 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  57 */     StatefulContainerInvocation ejbInv = (StatefulContainerInvocation)invocation;
/*  58 */     StatefulBeanContext ctx = (StatefulBeanContext)ejbInv.getBeanContext();
/*  59 */     StatefulBeanContext root = ctx.getUltimateContainedIn();
/*     */ 
/*  62 */     boolean clustered = false;
/*  63 */     StatefulContainer container = (StatefulContainer)root.getContainer();
/*  64 */     ClusteredStatefulCache clusteredCache = null;
/*  65 */     if ((container.getCache() instanceof ClusteredStatefulCache))
/*     */     {
/*  67 */       clustered = true;
/*  68 */       clusteredCache = (ClusteredStatefulCache)container.getCache();
/*     */     }
/*     */ 
/*  73 */     if (clustered) {
/*  74 */       pushCallStack(root);
/*     */     }
/*  76 */     boolean stackUnwound = false;
/*  77 */     Object rtn = null;
/*     */     try
/*     */     {
/*  80 */       rtn = invocation.invokeNext();
/*     */     }
/*     */     finally
/*     */     {
/*  84 */       stackUnwound = (clustered) && (isCallStackUnwound(root));
/*     */     }
/*     */ 
/*  90 */     boolean mustReplicate = clustered;
/*     */ 
/*  95 */     Object obj = invocation.getTargetObject();
/*  96 */     if ((obj instanceof Optimized))
/*     */     {
/*  98 */       if (!((Optimized)obj).isModified())
/*     */       {
/* 100 */         mustReplicate = false;
/*     */       }
/*     */     }
/*     */ 
/* 104 */     if (mustReplicate)
/*     */     {
/* 109 */       root.markedForReplication = true;
/*     */     }
/*     */ 
/* 112 */     if ((stackUnwound) && (root.markedForReplication))
/*     */     {
/* 114 */       clusteredCache.replicate(root);
/*     */     }
/*     */ 
/* 117 */     if ((ctx != root) && (ctx.markedForReplication))
/*     */     {
/* 122 */       container = (StatefulContainer)ctx.getContainer();
/* 123 */       StatefulCache cache = container.getCache();
/* 124 */       if ((cache instanceof ClusteredStatefulCache))
/*     */       {
/* 126 */         clusteredCache = (ClusteredStatefulCache)cache;
/* 127 */         clusteredCache.replicate(ctx);
/*     */       }
/*     */       else
/*     */       {
/* 132 */         ctx.markedForReplication = false;
/*     */       }
/*     */     }
/*     */ 
/* 136 */     return rtn;
/*     */   }
/*     */ 
/*     */   private static void pushCallStack(StatefulBeanContext ctx)
/*     */   {
/* 141 */     Stack callStack = null;
/* 142 */     Map map = (Map)replicationContext.get();
/* 143 */     if (map == null)
/*     */     {
/* 145 */       map = new HashMap();
/* 146 */       replicationContext.set(map);
/*     */     }
/*     */     else
/*     */     {
/* 150 */       callStack = (Stack)map.get(ctx);
/*     */     }
/*     */ 
/* 153 */     if (callStack == null)
/*     */     {
/* 155 */       callStack = new Stack();
/* 156 */       map.put(ctx, callStack);
/*     */     }
/*     */ 
/* 159 */     callStack.push(Boolean.TRUE);
/*     */   }
/*     */ 
/*     */   private static boolean isCallStackUnwound(StatefulBeanContext ctx)
/*     */   {
/* 164 */     Map map = (Map)replicationContext.get();
/* 165 */     if (map == null)
/*     */     {
/* 167 */       throw new IllegalStateException("replicationContext contains no Map");
/*     */     }
/* 169 */     Stack callStack = (Stack)map.get(ctx);
/* 170 */     if (callStack == null)
/*     */     {
/* 172 */       throw new IllegalStateException("replicationContext contains no call stack");
/*     */     }
/*     */ 
/* 175 */     callStack.pop();
/* 176 */     boolean unwound = callStack.size() == 0;
/*     */ 
/* 178 */     if (unwound)
/*     */     {
/* 180 */       map.remove(ctx);
/* 181 */       if (map.size() == 0)
/*     */       {
/* 183 */         replicationContext.set(null);
/*     */       }
/*     */     }
/*     */ 
/* 187 */     return unwound;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.StatefulReplicationInterceptor
 * JD-Core Version:    0.6.0
 */