/*     */ package org.jboss.ejb3.cache;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchEJBException;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.pool.Pool;
/*     */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*     */ 
/*     */ public class NoPassivationCache
/*     */   implements StatefulCache
/*     */ {
/*     */   private Pool pool;
/*     */   private HashMap<Object, StatefulBeanContext> cacheMap;
/*  41 */   private int createCount = 0;
/*  42 */   private int removeCount = 0;
/*     */ 
/*     */   public void initialize(Container container) throws Exception
/*     */   {
/*  46 */     this.pool = container.getPool();
/*  47 */     this.cacheMap = new HashMap();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*  60 */     synchronized (this.cacheMap)
/*     */     {
/*  62 */       this.cacheMap.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext create()
/*     */   {
/*  68 */     return create(null, null);
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext create(Class[] initTypes, Object[] initValues)
/*     */   {
/*  73 */     StatefulBeanContext ctx = null;
/*     */     try
/*     */     {
/*  76 */       ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
/*  77 */       this.createCount += 1;
/*  78 */       synchronized (this.cacheMap)
/*     */       {
/*  80 */         this.cacheMap.put(ctx.getId(), ctx);
/*     */       }
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/*  85 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  89 */       throw new EJBException(e);
/*     */     }
/*  91 */     return ctx;
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext get(Object key) throws EJBException
/*     */   {
/*  96 */     return get(key, true);
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException
/*     */   {
/* 101 */     StatefulBeanContext entry = null;
/* 102 */     synchronized (this.cacheMap)
/*     */     {
/* 104 */       entry = (StatefulBeanContext)this.cacheMap.get(key);
/*     */     }
/*     */ 
/* 107 */     if (entry == null)
/*     */     {
/* 109 */       throw new NoSuchEJBException("Could not find Stateful bean: " + key);
/*     */     }
/*     */ 
/* 112 */     if (markInUse)
/*     */     {
/* 114 */       if (entry.isRemoved())
/*     */       {
/* 116 */         throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed");
/*     */       }
/*     */ 
/* 120 */       entry.setInUse(true);
/* 121 */       entry.lastUsed = System.currentTimeMillis();
/*     */     }
/*     */ 
/* 124 */     return entry;
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext peek(Object key) throws NoSuchEJBException
/*     */   {
/* 129 */     return get(key, false);
/*     */   }
/*     */ 
/*     */   public void release(StatefulBeanContext ctx)
/*     */   {
/* 134 */     synchronized (ctx)
/*     */     {
/* 136 */       ctx.setInUse(false);
/* 137 */       ctx.lastUsed = System.currentTimeMillis();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/* 143 */     StatefulBeanContext ctx = null;
/* 144 */     synchronized (this.cacheMap)
/*     */     {
/* 146 */       ctx = (StatefulBeanContext)this.cacheMap.remove(key);
/*     */     }
/* 148 */     if (ctx != null)
/*     */     {
/* 150 */       this.pool.remove(ctx);
/* 151 */       this.removeCount += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getCacheSize()
/*     */   {
/* 157 */     return this.cacheMap.size();
/*     */   }
/*     */ 
/*     */   public int getTotalSize()
/*     */   {
/* 162 */     return this.cacheMap.size();
/*     */   }
/*     */ 
/*     */   public int getCreateCount()
/*     */   {
/* 167 */     return this.createCount;
/*     */   }
/*     */ 
/*     */   public int getPassivatedCount()
/*     */   {
/* 172 */     return 0;
/*     */   }
/*     */ 
/*     */   public int getRemoveCount()
/*     */   {
/* 177 */     return this.removeCount;
/*     */   }
/*     */ 
/*     */   public int getAvailableCount()
/*     */   {
/* 182 */     return -1;
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 187 */     return -1;
/*     */   }
/*     */ 
/*     */   public int getCurrentSize()
/*     */   {
/* 192 */     return this.cacheMap.size();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.NoPassivationCache
 * JD-Core Version:    0.6.0
 */