/*     */ package org.jboss.ejb3.asynchronous;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aspects.asynch.AsynchAspect;
/*     */ import org.jboss.aspects.asynch.ExecutorAbstraction;
/*     */ import org.jboss.aspects.asynch.Future;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.aspects.asynch.ThreadPoolExecutor;
/*     */ import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.tm.TransactionPropagationContextFactory;
/*     */ import org.jboss.tm.TransactionPropagationContextUtil;
/*     */ 
/*     */ public class AsynchronousInterceptor extends AsynchAspect
/*     */   implements Interceptor
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(AsynchronousInterceptor.class);
/*     */   public static final String ASYNCH = "ASYNCH";
/*     */   public static final String INVOKE_ASYNCH = "INVOKE_ASYNCH";
/*     */   public static final String FUTURE_HOLDER = "FUTURE_HOLDER";
/*     */ 
/*     */   public AsynchronousInterceptor()
/*     */   {
/*     */     try
/*     */     {
/*  57 */       this.executor = ((ExecutorAbstraction)ThreadPoolExecutor.class.newInstance());
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/*  61 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/*  65 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  71 */     return "AsynchronousInterceptor";
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  76 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/*  78 */     if (invocation.getMetaData("ASYNCH", "INVOKE_ASYNCH") != null)
/*     */     {
/*  81 */       InvokerLocator locator = (InvokerLocator)invocation.getMetaData("REMOTING", "INVOKER_LOCATOR");
/*  82 */       if (locator == null)
/*     */       {
/*  86 */         TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
/*  87 */         if (tpcFactory != null)
/*     */         {
/*  89 */           Object tpc = tpcFactory.getTransactionPropagationContext();
/*  90 */           if (tpc != null)
/*     */           {
/*  92 */             invocation.getMetaData().addMetaData(ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, tpc);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*  97 */         Principal principal = SecurityAssociation.getPrincipal();
/*  98 */         if (principal != null) invocation.getMetaData().addMetaData("security", "principal", principal);
/*     */ 
/* 100 */         Object credential = SecurityAssociation.getCredential();
/* 101 */         if (credential != null) invocation.getMetaData().addMetaData("security", "credential", credential);
/*     */       }
/*     */ 
/* 104 */       return super.execute(mi);
/*     */     }
/* 106 */     return mi.invokeNext();
/*     */   }
/*     */ 
/*     */   protected void setupLocalFuture(MethodInvocation invocation, Future future)
/*     */   {
/* 112 */     FutureHolder provider = (FutureHolder)invocation.getMetaData("ASYNCH", "FUTURE_HOLDER");
/* 113 */     provider.setFuture(future);
/*     */   }
/*     */ 
/*     */   protected boolean generateProxy()
/*     */   {
/* 123 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.asynchronous.AsynchronousInterceptor
 * JD-Core Version:    0.6.0
 */