/*     */ package org.jboss.ejb3.annotation.impl;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.util.Debugger;
/*     */ 
/*     */ public class RemoteBindingImpl
/*     */   implements RemoteBinding
/*     */ {
/*     */   private String jndi;
/*     */   private String stack;
/*     */   private String bindUrl;
/*     */   private String proxyFactory;
/*     */   private StackTraceElement constructionPoint;
/*     */ 
/*     */   public RemoteBindingImpl()
/*     */   {
/*  50 */     this.jndi = "";
/*  51 */     this.stack = "";
/*  52 */     this.bindUrl = "";
/*  53 */     this.proxyFactory = "RemoteProxyFactory";
/*     */ 
/*  55 */     this.constructionPoint = Debugger.constructionPoint();
/*     */   }
/*     */ 
/*     */   public RemoteBindingImpl(String jndi, String stack, String bindUrl, String proxyFactory)
/*     */   {
/*  60 */     this.jndi = jndi;
/*  61 */     this.stack = stack;
/*  62 */     this.bindUrl = bindUrl;
/*  63 */     this.proxyFactory = proxyFactory;
/*     */ 
/*  65 */     this.constructionPoint = Debugger.constructionPoint();
/*     */   }
/*     */ 
/*     */   public void setStack(String stack)
/*     */   {
/*  70 */     this.stack = stack;
/*     */   }
/*     */ 
/*     */   public void setFactory(String factory)
/*     */   {
/*  75 */     this.proxyFactory = factory;
/*     */   }
/*     */ 
/*     */   public void setJndiBinding(String jndi)
/*     */   {
/*  80 */     this.jndi = jndi;
/*     */   }
/*     */ 
/*     */   public void setBindUrl(String bindUrl)
/*     */   {
/*  85 */     this.bindUrl = bindUrl;
/*     */   }
/*     */ 
/*     */   public String jndiBinding()
/*     */   {
/*  90 */     return this.jndi;
/*     */   }
/*     */ 
/*     */   public String interceptorStack()
/*     */   {
/*  95 */     return this.stack;
/*     */   }
/*     */ 
/*     */   public String clientBindUrl()
/*     */   {
/* 100 */     return this.bindUrl;
/*     */   }
/*     */ 
/*     */   public String factory()
/*     */   {
/* 105 */     return this.proxyFactory;
/*     */   }
/*     */ 
/*     */   public void merge(RemoteBinding annotation)
/*     */   {
/* 110 */     if (this.jndi.length() == 0) {
/* 111 */       this.jndi = annotation.jndiBinding();
/*     */     }
/* 113 */     if (this.stack.length() == 0) {
/* 114 */       this.stack = annotation.interceptorStack();
/*     */     }
/* 116 */     if (this.bindUrl.length() == 0) {
/* 117 */       this.bindUrl = annotation.clientBindUrl();
/*     */     }
/* 119 */     if (this.proxyFactory.equals("RemoteProxyFactory"))
/* 120 */       this.proxyFactory = annotation.factory();
/*     */   }
/*     */ 
/*     */   public Class<? extends Annotation> annotationType()
/*     */   {
/* 126 */     return RemoteBinding.class;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 131 */     StringBuffer sb = new StringBuffer(100);
/* 132 */     sb.append("[RemoteBindingImpl:");
/* 133 */     sb.append(", jndi=" + this.jndi);
/* 134 */     sb.append(", stack=" + this.stack);
/* 135 */     sb.append(", bindUrl=" + this.bindUrl);
/* 136 */     sb.append(", proxyFactory=" + this.proxyFactory);
/* 137 */     sb.append(", constructionPoint=" + this.constructionPoint);
/* 138 */     sb.append(']');
/* 139 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.annotation.impl.RemoteBindingImpl
 * JD-Core Version:    0.6.0
 */