/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ public class SecurityActions
/*     */ {
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 116 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader(Thread thread)
/*     */   {
/* 121 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader(thread);
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(ClassLoader loader)
/*     */   {
/* 126 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(loader);
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(Thread thread, ClassLoader loader)
/*     */   {
/* 131 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(thread, loader);
/*     */   }
/*     */ 
/*     */   static String setContextID(String contextID)
/*     */   {
/* 136 */     PrivilegedAction action = new SetContextID(contextID);
/* 137 */     String previousID = (String)AccessController.doPrivileged(action);
/* 138 */     return previousID;
/*     */   }
/*     */ 
/*     */   public static RunAsIdentity peekRunAsIdentity(int depth)
/*     */   {
/* 143 */     PrivilegedAction action = new PeekRunAsRoleAction(depth);
/* 144 */     RunAsIdentity principal = (RunAsIdentity)AccessController.doPrivileged(action);
/* 145 */     return principal;
/*     */   }
/*     */ 
/*     */   public static Subject getActiveSubject()
/*     */   {
/* 150 */     Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
/* 151 */     return subject;
/*     */   }
/*     */ 
/*     */   public static void pushRunAsIdentity(RunAsIdentity runAsIdentity)
/*     */   {
/* 156 */     PrivilegedAction action = new PushRunAsIdentityAction(runAsIdentity);
/* 157 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   public static void pushRunAs(RunAsIdentity runAsIdentity)
/*     */   {
/* 162 */     AccessController.doPrivileged(new PrivilegedAction(runAsIdentity)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 166 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 167 */         sc.setOutgoingRunAs(this.val$runAsIdentity);
/* 168 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static SecurityContext getSecurityContext() {
/* 175 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 180 */         return SecurityContextAssociation.getSecurityContext();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static RunAsIdentity popRunAsIdentity()
/*     */   {
/* 188 */     return (RunAsIdentity)AccessController.doPrivileged(PopRunAsIdentityAction.ACTION);
/*     */   }
/*     */ 
/*     */   public static RunAsIdentity popRunAs()
/*     */   {
/* 193 */     return (RunAsIdentity)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 197 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 198 */         RunAsIdentity ra = (RunAsIdentity)sc.getOutgoingRunAs();
/* 199 */         sc.setOutgoingRunAs(null);
/* 200 */         return ra;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static SecurityContext createSecurityContext(String securityDomain)
/*     */     throws PrivilegedActionException
/*     */   {
/* 320 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(securityDomain)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 324 */         return SecurityContextFactory.createSecurityContext(this.val$securityDomain);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 235 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 239 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 244 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 249 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 254 */         thread.setContextClassLoader(cl);
/*     */       }
/* 235 */     };
/*     */ 
/* 258 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 260 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 264 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 260 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 270 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 275 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 279 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 286 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 290 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 291 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl) {
/* 298 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 302 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 303 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 258 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityActions.TCLAction getTCLAction()
/*     */       {
/* 211 */         return System.getSecurityManager() == null ? SecurityActions.TCLAction.NON_PRIVILEGED : SecurityActions.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 216 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 221 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 226 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 231 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class PushRunAsIdentityAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     RunAsIdentity runAsIdentity;
/*     */ 
/*     */     PushRunAsIdentityAction(RunAsIdentity runAsIdentity)
/*     */     {
/* 104 */       this.runAsIdentity = runAsIdentity;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 109 */       SecurityAssociation.pushRunAsIdentity(this.runAsIdentity);
/* 110 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class PopRunAsIdentityAction
/*     */     implements PrivilegedAction
/*     */   {
/*  91 */     static PrivilegedAction ACTION = new PopRunAsIdentityAction();
/*     */ 
/*     */     public Object run() {
/*  94 */       return SecurityAssociation.popRunAsIdentity();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetSubjectAction
/*     */     implements PrivilegedAction
/*     */   {
/*  81 */     static PrivilegedAction ACTION = new GetSubjectAction();
/*     */ 
/*     */     public Object run() {
/*  84 */       Subject subject = SecurityAssociation.getSubject();
/*  85 */       return subject;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class PeekRunAsRoleAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     int depth;
/*     */ 
/*     */     PeekRunAsRoleAction(int depth)
/*     */     {
/*  69 */       this.depth = depth;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/*  74 */       RunAsIdentity principal = SecurityAssociation.peekRunAsIdentity(this.depth);
/*  75 */       return principal;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class SetContextID
/*     */     implements PrivilegedAction
/*     */   {
/*     */     String contextID;
/*     */ 
/*     */     SetContextID(String contextID)
/*     */     {
/*  52 */       this.contextID = contextID;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/*  57 */       String previousID = PolicyContext.getContextID();
/*  58 */       PolicyContext.setContextID(this.contextID);
/*  59 */       return previousID;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.SecurityActions
 * JD-Core Version:    0.6.0
 */