/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.concurrent.ConcurrentHashMap;
/*    */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class PersistenceUnitRegistry
/*    */ {
/* 35 */   private static final Logger log = Logger.getLogger(PersistenceUnitRegistry.class);
/*    */ 
/* 37 */   private static ConcurrentHashMap<String, PersistenceUnitDeployment> persistenceUnits = new ConcurrentHashMap();
/*    */ 
/*    */   public static void register(PersistenceUnitDeployment container)
/*    */   {
/* 41 */     if (persistenceUnits.contains(container.getKernelName())) throw new RuntimeException("Persistence Unit is already registered: " + container.getKernelName());
/* 42 */     persistenceUnits.put(container.getKernelName(), container);
/*    */   }
/*    */ 
/*    */   public static void unregister(PersistenceUnitDeployment container)
/*    */   {
/* 47 */     persistenceUnits.remove(container.getKernelName());
/*    */   }
/*    */ 
/*    */   public static PersistenceUnitDeployment getPersistenceUnit(String kernelName)
/*    */   {
/* 52 */     return (PersistenceUnitDeployment)persistenceUnits.get(kernelName);
/*    */   }
/*    */ 
/*    */   public static Collection<PersistenceUnitDeployment> getPersistenceUnits()
/*    */   {
/* 57 */     return persistenceUnits.values();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.PersistenceUnitRegistry
 * JD-Core Version:    0.6.0
 */